/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrainput;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.cassandra.CassandraColumnMetaData;
import org.pentaho.cassandra.CassandraConnection;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInput;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputData;
import org.pentaho.di.trans.steps.cassandrainput.CassandraInputDialog;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Step(id="CassandraInput", image="Cassandra.png", name="Cassandra Input", description="Reads data from a Cassandra table", categoryDescription="Big Data")
public class CassandraInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    protected static final Class<?> PKG = CassandraInputMeta.class;
    protected String m_cassandraHost = "localhost";
    protected String m_cassandraPort = "9160";
    protected String m_username;
    protected String m_password;
    protected String m_cassandraKeyspace;
    protected boolean m_useCompression;
    protected String m_cqlSelectQuery = "SELECT <fields> FROM <column family> WHERE <condition>;";
    protected boolean m_outputKeyValueTimestampTuples;
    protected boolean m_useThriftIO = false;
    protected String m_socketTimeout = "";
    protected boolean m_isSelectStarQuery = false;
    protected int m_rowLimit = -1;
    protected int m_colLimit = -1;
    protected int m_rowBatchSize = 100;
    protected int m_colBatchSize = 100;
    protected List<String> m_specificCols;

    public void setSocketTimeout(String t) {
        this.m_socketTimeout = t;
    }

    public String getSocketTimeout() {
        return this.m_socketTimeout;
    }

    public void setUseThriftIO(boolean useThrift) {
        this.m_useThriftIO = useThrift;
    }

    public boolean getUseThriftIO() {
        return this.m_useThriftIO;
    }

    public void setCassandraHost(String host) {
        this.m_cassandraHost = host;
    }

    public String getCassandraHost() {
        return this.m_cassandraHost;
    }

    public void setCassandraPort(String port) {
        this.m_cassandraPort = port;
    }

    public String getCassandraPort() {
        return this.m_cassandraPort;
    }

    public void setCassandraKeyspace(String keyspace) {
        this.m_cassandraKeyspace = keyspace;
    }

    public String getCassandraKeyspace() {
        return this.m_cassandraKeyspace;
    }

    public void setUseCompression(boolean c) {
        this.m_useCompression = c;
    }

    public boolean getUseCompression() {
        return this.m_useCompression;
    }

    public void setCQLSelectQuery(String query) {
        this.m_cqlSelectQuery = query;
    }

    public String getCQLSelectQuery() {
        return this.m_cqlSelectQuery;
    }

    public void setUsername(String un) {
        this.m_username = un;
    }

    public String getUsername() {
        return this.m_username;
    }

    public void setPassword(String pass) {
        this.m_password = pass;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setOutputKeyValueTimestampTuples(boolean o) {
        this.m_outputKeyValueTimestampTuples = o;
    }

    public boolean getOutputKeyValueTimestampTuples() {
        return this.m_outputKeyValueTimestampTuples;
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        if (!Const.isEmpty((String)this.m_cassandraHost)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_host", (String)this.m_cassandraHost));
        }
        if (!Const.isEmpty((String)this.m_cassandraPort)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_port", (String)this.m_cassandraPort));
        }
        if (!Const.isEmpty((String)this.m_username)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"username", (String)this.m_username));
        }
        if (!Const.isEmpty((String)this.m_password)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.m_password)));
        }
        if (!Const.isEmpty((String)this.m_cassandraKeyspace)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cassandra_keyspace", (String)this.m_cassandraKeyspace));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"use_compression", (boolean)this.m_useCompression));
        if (!Const.isEmpty((String)this.m_cqlSelectQuery)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"cql_select_query", (String)this.m_cqlSelectQuery));
        }
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"output_key_value_timestamp_tuples", (boolean)this.m_outputKeyValueTimestampTuples));
        retval.append("\n    ").append(XMLHandler.addTagValue((String)"use_thrift_io", (boolean)this.m_useThriftIO));
        if (!Const.isEmpty((String)this.m_socketTimeout)) {
            retval.append("\n    ").append(XMLHandler.addTagValue((String)"socket_timeout", (String)this.m_socketTimeout));
        }
        return retval.toString();
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        String thrift;
        this.m_cassandraHost = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_host");
        this.m_cassandraPort = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_port");
        this.m_username = XMLHandler.getTagValue((Node)stepnode, (String)"username");
        this.m_password = XMLHandler.getTagValue((Node)stepnode, (String)"password");
        if (!Const.isEmpty((String)this.m_password)) {
            this.m_password = Encr.decryptPasswordOptionallyEncrypted((String)this.m_password);
        }
        this.m_cassandraKeyspace = XMLHandler.getTagValue((Node)stepnode, (String)"cassandra_keyspace");
        this.m_cqlSelectQuery = XMLHandler.getTagValue((Node)stepnode, (String)"cql_select_query");
        this.m_useCompression = XMLHandler.getTagValue((Node)stepnode, (String)"use_compression").equalsIgnoreCase("Y");
        String kV = XMLHandler.getTagValue((Node)stepnode, (String)"output_key_value_timestamp_tuples");
        if (kV != null) {
            this.m_outputKeyValueTimestampTuples = kV.equalsIgnoreCase("Y");
        }
        if ((thrift = XMLHandler.getTagValue((Node)stepnode, (String)"use_thrift_io")) != null) {
            this.m_useThriftIO = thrift.equalsIgnoreCase("Y");
        }
        this.m_socketTimeout = XMLHandler.getTagValue((Node)stepnode, (String)"socket_timeout");
    }

    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        this.m_cassandraHost = rep.getStepAttributeString(id_step, 0, "cassandra_host");
        this.m_cassandraPort = rep.getStepAttributeString(id_step, 0, "cassandra_port");
        this.m_username = rep.getStepAttributeString(id_step, 0, "username");
        this.m_password = rep.getStepAttributeString(id_step, 0, "password");
        if (!Const.isEmpty((String)this.m_password)) {
            this.m_password = Encr.decryptPasswordOptionallyEncrypted((String)this.m_password);
        }
        this.m_cassandraKeyspace = rep.getStepAttributeString(id_step, 0, "cassandra_keyspace");
        this.m_cqlSelectQuery = rep.getStepAttributeString(id_step, 0, "cql_select_query");
        this.m_useCompression = rep.getStepAttributeBoolean(id_step, 0, "use_compression");
        this.m_outputKeyValueTimestampTuples = rep.getStepAttributeBoolean(id_step, 0, "output_key_value_timestamp_tuples");
        this.m_useThriftIO = rep.getStepAttributeBoolean(id_step, 0, "use_thrift_io");
        this.m_socketTimeout = rep.getStepAttributeString(id_step, 0, "socket_timeout");
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        if (!Const.isEmpty((String)this.m_cassandraHost)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cassandra_host", this.m_cassandraHost);
        }
        if (!Const.isEmpty((String)this.m_cassandraPort)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cassandra_port", this.m_cassandraPort);
        }
        if (!Const.isEmpty((String)this.m_username)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "username", this.m_username);
        }
        if (!Const.isEmpty((String)this.m_password)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.m_password));
        }
        if (!Const.isEmpty((String)this.m_cassandraKeyspace)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cassandra_keyspace", this.m_cassandraKeyspace);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "use_compression", this.m_useCompression);
        if (!Const.isEmpty((String)this.m_cqlSelectQuery)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "cql_select_query", this.m_cqlSelectQuery);
        }
        rep.saveStepAttribute(id_transformation, id_step, 0, "output_key_value_timestamp_tuples", this.m_outputKeyValueTimestampTuples);
        rep.saveStepAttribute(id_transformation, id_step, 0, "use_thrift_io", this.m_useThriftIO);
        if (!Const.isEmpty((String)this.m_socketTimeout)) {
            rep.saveStepAttribute(id_transformation, id_step, 0, "socket_timeout", this.m_socketTimeout);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new CassandraInput(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new CassandraInputData();
    }

    public void setDefault() {
        this.m_cassandraHost = "localhost";
        this.m_cassandraPort = "9160";
        this.m_cqlSelectQuery = "SELECT <fields> FROM <column family> WHERE <condition>;";
        this.m_useCompression = false;
        this.m_socketTimeout = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        this.m_specificCols = null;
        this.m_rowLimit = -1;
        this.m_colLimit = -1;
        rowMeta.clear();
        if (Const.isEmpty((String)this.m_cassandraKeyspace)) {
            return;
        }
        String colFamName = null;
        if (!Const.isEmpty((String)this.m_cqlSelectQuery)) {
            String subQ = space.environmentSubstitute(this.m_cqlSelectQuery);
            if (!subQ.toLowerCase().startsWith("select")) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.NoSelectInQuery", (String[])new String[0]));
                return;
            }
            if (subQ.indexOf(59) < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.QueryTermination", (String[])new String[0]));
                return;
            }
            if (subQ.toLowerCase().indexOf("limit") > 0) {
                String limitS = subQ.toLowerCase().substring(subQ.toLowerCase().indexOf("limit") + 5, subQ.length()).trim();
                limitS = limitS.replaceAll(";", "");
                try {
                    this.m_rowLimit = Integer.parseInt(limitS);
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.UnableToParseLimitClause", (String[])new String[]{this.m_cqlSelectQuery}));
                    this.m_rowLimit = 10000;
                }
            }
            if (subQ.toLowerCase().lastIndexOf("where") > 0) {
                subQ = subQ.substring(0, subQ.toLowerCase().lastIndexOf("where"));
            }
            int fromIndex = subQ.toLowerCase().indexOf("from");
            String tempS = subQ.toLowerCase();
            int offset = fromIndex;
            while (fromIndex > 0 && tempS.charAt(fromIndex - 1) != ' ' && fromIndex + 4 < tempS.length() && tempS.charAt(fromIndex + 4) != ' ') {
                tempS = tempS.substring(fromIndex + 4, tempS.length());
                fromIndex = tempS.indexOf("from");
                offset += 4 + fromIndex;
            }
            fromIndex = offset;
            if (fromIndex < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.MustSpecifyAColumnFamily", (String[])new String[0]));
                return;
            }
            colFamName = subQ.substring(fromIndex + 4, subQ.length()).trim();
            colFamName = colFamName.indexOf(32) > 0 ? colFamName.substring(0, colFamName.indexOf(32)) : colFamName.replace(";", "");
            if (colFamName.length() == 0) {
                return;
            }
            if (subQ.toLowerCase().indexOf("first") > 0) {
                String firstS = subQ.toLowerCase().substring(subQ.toLowerCase().indexOf("first") + 5, subQ.length()).trim();
                firstS = firstS.substring(0, firstS.indexOf(32));
                try {
                    this.m_colLimit = Integer.parseInt(firstS);
                }
                catch (NumberFormatException ex) {
                    this.logError(BaseMessages.getString(PKG, (String)"CassandraInput.Error.UnableToParseFirstClause", (String[])new String[]{this.m_cqlSelectQuery}));
                    return;
                }
            }
            String[] cols = null;
            if (subQ.indexOf("*") > 0) {
                this.m_isSelectStarQuery = true;
            } else {
                this.m_isSelectStarQuery = false;
                String colsS = subQ.substring(subQ.indexOf(39), fromIndex);
                cols = colsS.split(",");
            }
            String hostS = space.environmentSubstitute(this.m_cassandraHost);
            String portS = space.environmentSubstitute(this.m_cassandraPort);
            String userS = this.m_username;
            String passS = this.m_password;
            if (!Const.isEmpty((String)userS) && !Const.isEmpty((String)passS)) {
                userS = space.environmentSubstitute(this.m_username);
                passS = space.environmentSubstitute(this.m_password);
            }
            String keyspaceS = space.environmentSubstitute(this.m_cassandraKeyspace);
            CassandraConnection conn = null;
            try {
                conn = CassandraInputData.getCassandraConnection(hostS, Integer.parseInt(portS), userS, passS);
                conn.setKeyspace(keyspaceS);
            }
            catch (Exception ex) {
                this.logError(ex.getMessage(), ex);
                return;
            }
            try {
                CassandraColumnMetaData colMeta = new CassandraColumnMetaData(conn, colFamName);
                ValueMetaInterface km = colMeta.getValueMetaForKey();
                rowMeta.addValueMeta(km);
                if (this.getOutputKeyValueTimestampTuples()) {
                    ValueMeta vm = new ValueMeta("ColumnName", 2);
                    rowMeta.addValueMeta((ValueMetaInterface)vm);
                    vm = null;
                    String defaultColumnValidator = colMeta.getDefaultValidationClass();
                    if (!Const.isEmpty((String)defaultColumnValidator)) {
                        if (defaultColumnValidator.indexOf(40) > 0) {
                            defaultColumnValidator = defaultColumnValidator.substring(0, defaultColumnValidator.indexOf(41));
                        }
                        if (defaultColumnValidator.endsWith("BytesType")) {
                            vm = new ValueMeta("ColumnValue", 8);
                        }
                    }
                    if (vm == null) {
                        vm = new ValueMeta("ColumnValue", 2);
                    }
                    rowMeta.addValueMeta((ValueMetaInterface)vm);
                    vm = new ValueMeta("Timestamp", 5);
                    rowMeta.addValueMeta((ValueMetaInterface)vm);
                    conn.close();
                    if (cols != null) {
                        this.m_specificCols = new ArrayList<String>();
                        for (String col : cols) {
                            col = this.cleanseColName(col);
                            this.m_specificCols.add(col);
                        }
                    }
                    return;
                }
                if (cols == null) {
                    List<ValueMetaInterface> vms = colMeta.getValueMetasForSchema();
                    for (ValueMetaInterface vm : vms) {
                        rowMeta.addValueMeta(vm);
                    }
                } else {
                    this.m_specificCols = new ArrayList<String>();
                    for (String col : cols) {
                        if (!colMeta.columnExistsInSchema(col = this.cleanseColName(col))) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"CassandraInput.Info.DefaultColumnValidator", (String[])new String[]{col}));
                        }
                        ValueMetaInterface vm = colMeta.getValueMetaForColumn(col);
                        rowMeta.addValueMeta(vm);
                    }
                }
            }
            catch (Exception ex) {
                this.logBasic(BaseMessages.getString(PKG, (String)"CassandraInput.Info.UnableToRetrieveColumnMetaData", (String[])new String[]{colFamName}), new Object[]{ex});
                return;
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    private String cleanseColName(String col) {
        col = col.trim();
        col = col.replace("'", "");
        col = col.replace("\"", "");
        return col;
    }

    public StepDialogInterface getDialog(Shell shell, StepMetaInterface meta, TransMeta transMeta, String name) {
        return new CassandraInputDialog(shell, meta, transMeta, name);
    }
}

