/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.cassandrasstableoutput;

import java.io.File;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.io.sstable.SSTableSimpleUnsortedWriter;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.log4j.helpers.ISO8601DateFormat;
import org.pentaho.di.core.exception.KettleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSTableWriter {
    private static final DateFormat ISO8601 = ISO8601DateFormat.getInstance();
    private static final int DEFAULT_BUFFER_SIZE_MB = 16;
    private String directory = System.getProperty("java.io.tmpdir");
    private String keyspace;
    private String columnFamily;
    private String keyField;
    private int bufferSize = 16;
    private SSTableSimpleUnsortedWriter writer;

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setKeyspace(String keyspace) {
        this.keyspace = keyspace;
    }

    public void setColumnFamily(String columnFamily) {
        this.columnFamily = columnFamily;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void init() throws Exception {
        File directory = new File(this.directory);
        if (!directory.exists()) {
            directory.mkdir();
        }
        try {
            this.writer = new SSTableSimpleUnsortedWriter(directory, this.keyspace, this.columnFamily, (AbstractType)AsciiType.instance, null, this.bufferSize);
        }
        catch (Throwable t) {
            throw new KettleException("Failed to create SSTableSimpleUnsortedWriter", t);
        }
    }

    public void processRow(Map<String, Object> record) throws Exception {
        ByteBuffer uuid = SSTableWriter.valueToBytes(record.get(this.keyField));
        this.writer.newRow(uuid);
        long timestamp = System.currentTimeMillis() * 1000L;
        for (Map.Entry<String, Object> entry : record.entrySet()) {
            Object value = entry.getValue();
            if (SSTableWriter.isNull(value) || entry.getKey().equals(this.keyField)) continue;
            this.writer.addColumn(ByteBufferUtil.bytes((String)entry.getKey()), SSTableWriter.valueToBytes(value), timestamp);
        }
    }

    private static final ByteBuffer valueToBytes(Object val) throws Exception {
        if (val instanceof String) {
            return ByteBufferUtil.bytes((String)((String)val));
        }
        if (val instanceof Integer) {
            return ByteBufferUtil.bytes((int)((Integer)val));
        }
        if (val instanceof Float) {
            return ByteBufferUtil.bytes((float)((Float)val).floatValue());
        }
        if (val instanceof Boolean) {
            return ByteBufferUtil.bytes((String)val.toString());
        }
        if (val instanceof Date) {
            try {
                return ByteBufferUtil.bytes((String)ISO8601.format((Date)val));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return ByteBufferUtil.bytes((String)val.toString());
            }
        }
        if (val instanceof Long) {
            return ByteBufferUtil.bytes((long)((Long)val));
        }
        if (val instanceof Double) {
            return ByteBufferUtil.bytes((double)((Double)val));
        }
        if (val instanceof byte[]) {
            return ByteBuffer.wrap((byte[])val);
        }
        return ByteBufferUtil.bytes((String)val.toString());
    }

    static final boolean isNull(Object val) {
        if (val == null) {
            return true;
        }
        if (val instanceof String) {
            return "".equals(val);
        }
        return false;
    }

    public void close() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
    }
}

