/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hbaseoutput;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.hbaseoutput.HBaseOutputData;
import org.pentaho.di.trans.steps.hbaseoutput.HBaseOutputMeta;
import org.pentaho.hbase.mapping.MappingAdmin;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseConnection;

public class HBaseOutput
extends BaseStep
implements StepInterface {
    protected HBaseOutputMeta m_meta;
    protected HBaseOutputData m_data;
    protected HBaseConnection m_hbAdmin;
    protected HBaseBytesUtilShim m_bytesUtil;
    protected MappingAdmin m_mappingAdmin;
    protected Mapping m_tableMapping;
    protected Map<String, HBaseValueMeta> m_columnsMappedByAlias;
    protected boolean m_targetTableActive = false;
    protected int m_incomingKeyIndex;

    public HBaseOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.m_hbAdmin != null && this.m_targetTableActive) {
                try {
                    if (!this.m_hbAdmin.targetTableIsAutoFlush()) {
                        this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.FlushingWriteBuffer", (String[])new String[0]));
                        this.m_hbAdmin.flushCommitsTargetTable();
                    }
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemFlushingBufferedData", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
                }
                try {
                    this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.ClosingConnectionToTable", (String[])new String[0]));
                    this.m_hbAdmin.closeTargetTable();
                    this.m_targetTableActive = false;
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemWhenClosingConnection", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
                }
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.m_meta = (HBaseOutputMeta)smi;
            this.m_data = (HBaseOutputData)sdi;
            try {
                this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.ConnectingToHBase", (String[])new String[0]));
                ArrayList<String> connectionMessages = new ArrayList<String>();
                this.m_hbAdmin = HBaseOutputData.getHBaseConnection(this.environmentSubstitute(this.m_meta.getZookeeperHosts()), this.environmentSubstitute(this.m_meta.getZookeeperPort()), this.environmentSubstitute(this.m_meta.getCoreConfigURL()), this.environmentSubstitute(this.m_meta.getDefaultConfigURL()), connectionMessages);
                this.m_bytesUtil = this.m_hbAdmin.getBytesUtil();
                if (connectionMessages.size() > 0) {
                    for (String m : connectionMessages) {
                        this.logBasic(m);
                    }
                }
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.UnableToObtainConnection", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
            }
            try {
                this.m_mappingAdmin = new MappingAdmin(this.m_hbAdmin);
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.UnableToObtainConnection", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
            }
            String targetName = this.environmentSubstitute(this.m_meta.getTargetTableName());
            if (Const.isEmpty((String)targetName)) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.NoTargetTableSpecified", (String[])new String[0]));
            }
            try {
                if (!this.m_hbAdmin.tableExists(targetName)) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.TargetTableDoesNotExist", (String[])new String[]{targetName}));
                }
                if (this.m_hbAdmin.isTableDisabled(targetName) || !this.m_hbAdmin.isTableAvailable(targetName)) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.TargetTableIsNotAvailable", (String[])new String[]{targetName}));
                }
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemWhenCheckingAvailReadiness", (String[])new String[]{targetName, ex.getMessage()}), (Throwable)ex);
            }
            if (this.m_meta.getMapping() != null && Const.isEmpty((String)this.m_meta.getTargetMappingName())) {
                this.m_tableMapping = this.m_meta.getMapping();
            } else {
                try {
                    this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.RetrievingMappingDetails", (String[])new String[0]));
                    this.m_tableMapping = this.m_mappingAdmin.getMapping(this.environmentSubstitute(this.m_meta.getTargetTableName()), this.environmentSubstitute(this.m_meta.getTargetMappingName()));
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemGettingMappingInfo", (String[])new String[]{ex.getMessage()}), (Throwable)ex);
                }
            }
            this.m_columnsMappedByAlias = this.m_tableMapping.getMappedColumns();
            if (this.m_tableMapping.isTupleMapping()) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.CantWriteUsingATupleMapping", (String[])new String[0]));
            }
            boolean incomingKey = false;
            RowMetaInterface inMeta = this.getInputRowMeta();
            for (int i = 0; i < inMeta.size(); ++i) {
                ValueMetaInterface vm = inMeta.getValueMeta(i);
                String inName = vm.getName();
                if (this.m_tableMapping.getKeyName().equals(inName)) {
                    incomingKey = true;
                    this.m_incomingKeyIndex = i;
                    continue;
                }
                HBaseValueMeta hvm = this.m_columnsMappedByAlias.get(inName.trim());
                if (hvm != null) continue;
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.CantFindIncomingField", (String[])new String[]{inName, this.m_tableMapping.getMappingName()}));
            }
            if (!incomingKey) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.TableKeyNotPresentInIncomingFields", (String[])new String[]{this.m_tableMapping.getKeyName(), this.m_tableMapping.getMappingName()}));
            }
            try {
                this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.ConnectingToTargetTable", (String[])new String[0]));
                Properties tableProps = new Properties();
                if (!Const.isEmpty((String)this.m_meta.getWriteBufferSize())) {
                    long writeBuffer = Long.parseLong(this.environmentSubstitute(this.m_meta.getWriteBufferSize()));
                    this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.SettingWriteBuffer", (Object[])new Object[]{writeBuffer}));
                    tableProps.setProperty("htable.writeBufferSize", "" + writeBuffer);
                    if (this.m_meta.getDisableWriteToWAL()) {
                        this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.DisablingWriteToWAL", (String[])new String[0]));
                    }
                }
                this.m_hbAdmin.newTargetTable(targetName, tableProps);
                this.m_targetTableActive = true;
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemConnectingToTargetTable", (String[])new String[]{e.getMessage()}), (Throwable)e);
            }
            this.m_data.setOutputRowMeta(this.getInputRowMeta());
        }
        try {
            if (!HBaseOutputData.initializeNewPut(this.getInputRowMeta(), this.m_incomingKeyIndex, r, this.m_tableMapping, this.m_bytesUtil, this.m_hbAdmin, !this.m_meta.getDisableWriteToWAL())) {
                String errorDescriptions = BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.IncomingRowHasNullKeyValue", (String[])new String[0]);
                if (this.getStepMeta().isDoingErrorHandling()) {
                    String errorFields = this.m_tableMapping.getKeyName();
                    this.putError(this.getInputRowMeta(), r, 1L, errorDescriptions, errorFields, "HBaaseOutput001");
                    return true;
                }
                throw new KettleException(errorDescriptions);
            }
        }
        catch (Exception ex) {
            throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.UnableToSetTargetTable", (String[])new String[0]), (Throwable)ex);
        }
        HBaseOutputData.addColumnsToPut(this.getInputRowMeta(), r, this.m_incomingKeyIndex, this.m_columnsMappedByAlias, this.m_hbAdmin, this.m_bytesUtil);
        try {
            this.m_hbAdmin.executeTargetTablePut();
        }
        catch (Exception e) {
            String errorDescriptions = BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemInsertingRowIntoHBase", (String[])new String[]{e.getMessage()});
            if (this.getStepMeta().isDoingErrorHandling()) {
                String errorFields = "Unknown";
                this.putError(this.getInputRowMeta(), r, 1L, errorDescriptions, errorFields, "HBaseOutput002");
            }
            throw new KettleException(errorDescriptions, (Throwable)e);
        }
        this.putRow(this.m_data.getOutputRowMeta(), r);
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{"Read row #" + this.getLinesRead() + " : " + r});
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    public void setStopped(boolean stopped) {
        if (this.isStopped() && stopped) {
            return;
        }
        super.setStopped(stopped);
        if (stopped && this.m_hbAdmin != null && this.m_targetTableActive) {
            try {
                if (!this.m_hbAdmin.targetTableIsAutoFlush()) {
                    this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.FlushingWriteBuffer", (String[])new String[0]));
                    this.m_hbAdmin.flushCommitsTargetTable();
                }
            }
            catch (Exception ex) {
                this.logError(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemFlushingBufferedData", (String[])new String[]{ex.getMessage()}), ex);
            }
            try {
                this.logBasic(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.ClosingConnectionToTable", (String[])new String[0]));
                this.m_hbAdmin.closeTargetTable();
                this.m_targetTableActive = false;
            }
            catch (Exception ex) {
                this.logError(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.ProblemWhenClosingConnection", (String[])new String[]{ex.getMessage()}), ex);
            }
        }
    }
}

