/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hbaseoutput;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.hbaseoutput.HBaseOutputMeta;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseConnection;
import org.pentaho.hbase.shim.spi.HBaseShim;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HBaseOutputData
extends BaseStepData
implements StepDataInterface {
    protected RowMetaInterface m_outputRowMeta;

    public RowMetaInterface getOutputRowMeta() {
        return this.m_outputRowMeta;
    }

    public void setOutputRowMeta(RowMetaInterface rmi) {
        this.m_outputRowMeta = rmi;
    }

    public static HBaseConnection getHBaseConnection(String zookeeperHosts, String zookeeperPort, String siteConfig, String defaultConfig, List<String> logging) throws Exception {
        Properties connProps = new Properties();
        if (!Const.isEmpty((String)zookeeperHosts)) {
            connProps.setProperty("hbase.zookeeper.quorum", zookeeperHosts);
        }
        if (!Const.isEmpty((String)zookeeperPort)) {
            connProps.setProperty("hbase.zookeeper.property.clientPort", zookeeperPort);
        }
        if (!Const.isEmpty((String)siteConfig)) {
            connProps.setProperty("hbase.site", siteConfig);
        }
        if (!Const.isEmpty((String)defaultConfig)) {
            connProps.setProperty("hbase.default", defaultConfig);
        }
        HadoopConfiguration active = HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration();
        HBaseShim hbaseShim = active.getHBaseShim();
        HBaseConnection conn = hbaseShim.getHBaseConnection();
        conn.configureConnection(connProps, logging);
        return conn;
    }

    public static boolean initializeNewPut(RowMetaInterface inRowMeta, int keyIndex, Object[] kettleRow, Mapping tableMapping, HBaseBytesUtilShim bu, HBaseConnection hbAdmin, boolean writeToWAL) throws Exception {
        ValueMetaInterface keyvm = inRowMeta.getValueMeta(keyIndex);
        if (keyvm.isNull(kettleRow[keyIndex])) {
            return false;
        }
        byte[] encodedKey = HBaseValueMeta.encodeKeyValue((Object)kettleRow[keyIndex], (ValueMetaInterface)keyvm, (Mapping.KeyType)tableMapping.getKeyType(), (HBaseBytesUtilShim)bu);
        hbAdmin.newTargetTablePut(encodedKey, writeToWAL);
        return true;
    }

    public static void addColumnsToPut(RowMetaInterface inRowMeta, Object[] kettleRow, int keyIndex, Map<String, HBaseValueMeta> columnsMappedByAlias, HBaseConnection hbAdmin, HBaseBytesUtilShim bu) throws KettleException {
        for (int i = 0; i < inRowMeta.size(); ++i) {
            ValueMetaInterface current = inRowMeta.getValueMeta(i);
            if (i == keyIndex || current.isNull(kettleRow[i])) continue;
            HBaseValueMeta hbaseColMeta = columnsMappedByAlias.get(current.getName());
            String columnFamily = hbaseColMeta.getColumnFamily();
            String columnName = hbaseColMeta.getColumnName();
            boolean binaryColName = false;
            if (columnName.startsWith("@@@binary@@@")) {
                columnName = columnName.replace("@@@binary@@@", "");
                binaryColName = true;
            }
            byte[] encoded = HBaseValueMeta.encodeColumnValue((Object)kettleRow[i], (ValueMetaInterface)current, (HBaseValueMeta)hbaseColMeta, (HBaseBytesUtilShim)bu);
            try {
                hbAdmin.addColumnToTargetPut(columnFamily, columnName, binaryColName, encoded);
                continue;
            }
            catch (Exception ex) {
                throw new KettleException(BaseMessages.getString(HBaseOutputMeta.PKG, (String)"HBaseOutput.Error.UnableToAddColumnToTargetTablePut", (String[])new String[0]), (Throwable)ex);
            }
        }
    }

    public static URL stringToURL(String pathOrURL) throws MalformedURLException {
        URL result = null;
        if (!Const.isEmpty((String)pathOrURL)) {
            if (pathOrURL.toLowerCase().startsWith("http://") || pathOrURL.toLowerCase().startsWith("file://")) {
                result = new URL(pathOrURL);
            } else {
                String c = "file://" + pathOrURL;
                result = new URL(c);
            }
        }
        return result;
    }
}

