/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.hbaserowdecoder;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.hadoop.HadoopConfigurationBootstrap;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.hbaserowdecoder.HBaseRowDecoderData;
import org.pentaho.di.trans.steps.hbaserowdecoder.HBaseRowDecoderMeta;
import org.pentaho.hadoop.shim.HadoopConfiguration;
import org.pentaho.hbase.HBaseRowToKettleTuple;
import org.pentaho.hbase.shim.api.HBaseValueMeta;
import org.pentaho.hbase.shim.api.Mapping;
import org.pentaho.hbase.shim.spi.HBaseBytesUtilShim;
import org.pentaho.hbase.shim.spi.HBaseConnection;
import org.pentaho.hbase.shim.spi.HBaseShim;

public class HBaseRowDecoder
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = HBaseRowDecoderMeta.class;
    protected HBaseRowDecoderMeta m_meta;
    protected HBaseRowDecoderData m_data;
    protected Mapping m_tableMapping;
    protected HBaseValueMeta[] m_outputColumns;
    protected int m_keyInIndex = -1;
    protected int m_resultInIndex = -1;
    protected HBaseRowToKettleTuple m_tupleHandler;
    protected HBaseConnection m_hbAdmin;
    protected HBaseBytesUtilShim m_bytesUtil;

    public HBaseRowDecoder(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] inputRow = this.getRow();
        if (inputRow == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.m_meta = (HBaseRowDecoderMeta)smi;
            this.m_data = (HBaseRowDecoderData)sdi;
            try {
                HadoopConfiguration active = HadoopConfigurationBootstrap.getHadoopConfigurationProvider().getActiveConfiguration();
                HBaseShim hbShim = active.getHBaseShim();
                this.m_hbAdmin = hbShim.getHBaseConnection();
                this.m_bytesUtil = this.m_hbAdmin.getBytesUtil();
            }
            catch (Exception ex) {
                throw new KettleException(ex.getMessage(), (Throwable)ex);
            }
            this.m_tableMapping = this.m_meta.getMapping();
            if (this.m_tableMapping == null || Const.isEmpty((String)this.m_tableMapping.getKeyName())) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.NoMappingInfo", (String[])new String[0]));
            }
            if (this.m_tableMapping.isTupleMapping()) {
                this.m_tupleHandler = new HBaseRowToKettleTuple(this.m_bytesUtil);
            }
            this.m_outputColumns = new HBaseValueMeta[this.m_tableMapping.getMappedColumns().keySet().size()];
            int k = 0;
            for (String alias : this.m_tableMapping.getMappedColumns().keySet()) {
                this.m_outputColumns[k++] = (HBaseValueMeta)this.m_tableMapping.getMappedColumns().get(alias);
            }
            this.m_data.setOutputRowMeta(this.getInputRowMeta().clone());
            this.m_meta.getFields(this.m_data.getOutputRowMeta(), this.getStepname(), null, null, (VariableSpace)this);
            RowMetaInterface inputMeta = this.getInputRowMeta();
            String inKey = this.environmentSubstitute(this.m_meta.getIncomingKeyField());
            this.m_keyInIndex = inputMeta.indexOfValue(inKey);
            if (this.m_keyInIndex == -1) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.UnableToFindHBaseKey", (String[])new String[]{inKey}));
            }
            if (!this.m_hbAdmin.isImmutableBytesWritable(inputRow[this.m_keyInIndex])) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.NotImmutableBytesWritable", (String[])new String[]{this.m_meta.getIncomingKeyField()}));
            }
            String inResult = this.environmentSubstitute(this.m_meta.getIncomingResultField());
            this.m_resultInIndex = inputMeta.indexOfValue(inResult);
            if (this.m_resultInIndex == -1) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.UnableToFindHBaseRow", (String[])new String[]{inResult}));
            }
            if (!this.m_hbAdmin.checkForHBaseRow(inputRow[this.m_resultInIndex])) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.NotResult", (String[])new String[]{this.m_meta.getIncomingResultField()}));
            }
        }
        Object hRow = inputRow[this.m_resultInIndex];
        if (inputRow[this.m_keyInIndex] != null && hRow != null) {
            if (this.m_tableMapping.isTupleMapping()) {
                List<Object[]> hrowToKettleRow = this.m_tupleHandler.hbaseRowToKettleTupleMode(hRow, this.m_hbAdmin, this.m_tableMapping, this.m_tableMapping.getMappedColumns(), this.m_data.getOutputRowMeta());
                for (Object[] tuple : hrowToKettleRow) {
                    this.putRow(this.m_data.getOutputRowMeta(), tuple);
                }
            } else {
                Object decodedKey;
                Object[] outputRowData = RowDataUtil.allocateRowData((int)(this.m_outputColumns.length + 1));
                byte[] rowKey = null;
                try {
                    rowKey = this.m_hbAdmin.getRowKey(hRow);
                }
                catch (Exception ex) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.UnableToGetRowKey", (String[])new String[0]), (Throwable)ex);
                }
                outputRowData[0] = decodedKey = HBaseValueMeta.decodeKeyValue((byte[])rowKey, (Mapping)this.m_tableMapping, (HBaseBytesUtilShim)this.m_bytesUtil);
                for (int i = 0; i < this.m_outputColumns.length; ++i) {
                    Object decodedVal;
                    HBaseValueMeta current = this.m_outputColumns[i];
                    String colFamilyName = current.getColumnFamily();
                    String qualifier = current.getColumnName();
                    byte[] kv = null;
                    try {
                        kv = this.m_hbAdmin.getRowColumnLatest(hRow, colFamilyName, qualifier, false);
                    }
                    catch (Exception ex) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"HBaseRowDecoder.Error.UnableToGetColumnValue", (String[])new String[0]), (Throwable)ex);
                    }
                    outputRowData[i + 1] = decodedVal = HBaseValueMeta.decodeColumnValue((byte[])(kv == null ? null : kv), (HBaseValueMeta)current, (HBaseBytesUtilShim)this.m_bytesUtil);
                }
                this.putRow(this.m_data.getOutputRowMeta(), outputRowData);
            }
        }
        return true;
    }
}

