/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodboutput;

import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.MongoException;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputData;
import org.pentaho.di.trans.steps.mongodboutput.MongoDbOutputMeta;

public class MongoDbOutput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MongoDbOutputMeta.class;
    protected MongoDbOutputMeta m_meta;
    protected MongoDbOutputData m_data;
    protected MongoDbOutputData.MongoTopLevel m_mongoTopLevelStructure = MongoDbOutputData.MongoTopLevel.INCONSISTENT;
    protected int m_batchInsertSize = 100;
    protected List<DBObject> m_batch;

    public MongoDbOutput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row = this.getRow();
        if (row == null) {
            List<MongoDbOutputMeta.MongoIndex> indexes;
            if (this.m_batch != null && this.m_batch.size() > 0) {
                this.doBatch();
            }
            if ((indexes = this.m_meta.getMongoIndexes()) != null && indexes.size() > 0) {
                this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.ApplyingIndexOpps", (String[])new String[0]));
                this.m_data.applyIndexes(indexes, this.log, this.m_meta.getTruncate());
            }
            this.disconnect();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.m_batchInsertSize = 100;
            String batchInsert = this.environmentSubstitute(this.m_meta.getBatchInsertSize());
            if (!Const.isEmpty((String)batchInsert)) {
                this.m_batchInsertSize = Integer.parseInt(batchInsert);
            }
            this.m_batch = new ArrayList<DBObject>(this.m_batchInsertSize);
            this.m_data.setOutputRowMeta(this.getInputRowMeta());
            this.m_mongoTopLevelStructure = MongoDbOutputData.checkTopLevelConsistency(this.m_meta.m_mongoFields, (VariableSpace)this);
            if (this.m_mongoTopLevelStructure == MongoDbOutputData.MongoTopLevel.INCONSISTENT) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.InconsistentMongoTopLevel", (String[])new String[0]));
            }
            RowMetaInterface rmi = this.getInputRowMeta();
            List<MongoDbOutputMeta.MongoField> mongoFields = this.m_meta.getMongoFields();
            ArrayList<String> notToBeInserted = new ArrayList<String>();
            for (int i = 0; i < rmi.size(); ++i) {
                ValueMetaInterface vm = rmi.getValueMeta(i);
                boolean ok = false;
                for (MongoDbOutputMeta.MongoField field : mongoFields) {
                    String mongoMatch = this.environmentSubstitute(field.m_incomingFieldName);
                    if (!vm.getName().equals(mongoMatch)) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                notToBeInserted.add(vm.getName());
            }
            if (notToBeInserted.size() == rmi.size()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NotInsertingAnyFields", (String[])new String[0]));
            }
            if (notToBeInserted.size() > 0) {
                StringBuffer b = new StringBuffer();
                for (String s : notToBeInserted) {
                    b.append(s).append(" ");
                }
                this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.FieldsNotToBeInserted", (String[])new String[0]), new Object[]{b.toString()});
            }
            for (MongoDbOutputMeta.MongoField m : this.m_meta.getMongoFields()) {
                m.init((VariableSpace)this);
            }
            if (this.m_meta.getTruncate()) {
                try {
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.TruncatingCollection", (String[])new String[0]));
                    this.m_data.getCollection().drop();
                    String collection = this.environmentSubstitute(this.m_meta.getCollection());
                    this.m_data.createCollection(collection);
                    this.m_data.setCollection(this.m_data.getDB().getCollection(collection));
                }
                catch (Exception m) {
                    this.disconnect();
                    throw new KettleException(m.getMessage(), (Throwable)m);
                }
            }
        }
        if (!this.isStopped()) {
            if (this.m_meta.getUpsert()) {
                DBObject updateQuery = MongoDbOutputData.getQueryObject(this.m_meta.getMongoFields(), this.getInputRowMeta(), row, (VariableSpace)this, this.m_mongoTopLevelStructure);
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Debug.QueryForUpsert", (Object[])new Object[]{updateQuery}));
                }
                if (updateQuery != null) {
                    DBObject insertUpdate = null;
                    if (!this.m_meta.getModifierUpdate()) {
                        insertUpdate = MongoDbOutputData.kettleRowToMongo(this.m_meta.getMongoFields(), this.getInputRowMeta(), row, (VariableSpace)this, this.m_mongoTopLevelStructure);
                        if (this.log.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Debug.InsertUpsertObject", (Object[])new Object[]{insertUpdate}));
                        }
                    } else {
                        insertUpdate = this.m_data.getModifierUpdateObject(this.m_meta.getMongoFields(), this.getInputRowMeta(), row, (VariableSpace)this, this.m_mongoTopLevelStructure);
                        if (this.log.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Debug.ModifierUpdateObject", (Object[])new Object[]{insertUpdate}));
                        }
                    }
                    if (insertUpdate != null) {
                        WriteConcern concern = null;
                        if (this.log.getLogLevel().getLevel() >= LogLevel.DETAILED.getLevel()) {
                            concern = new WriteConcern(1);
                        }
                        WriteResult result = null;
                        result = concern != null ? this.m_data.getCollection().update(updateQuery, insertUpdate, true, this.m_meta.getMulti(), concern) : this.m_data.getCollection().update(updateQuery, insertUpdate, true, this.m_meta.getMulti());
                        CommandResult cmd = result.getLastError();
                        if (cmd != null && !cmd.ok()) {
                            String message = cmd.getErrorMessage();
                            this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.MongoReported", (String[])new String[]{message}));
                            try {
                                cmd.throwOnError();
                            }
                            catch (MongoException me) {
                                throw new KettleException(me.getMessage(), (Throwable)me);
                            }
                        }
                    }
                }
            } else {
                DBObject mongoInsert = MongoDbOutputData.kettleRowToMongo(this.m_meta.getMongoFields(), this.getInputRowMeta(), row, (VariableSpace)this, this.m_mongoTopLevelStructure);
                if (mongoInsert != null) {
                    this.m_batch.add(mongoInsert);
                }
                if (this.m_batch.size() == this.m_batchInsertSize) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.CommitingABatch", (String[])new String[0]));
                    this.doBatch();
                }
            }
        }
        return true;
    }

    protected void doBatch() throws KettleException {
        WriteConcern concern = null;
        if (this.log.getLogLevel().getLevel() >= LogLevel.DETAILED.getLevel()) {
            concern = new WriteConcern(1);
        }
        WriteResult result = null;
        result = concern != null ? this.m_data.getCollection().insert(this.m_batch, concern) : this.m_data.getCollection().insert(this.m_batch);
        CommandResult cmd = result.getLastError();
        if (cmd != null && !cmd.ok()) {
            String message = cmd.getErrorMessage();
            this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.MongoReported", (String[])new String[]{message}));
            try {
                cmd.throwOnError();
            }
            catch (MongoException me) {
                throw new KettleException(me.getMessage(), (Throwable)me);
            }
        }
        this.m_batch.clear();
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        if (super.init(stepMetaInterface, stepDataInterface)) {
            this.m_meta = (MongoDbOutputMeta)stepMetaInterface;
            this.m_data = (MongoDbOutputData)stepDataInterface;
            String hostname = this.environmentSubstitute(this.m_meta.getHostname());
            int port = Const.toInt((String)this.environmentSubstitute(this.m_meta.getPort()), (int)27017);
            String db = this.environmentSubstitute(this.m_meta.getDBName());
            String collection = this.environmentSubstitute(this.m_meta.getCollection());
            try {
                this.m_data.connect(hostname, port);
                this.m_data.setDB(this.m_data.getConnection().getDB(db));
                String realUser = this.environmentSubstitute(this.m_meta.getUsername());
                String realPass = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.m_meta.getPassword()));
                if (!(Const.isEmpty((String)realUser) && Const.isEmpty((String)realPass) || this.m_data.getDB().authenticate(realUser, realPass.toCharArray()))) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.UnableToAuthenticate", (String[])new String[0]));
                }
                if (Const.isEmpty((String)collection)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.NoCollectionSpecified", (String[])new String[0]));
                }
                this.m_data.createCollection(collection);
                this.m_data.setCollection(this.m_data.getDB().getCollection(collection));
                return true;
            }
            catch (UnknownHostException ex) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.UnknownHost", (String[])new String[]{hostname}), ex);
                return false;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.Error.ProblemConnecting", (String[])new String[]{hostname, "" + port}), e);
                return false;
            }
        }
        return false;
    }

    protected void disconnect() {
        if (this.m_data != null) {
            this.m_data.disconnect();
        }
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        if (this.m_data != null) {
            this.m_data.disconnect();
        }
        super.dispose(smi, sdi);
    }
}

