/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.AbstractJobEntry;
import org.pentaho.di.job.BlockableJobConfig;
import org.pentaho.di.job.JobEntryMode;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.oozie.OozieJobExecutorJobEntry;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.vfs.VfsFileChooserHelper;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.stereotype.Bindable;
import org.pentaho.ui.xul.swt.tags.SwtDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJobEntryController<C extends BlockableJobConfig, E extends AbstractJobEntry<C>>
extends AbstractXulEventHandler {
    public static final String[] DEFAULT_FILE_FILTERS = new String[]{"*.*"};
    protected C config;
    protected E jobEntry;
    protected XulDomContainer container;
    protected BindingFactory bindingFactory;
    protected List<Binding> bindings;
    protected JobMeta jobMeta;
    protected JobEntryMode jobEntryMode = JobEntryMode.QUICK_SETUP;

    public AbstractJobEntryController(JobMeta jobMeta, XulDomContainer container, E jobEntry, BindingFactory bindingFactory) {
        this.jobMeta = jobMeta;
        this.jobEntry = jobEntry;
        this.container = container;
        this.config = (BlockableJobConfig)((BlockableJobConfig)((AbstractJobEntry)jobEntry).getJobConfig()).clone();
        this.bindingFactory = bindingFactory;
    }

    public String getName() {
        return "controller";
    }

    public JobEntryInterface open() {
        XulDialog dialog = (XulDialog)this.container.getDocumentRoot().getElementById(this.getDialogElementId());
        this.jobEntry.copyVariablesFrom((VariableSpace)this.jobMeta);
        dialog.show();
        return this.jobEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws XulException, InvocationTargetException {
        this.bindings = new ArrayList<Binding>();
        this.beforeInit();
        try {
            this.createBindings(this.config, this.container, this.bindingFactory, this.bindings);
            this.syncModel();
            for (Binding binding : this.bindings) {
                binding.fireSourceChanged();
            }
        }
        finally {
            this.afterInit();
        }
    }

    @Bindable
    public void accept() {
        ((AbstractJobEntry)this.jobEntry).setJobConfig(this.config);
        this.jobEntry.setChanged();
        this.cancel();
    }

    @Bindable
    public void cancel() {
        this.removeBindings();
        SwtDialog xulDialog = this.getDialog();
        Shell shell = (Shell)xulDialog.getRootObject();
        if (!shell.isDisposed()) {
            WindowProperty winprop = new WindowProperty(shell);
            PropsUI.getInstance().setScreen(winprop);
            ((Composite)xulDialog.getManagedObject()).dispose();
            shell.dispose();
        }
    }

    protected void removeBindings() {
        if (this.bindings == null) {
            return;
        }
        for (Binding binding : this.bindings) {
            binding.destroyBindings();
        }
        this.bindings.clear();
    }

    protected SwtDialog getDialog() {
        return (SwtDialog)this.getXulDomContainer().getDocumentRoot().getElementById(this.getDialogElementId());
    }

    protected E getJobEntry() {
        return this.jobEntry;
    }

    protected void beforeInit() {
    }

    protected void afterInit() {
    }

    protected boolean showConfirmationDialog(String title, String message) {
        return MessageDialog.openConfirm((Shell)this.getShell(), (String)title, (String)message);
    }

    protected void showInfoDialog(String title, String message) {
        MessageBox mb = new MessageBox(this.getShell(), 34);
        mb.setText(title);
        mb.setMessage(message);
        mb.open();
    }

    protected void showErrorDialog(String title, String message) {
        MessageBox mb = new MessageBox(this.getShell(), 33);
        mb.setText(title);
        mb.setMessage(message);
        mb.open();
    }

    protected void showErrorDialog(String title, String message, Throwable t) {
        new ErrorDialog(this.getShell(), title, message, t);
    }

    protected Shell getShell() {
        return this.getDialog().getShell();
    }

    protected FileObject browseVfs(FileObject root, FileObject initial, int dialogMode, String schemeRestriction, String defaultScheme, boolean showFileScheme) throws KettleFileException {
        if (initial == null) {
            initial = KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
        }
        if (root == null) {
            try {
                root = initial.getFileSystem().getRoot();
            }
            catch (FileSystemException e) {
                throw new KettleFileException((Throwable)e);
            }
        }
        VfsFileChooserHelper fileChooserHelper = new VfsFileChooserHelper(this.getShell(), Spoon.getInstance().getVfsFileChooserDialog(root, initial), (VariableSpace)this.jobEntry);
        fileChooserHelper.setDefaultScheme(defaultScheme);
        fileChooserHelper.setSchemeRestriction(schemeRestriction);
        fileChooserHelper.setShowFileScheme(showFileScheme);
        try {
            return fileChooserHelper.browse(this.getFileFilters(), this.getFileFilterNames(), initial.getName().getURI(), dialogMode);
        }
        catch (KettleException e) {
            throw new KettleFileException((Throwable)e);
        }
        catch (FileSystemException e) {
            throw new KettleFileException((Throwable)e);
        }
    }

    protected String[] getFileFilters() {
        return DEFAULT_FILE_FILTERS;
    }

    protected String[] getFileFilterNames() {
        return new String[]{BaseMessages.getString(((Object)((Object)this)).getClass(), (String)"System.FileType.AllFiles", (String[])new String[0])};
    }

    public C getConfig() {
        return this.config;
    }

    public void setConfig(C config) {
        this.config = config;
    }

    public JobMeta getJobMeta() {
        return this.jobMeta;
    }

    public void setJobMeta(JobMeta jobMeta) {
        this.jobMeta = jobMeta;
    }

    public JobEntryMode getJobEntryMode() {
        return this.jobEntryMode;
    }

    public void toggleMode() {
        JobEntryMode mode = this.jobEntryMode == JobEntryMode.ADVANCED_LIST ? JobEntryMode.QUICK_SETUP : JobEntryMode.ADVANCED_LIST;
        this.setMode(mode);
    }

    protected void setMode(JobEntryMode mode) {
        boolean confirmed;
        if (this.jobEntryMode == JobEntryMode.ADVANCED_LIST && mode == JobEntryMode.QUICK_SETUP && !(confirmed = this.showConfirmationDialog(BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"JobExecutor.Confirm.Toggle.Quick.Mode.Title", (String[])new String[0]), BaseMessages.getString(OozieJobExecutorJobEntry.class, (String)"JobExecutor.Confirm.Toggle.Quick.Mode.Message", (String[])new String[0])))) {
            return;
        }
        JobEntryMode opposite = mode == JobEntryMode.QUICK_SETUP ? JobEntryMode.ADVANCED_LIST : JobEntryMode.QUICK_SETUP;
        this.jobEntryMode = mode;
        XulDeck deck = (XulDeck)this.getXulDomContainer().getDocumentRoot().getElementById(this.getModeDeckElementId());
        deck.setSelectedIndex(mode == JobEntryMode.QUICK_SETUP ? 0 : 1);
        this.syncModel();
        this.setModeToggleLabel(opposite);
    }

    protected String getModeDeckElementId() {
        return "modeDeck";
    }

    protected abstract void syncModel();

    protected abstract void createBindings(C var1, XulDomContainer var2, BindingFactory var3, Collection<Binding> var4);

    protected abstract String getDialogElementId();

    protected abstract void setModeToggleLabel(JobEntryMode var1);
}

