/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.vfs;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class VfsFileChooserHelper {
    private VfsFileChooserDialog fileChooserDialog = null;
    private Shell shell = null;
    private VariableSpace variableSpace = null;
    private FileSystemOptions fileSystemOptions = null;
    private String defaultScheme = "file";
    private String schemeRestriction = null;
    private boolean showFileScheme = true;

    public VfsFileChooserHelper(Shell shell, VfsFileChooserDialog fileChooserDialog, VariableSpace variableSpace) {
        this(shell, fileChooserDialog, variableSpace, new FileSystemOptions());
    }

    public VfsFileChooserHelper(Shell shell, VfsFileChooserDialog fileChooserDialog, VariableSpace variableSpace, FileSystemOptions fileSystemOptions) {
        this.fileChooserDialog = fileChooserDialog;
        this.shell = shell;
        this.variableSpace = variableSpace;
        this.fileSystemOptions = fileSystemOptions;
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, 1);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, int fileDialogMode) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, this.fileSystemOptions, fileDialogMode);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, opts, 1);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts, int fileDialogMode) throws KettleException, FileSystemException {
        FileObject rootFile = null;
        FileObject initialFile = null;
        FileObject defaultInitialFile = KettleVFS.getFileObject((String)"file:///c:/");
        initialFile = fileUri != null ? KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.variableSpace, (FileSystemOptions)opts) : KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
        rootFile = initialFile.getFileSystem().getRoot();
        this.fileChooserDialog.setRootFile(rootFile);
        this.fileChooserDialog.setInitialFile(initialFile);
        this.fileChooserDialog.defaultInitialFile = rootFile;
        FileObject selectedFile = null;
        selectedFile = initialFile != null ? this.fileChooserDialog.open(this.shell, this.getSchemeRestriction(), this.getDefaultScheme(), this.showFileScheme(), initialFile.getName().getPath(), fileFilters, fileFilterNames, fileDialogMode, this.returnsUserAuthenticatedFileObjects()) : this.fileChooserDialog.open(this.shell, this.getSchemeRestriction(), this.getDefaultScheme(), this.showFileScheme(), null, fileFilters, fileFilterNames, fileDialogMode, this.returnsUserAuthenticatedFileObjects());
        return selectedFile;
    }

    public VariableSpace getVariableSpace() {
        return this.variableSpace;
    }

    public void setVariableSpace(VariableSpace variableSpace) {
        this.variableSpace = variableSpace;
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    public void setFileSystemOptions(FileSystemOptions fileSystemOptions) {
        this.fileSystemOptions = fileSystemOptions;
    }

    public String getDefaultScheme() {
        return this.defaultScheme;
    }

    public void setDefaultScheme(String defaultScheme) {
        this.defaultScheme = defaultScheme;
    }

    public String getSchemeRestriction() {
        return this.schemeRestriction;
    }

    public void setSchemeRestriction(String schemeRestriction) {
        this.schemeRestriction = schemeRestriction;
    }

    public boolean showFileScheme() {
        return this.showFileScheme;
    }

    public void setShowFileScheme(boolean showFileScheme) {
        this.showFileScheme = showFileScheme;
    }

    protected boolean returnsUserAuthenticatedFileObjects() {
        return false;
    }
}

