/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.vfs.hadoopvfsfilechooserdialog;

import java.net.Socket;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.provider.GenericFileName;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class HadoopVfsFileChooserDialog
extends CustomVfsUiPanel {
    private static Class<?> PKG = HadoopVfsFileChooserDialog.class;
    private LogChannel log = new LogChannel((Object)this);
    private Label wlUrl;
    private Text wUrl;
    private GridData fdlUrl;
    private GridData fdUrl;
    private Label wlPort;
    private Text wPort;
    private GridData fdlPort;
    private GridData fdPort;
    private Label wlUserID;
    private Text wUserID;
    private GridData fdlUserID;
    private GridData fdUserID;
    private Label wlPassword;
    private Text wPassword;
    private GridData fdlPassword;
    private GridData fdPassword;
    private Label wPlaceHolderLabel;
    private GridData fdlPlaceHolderLabel;
    private Button wConnectionButton;
    private GridData fdConnectionButton;
    FileObject defaultInitialFile = null;
    FileObject hadoopRootFile = null;
    String hadoopOpenFromFolder = null;
    FileObject rootFile = null;
    FileObject initialFile = null;
    VfsFileChooserDialog vfsFileChooserDialog = null;

    public HadoopVfsFileChooserDialog(VfsFileChooserDialog vfsFileChooserDialog, FileObject rootFile, FileObject initialFile) {
        super("hdfs", "HDFS", vfsFileChooserDialog, 0);
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.vfsFileChooserDialog = vfsFileChooserDialog;
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.setLayoutData(gridData);
        this.setLayout((Layout)new GridLayout(1, false));
        this.createConnectionPanel();
        this.initializeConnectionPanel();
    }

    private void createConnectionPanel() {
        Group connectionGroup = new Group((Composite)this, 16);
        connectionGroup.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.ConnectionGroup.Label", (String[])new String[0]));
        GridLayout connectionGroupLayout = new GridLayout();
        connectionGroupLayout.marginWidth = 5;
        connectionGroupLayout.marginHeight = 5;
        connectionGroupLayout.verticalSpacing = 5;
        connectionGroupLayout.horizontalSpacing = 5;
        GridData gData = new GridData(4, 4, true, false);
        connectionGroup.setLayoutData((Object)gData);
        connectionGroup.setLayout((Layout)connectionGroupLayout);
        Composite textFieldPanel = new Composite((Composite)connectionGroup, 0);
        GridData gridData = new GridData(4, 4, true, false);
        textFieldPanel.setLayoutData((Object)gridData);
        textFieldPanel.setLayout((Layout)new GridLayout(5, false));
        this.wlUrl = new Label(textFieldPanel, 131072);
        this.wlUrl.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.URL.Label", (String[])new String[0]));
        this.fdlUrl = new GridData();
        this.fdlUrl.widthHint = 75;
        this.wlUrl.setLayoutData((Object)this.fdlUrl);
        this.wUrl = new Text(textFieldPanel, 18436);
        this.fdUrl = new GridData();
        this.fdUrl.widthHint = 150;
        this.wUrl.setLayoutData((Object)this.fdUrl);
        this.wUrl.setText(Props.getInstance().getCustomParameter("HadoopVfsFileChooserDialog.host", "localhost"));
        this.wUrl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HadoopVfsFileChooserDialog.this.handleConnectionButton();
            }
        });
        this.wlUserID = new Label(textFieldPanel, 131072);
        this.wlUserID.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.UserID.Label", (String[])new String[0]));
        this.fdlUserID = new GridData();
        this.fdlUserID.widthHint = 75;
        this.wlUserID.setLayoutData((Object)this.fdlUserID);
        this.wUserID = new Text(textFieldPanel, 18436);
        this.fdUserID = new GridData();
        this.fdUserID.widthHint = 150;
        this.wUserID.setLayoutData((Object)this.fdUserID);
        this.wUserID.setText(Props.getInstance().getCustomParameter("HadoopVfsFileChooserDialog.user", ""));
        this.wPlaceHolderLabel = new Label(textFieldPanel, 131072);
        this.wPlaceHolderLabel.setText("");
        this.fdlPlaceHolderLabel = new GridData();
        this.fdlPlaceHolderLabel.widthHint = 75;
        this.wlUserID.setLayoutData((Object)this.fdlPlaceHolderLabel);
        this.wlPort = new Label(textFieldPanel, 131072);
        this.wlPort.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.Port.Label", (String[])new String[0]));
        this.fdlPort = new GridData();
        this.fdlPort.widthHint = 75;
        this.wlPort.setLayoutData((Object)this.fdlPort);
        this.wPort = new Text(textFieldPanel, 18436);
        this.fdPort = new GridData();
        this.fdPort.widthHint = 150;
        this.wPort.setLayoutData((Object)this.fdPort);
        this.wPort.setText(Props.getInstance().getCustomParameter("HadoopVfsFileChooserDialog.port", "9000"));
        this.wPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HadoopVfsFileChooserDialog.this.handleConnectionButton();
            }
        });
        this.wlPassword = new Label(textFieldPanel, 131072);
        this.wlPassword.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.Password.Label", (String[])new String[0]));
        this.fdlPassword = new GridData();
        this.fdlPassword.widthHint = 75;
        this.wlPassword.setLayoutData((Object)this.fdlPassword);
        this.wPassword = new Text(textFieldPanel, 18436);
        this.wPassword.setEchoChar('*');
        this.fdPassword = new GridData();
        this.fdPassword.widthHint = 150;
        this.wPassword.setLayoutData((Object)this.fdPassword);
        this.wPassword.setText(Props.getInstance().getCustomParameter("HadoopVfsFileChooserDialog.password", ""));
        this.wConnectionButton = new Button(textFieldPanel, 0x1000000);
        this.fdConnectionButton = new GridData();
        this.fdConnectionButton.widthHint = 75;
        this.wConnectionButton.setLayoutData((Object)this.fdConnectionButton);
        this.wConnectionButton.setText(BaseMessages.getString(PKG, (String)"HadoopVfsFileChooserDialog.ConnectionButton.Label", (String[])new String[0]));
        this.wConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Socket testHdfsSocket = new Socket(HadoopVfsFileChooserDialog.this.wUrl.getText(), Integer.parseInt(HadoopVfsFileChooserDialog.this.wPort.getText()));
                    testHdfsSocket.getOutputStream();
                    testHdfsSocket.close();
                }
                catch (Throwable t) {
                    HadoopVfsFileChooserDialog.this.showMessageAndLog("HadoopVfsFileChooserDialog.error", "HadoopVfsFileChooserDialog.Connection.error", t.getMessage());
                    return;
                }
                Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.host", HadoopVfsFileChooserDialog.this.wUrl.getText());
                Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.port", HadoopVfsFileChooserDialog.this.wPort.getText());
                Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.user", HadoopVfsFileChooserDialog.this.wUserID.getText());
                Props.getInstance().setCustomParameter("HadoopVfsFileChooserDialog.password", HadoopVfsFileChooserDialog.this.wPassword.getText());
                FileObject root = HadoopVfsFileChooserDialog.this.rootFile;
                try {
                    root = KettleVFS.getFileObject((String)HadoopVfsFileChooserDialog.this.buildHadoopFileSystemUrlString());
                }
                catch (KettleFileException e1) {
                    e1.printStackTrace();
                }
                HadoopVfsFileChooserDialog.this.vfsFileChooserDialog.setSelectedFile(root);
                HadoopVfsFileChooserDialog.this.vfsFileChooserDialog.setRootFile(root);
                HadoopVfsFileChooserDialog.this.rootFile = root;
            }
        });
        textFieldPanel.setTabList(new Control[]{this.wUrl, this.wPort, this.wUserID, this.wPassword, this.wConnectionButton});
    }

    public String buildHadoopFileSystemUrlString() {
        if (this.wUserID.getText() == null || "".equals(this.wUserID.getText())) {
            String urlString = "hdfs://" + this.wUrl.getText() + ":" + this.wPort.getText();
            return urlString;
        }
        String urlString = "hdfs://" + this.wUserID.getText() + ":" + this.wPassword.getText() + "@" + this.wUrl.getText() + ":" + this.wPort.getText();
        return urlString;
    }

    private void initializeConnectionPanel() {
        if (this.initialFile != null && this.initialFile.getName().getScheme().equals("hdfs")) {
            try {
                GenericFileName genericFileName = (GenericFileName)this.initialFile.getFileSystem().getRoot().getName();
                this.wUrl.setText(genericFileName.getHostName());
                this.wPort.setText(String.valueOf(genericFileName.getPort()));
                this.wUserID.setText(genericFileName.getUserName() == null ? "" : genericFileName.getUserName());
                this.wPassword.setText(genericFileName.getPassword() == null ? "" : genericFileName.getPassword());
            }
            catch (FileSystemException fse) {
                this.showMessageAndLog("HadoopVfsFileChooserDialog.error", "HadoopVfsFileChooserDialog.FileSystem.error", fse.getMessage());
            }
        }
        this.handleConnectionButton();
    }

    private void showMessageAndLog(String title, String message, String messageToLog) {
        MessageBox box = new MessageBox(this.getShell());
        box.setText(BaseMessages.getString(PKG, (String)title, (String[])new String[0]));
        box.setMessage(BaseMessages.getString(PKG, (String)message, (String[])new String[0]));
        this.log.logError(messageToLog);
        box.open();
    }

    private void handleConnectionButton() {
        if (!Const.isEmpty((String)this.wUrl.getText()) && !Const.isEmpty((String)this.wPort.getText())) {
            this.wConnectionButton.setEnabled(true);
        } else {
            this.wConnectionButton.setEnabled(false);
        }
    }
}

