/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.StringEscaper;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;

abstract class Util {
    private static final Throwable[] emptyThrowableArray = new Throwable[0];
    static final char fileSep = System.getProperty("file.separator").charAt(0);
    private static final Class[] emptyClassArray = new Class[0];

    Util() {
    }

    static ResourceDef.ResourceBundle load(URL url) throws IOException {
        return Util.load(url.openStream());
    }

    static ResourceDef.ResourceBundle load(InputStream inStream) throws IOException {
        try {
            Parser parser = XOMUtil.createDefaultParser();
            DOMWrapper def = parser.parse(inStream);
            ResourceDef.ResourceBundle xmlResourceList = new ResourceDef.ResourceBundle(def);
            return xmlResourceList;
        }
        catch (XOMException err) {
            throw new IOException(err.toString());
        }
    }

    static void fillText(PrintWriter pw, String text, String linePrefix, String lineSuffix, int maxTextPerLine) {
        int end;
        int i = 0;
        while ((end = text.length()) > i) {
            int nextLF;
            int nextCR;
            if (i > 0) {
                pw.println(lineSuffix);
                pw.print(linePrefix);
            }
            if ((nextCR = text.indexOf("\r", i)) >= 0 && nextCR < end) {
                end = nextCR;
            }
            if ((nextLF = text.indexOf("\n", i)) >= 0 && nextLF < end) {
                end = nextLF;
            }
            if (maxTextPerLine > 0 && i + maxTextPerLine <= end && (end = text.lastIndexOf(" ", i + maxTextPerLine)) < i && (end = text.indexOf(" ", i)) < 0) {
                end = text.length();
            }
            pw.print(text.substring(i, end));
            for (i = end; i < text.length() && (text.charAt(i) == ' ' || text.charAt(i) == '\r' || text.charAt(i) == '\n'); ++i) {
            }
        }
    }

    static URL stringToUrl(String strFile) throws IOException {
        try {
            File f = new File(strFile);
            return Util.convertPathToURL(f);
        }
        catch (Throwable err) {
            throw new IOException(err.toString());
        }
    }

    static URL convertPathToURL(File file) {
        try {
            String path = file.getAbsolutePath();
            String fs = System.getProperty("file.separator");
            if (fs.length() == 1) {
                char sep = fs.charAt(0);
                if (sep != '/') {
                    path = path.replace(sep, '/');
                }
                if (path.charAt(0) != '/') {
                    path = '/' + path;
                }
            }
            path = "file://" + path;
            return new URL(path);
        }
        catch (MalformedURLException e) {
            throw new Error(e.getMessage());
        }
    }

    static String formatError(String template, Object[] args) {
        String s = template;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].toString();
            s = Util.replace(s, "%" + (i + 1), arg);
            s = Util.replace(s, "%i" + (i + 1), arg);
        }
        return s;
    }

    static String replace(String s, String find, String replace) {
        int found = s.indexOf(find);
        if (found == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        int start = 0;
        while (true) {
            if (start < found) {
                sb.append(s.charAt(start));
                ++start;
                continue;
            }
            if (found == s.length()) break;
            sb.append(replace);
            found = s.indexOf(find, start += find.length());
            if (found != -1) continue;
            found = s.length();
        }
        return sb.toString();
    }

    static String quoteForJava(String val, boolean nullMeansNull) {
        if (val == null) {
            return nullMeansNull ? "null" : "";
        }
        String s0 = Util.replace(val, "\\", "\\\\");
        s0 = Util.replace(val, "\"", "\\\"");
        s0 = Util.replace(s0, "\n\r", "\\n");
        s0 = Util.replace(s0, "\n", "\\n");
        s0 = Util.replace(s0, "\r", "\\r");
        return "\"" + s0 + "\"";
    }

    static String quoteForJava(String val) {
        return Util.quoteForJava(val, true);
    }

    static String quoteForProperties(String val) {
        String s0 = Util.replace(val, "\\", "\\\\");
        s0 = Util.replace(s0, "\n\r", "\\n");
        s0 = Util.replace(s0, "\n", "\\n");
        s0 = Util.replace(s0, "\r", "\\r");
        s0 = Util.replace(s0, "\t", "\\t");
        return s0;
    }

    static String fileNameToClassName(String fileName, String suffix) {
        String s = fileName;
        s = Util.removeSuffix(s, suffix);
        s = s.replace(fileSep, '.');
        int score = (s = s.replace('/', '.')).indexOf(95);
        if (score >= 0) {
            s = s.substring(0, score);
        }
        return s;
    }

    static String fileNameToCppClassName(String fileName, String suffix) {
        int score;
        String s = fileName;
        int pos = (s = Util.removeSuffix(s, suffix)).lastIndexOf(fileSep);
        if (pos >= 0) {
            s = s.substring(pos + 1);
        }
        if ((score = s.indexOf(95)) >= 0) {
            s = s.substring(0, score);
        }
        return s;
    }

    static String removeSuffix(String s, String suffix) {
        if (s.endsWith(suffix)) {
            s = s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    static Locale fileNameToLocale(String fileName, String suffix) {
        String s = Util.removeSuffix(fileName, suffix);
        int score = s.indexOf(95);
        if (score <= 0) {
            return null;
        }
        String localeName = s.substring(score + 1);
        return Util.parseLocale(localeName);
    }

    static Locale parseLocale(String localeName) {
        String language;
        int score1 = localeName.indexOf(95);
        String country = "";
        String variant = "";
        if (score1 < 0) {
            language = localeName;
        } else {
            language = localeName.substring(0, score1);
            if (language.length() != 2) {
                return null;
            }
            int score2 = localeName.indexOf(95, score1 + 1);
            if (score2 < 0) {
                country = localeName.substring(score1 + 1);
                if (country.length() != 2) {
                    return null;
                }
            } else {
                country = localeName.substring(score1 + 1, score2);
                if (country.length() != 2) {
                    return null;
                }
                variant = localeName.substring(score2 + 1);
            }
        }
        return new Locale(language, country, variant);
    }

    static String fileNameSansLocale(String fileName, String suffix) {
        String s = Util.removeSuffix(fileName, suffix);
        int from = s.lastIndexOf(fileSep);
        if (from < 0) {
            from = 0;
        }
        while (from < s.length()) {
            int score = s.indexOf(95, from);
            Locale locale = Util.parseLocale(s.substring(score + 1));
            if (locale != null) {
                return s.substring(0, score);
            }
            from = score + 1;
        }
        return s;
    }

    static Throwable[] toArray(Throwable err) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (err != null) {
            list.add(err);
            err = Util.getCause(err);
        }
        return list.toArray(emptyThrowableArray);
    }

    private static Throwable getCause(Throwable err) {
        Method method;
        if (err instanceof InvocationTargetException) {
            return ((InvocationTargetException)err).getTargetException();
        }
        try {
            method = err.getClass().getMethod("getCause", emptyClassArray);
            if (Throwable.class.isAssignableFrom(method.getReturnType())) {
                return (Throwable)method.invoke((Object)err, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        try {
            method = err.getClass().getMethod("getNestedThrowable", emptyClassArray);
            if (Throwable.class.isAssignableFrom(method.getReturnType())) {
                return (Throwable)method.invoke((Object)err, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    static String toString(Throwable err) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Throwable[] throwables = Util.toArray(err);
        for (int i = 0; i < throwables.length; ++i) {
            Throwable throwable = throwables[i];
            if (i > 0) {
                pw.println();
                pw.print("Caused by: ");
            }
            pw.print(throwable.toString());
        }
        return sw.toString();
    }

    static void printStackTrace(Throwable throwable, PrintWriter s) {
        Throwable[] stack = Util.toArray(throwable);
        DummyPrintWriter pw = new DummyPrintWriter(s);
        for (int i = 0; i < stack.length; ++i) {
            if (i > 0) {
                pw.println("caused by");
            }
            stack[i].printStackTrace(pw);
        }
        pw.flush();
    }

    static void printStackTrace(Throwable throwable, PrintStream s) {
        Throwable[] stack = Util.toArray(throwable);
        DummyPrintStream ps = new DummyPrintStream(s);
        for (int i = 0; i < stack.length; ++i) {
            if (i > 0) {
                ps.println("caused by");
            }
            stack[i].printStackTrace(ps);
        }
        ps.flush();
    }

    static void generateCommentBlock(PrintWriter pw, String name, String text, String comment) {
        String indent = "    ";
        pw.println("    /**");
        if (comment != null) {
            Util.fillText(pw, comment, "     * ", "", 70);
            pw.println();
            pw.println("     *");
        }
        pw.print("     * ");
        Util.fillText(pw, "<code>" + name + "</code> is '<code>" + StringEscaper.xmlEscaper.escapeString(text) + "</code>'", "     * ", "", -1);
        pw.println();
        pw.println("     */");
    }

    static String getClassNameSansPackage(String className, Locale locale) {
        String s = className;
        int lastDot = className.lastIndexOf(46);
        if (lastDot >= 0) {
            s = s.substring(lastDot + 1);
        }
        if (locale != null) {
            s = s + '_' + locale.toString();
        }
        return s;
    }

    protected static String removePackage(String s) {
        int lastDot = s.lastIndexOf(46);
        if (lastDot >= 0) {
            s = s.substring(lastDot + 1);
        }
        return s;
    }

    static class DummyPrintStream
    extends PrintStream {
        public DummyPrintStream(OutputStream out) {
            super(out);
        }
    }

    static class DummyPrintWriter
    extends PrintWriter {
        public DummyPrintWriter(Writer out) {
            super(out);
        }
    }
}

