/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractTupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.calc.impl.ListTupleList;
import mondrian.olap.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractEndToEndTupleList
extends AbstractTupleList {
    AbstractEndToEndTupleList(int arity) {
        super(arity);
    }

    @Override
    public TupleList project(final int[] destIndices) {
        final List<Member> backingList = this.backingList();
        final int originalArity = this.getArity();
        return new DelegatingTupleList(destIndices.length, (List<List<Member>>)new AbstractList<List<Member>>(){

            @Override
            public List<Member> get(int index) {
                final int n = index * originalArity;
                return new AbstractList<Member>(){

                    @Override
                    public Member get(int index) {
                        return (Member)backingList.get(n + destIndices[index]);
                    }

                    @Override
                    public int size() {
                        return destIndices.length;
                    }
                };
            }

            @Override
            public int size() {
                return backingList.size() / originalArity;
            }
        });
    }

    protected abstract List<Member> backingList();

    @Override
    public List<Member> set(int index, List<Member> element) {
        assert (this.mutable);
        List<Member> list = this.backingList();
        int startIndex = index * this.arity;
        for (int i = 0; i < this.arity; ++i) {
            list.set(startIndex + i, element.get(i));
        }
        return null;
    }

    @Override
    public boolean addAll(Collection<? extends List<Member>> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int i, Collection<? extends List<Member>> c) {
        assert (this.mutable);
        if (c instanceof AbstractEndToEndTupleList) {
            return this.backingList().addAll(i * this.arity, ((AbstractEndToEndTupleList)c).backingList());
        }
        return super.addAll(i, c);
    }

    @Override
    public TupleList subList(int fromIndex, int toIndex) {
        return new ListTupleList(this.arity, this.backingList().subList(fromIndex * this.arity, toIndex * this.arity));
    }

    @Override
    public TupleList withPositionCallback(TupleList.PositionCallback positionCallback) {
        assert (!(this.backingList() instanceof PositionSensingList));
        return new ListTupleList(this.arity, new PositionSensingList(positionCallback));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PositionSensingList
    extends AbstractList<Member> {
        private final TupleList.PositionCallback positionCallback;
        private final List<Member> backingList;

        public PositionSensingList(TupleList.PositionCallback positionCallback) {
            this.backingList = AbstractEndToEndTupleList.this.backingList();
            this.positionCallback = positionCallback;
        }

        @Override
        public Member get(int index) {
            this.positionCallback.onPosition(index / AbstractEndToEndTupleList.this.arity);
            return this.backingList.get(index);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }

        @Override
        public Member set(int index, Member element) {
            assert (AbstractEndToEndTupleList.this.mutable);
            this.positionCallback.onPosition(index / AbstractEndToEndTupleList.this.arity);
            return this.backingList.set(index, element);
        }

        @Override
        public void add(int index, Member element) {
            assert (AbstractEndToEndTupleList.this.mutable);
            this.positionCallback.onPosition(index);
            this.backingList.add(index, element);
        }

        @Override
        public Member remove(int index) {
            assert (AbstractEndToEndTupleList.this.mutable);
            this.positionCallback.onPosition(index);
            return this.backingList.remove(index);
        }
    }
}

