/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import mondrian.olap.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryTiming {
    private boolean enabled;
    private final Stack<TimingInfo> currentTimings = new Stack();
    private final Map<String, List<StartEnd>> timings = new HashMap<String, List<StartEnd>>();
    private final Map<String, DurationCount> fullTimings = new HashMap<String, DurationCount>();

    public void init(boolean enabled) {
        this.enabled = enabled;
        this.currentTimings.clear();
        this.timings.clear();
        this.fullTimings.clear();
    }

    public void done() {
    }

    public final void markStart(String name) {
        if (this.enabled) {
            this.markStartInternal(name);
        }
    }

    public final void markEnd(String name) {
        if (this.enabled) {
            long tstamp = System.currentTimeMillis();
            this.markEndInternal(name, tstamp);
        }
    }

    public final void markFull(String name, long duration) {
        if (this.enabled) {
            this.markFullInternal(name, duration);
        }
    }

    private void markStartInternal(String name) {
        this.currentTimings.push(new TimingInfo(name));
    }

    private void markEndInternal(String name, long tstamp) {
        if (this.currentTimings == null || this.currentTimings.isEmpty() || !this.currentTimings.peek().name.equals(name)) {
            throw new IllegalStateException("end but no start for " + name);
        }
        TimingInfo finished = this.currentTimings.pop();
        assert (finished.name.equals(name));
        finished.markEnd(tstamp);
        List<StartEnd> timingList = this.timings.get(finished.name);
        if (timingList == null) {
            timingList = new ArrayList<StartEnd>();
            this.timings.put(finished.name, timingList);
        }
        timingList.add(new StartEnd(finished.startTime, finished.endTime));
    }

    private void markFullInternal(String name, long duration) {
        DurationCount p = this.fullTimings.get(name);
        if (p == null) {
            p = new DurationCount();
            this.fullTimings.put(name, p);
        }
        ++p.count;
        p.duration += duration;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<StartEnd>> entry : this.timings.entrySet()) {
            if (sb.length() > 0) {
                sb.append(Util.nl);
            }
            long total = 0L;
            for (StartEnd durection : entry.getValue()) {
                total += durection.endTime - durection.startTime;
            }
            int count = entry.getValue().size();
            sb.append(entry.getKey()).append(" invoked ").append(count).append(" times for total of ").append(total).append("ms.  (Avg. ").append(total / (long)count).append("ms/invocation)");
        }
        for (Map.Entry<String, Object> entry : this.fullTimings.entrySet()) {
            if (sb.length() > 0) {
                sb.append(Util.nl);
            }
            sb.append(entry.getKey()).append(" invoked ").append(((DurationCount)entry.getValue()).count).append(" times for total of ").append(((DurationCount)entry.getValue()).duration).append("ms.  (Avg. ").append(((DurationCount)entry.getValue()).duration / ((DurationCount)entry.getValue()).count).append("ms/invocation)");
        }
        return sb.toString();
    }

    public Collection<String> getTimingKeys() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.timings.keySet());
        keys.addAll(this.fullTimings.keySet());
        return keys;
    }

    public List<Long> getTimings(String key) {
        DurationCount qTime;
        ArrayList<Long> timingList = new ArrayList<Long>();
        List<StartEnd> regTime = this.timings.get(key);
        if (regTime != null) {
            for (StartEnd timing : regTime) {
                timingList.add(timing.endTime - timing.startTime);
            }
        }
        if ((qTime = this.fullTimings.get(key)) != null) {
            Long duration = qTime.duration;
            int i = 0;
            while ((long)i < qTime.count) {
                timingList.add(duration);
                ++i;
            }
        }
        return timingList;
    }

    private static class DurationCount {
        long duration;
        long count;

        private DurationCount() {
        }
    }

    private static class StartEnd {
        final long startTime;
        final long endTime;

        public StartEnd(long startTime, long endTime) {
            this.startTime = startTime;
            this.endTime = endTime;
        }
    }

    private static class TimingInfo {
        private final String name;
        private final long startTime;
        private long endTime;

        private TimingInfo(String name) {
            this.name = name;
            this.startTime = System.currentTimeMillis();
        }

        private void markEnd(long tstamp) {
            this.endTime = tstamp;
        }
    }
}

