/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.TupleCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.calc.impl.CacheCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpCacheDescriptor;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.rolap.RolapUtil;

public class RankFunDef
extends FunDefBase {
    static final boolean debug = false;
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Rank", "Rank(<Tuple>, <Set> [, <Calc Expression>])", "Returns the one-based rank of a tuple in a set.", new String[]{"fitx", "fitxn", "fimx", "fimxn"}, RankFunDef.class);

    public RankFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        switch (call.getArgCount()) {
            case 2: {
                return this.compileCall2(call, compiler);
            }
            case 3: {
                return this.compileCall3(call, compiler);
            }
        }
        throw Util.newInternal("invalid arg count " + call.getArgCount());
    }

    public Calc compileCall3(ResolvedFunCall call, ExpCompiler compiler) {
        Type type0 = call.getArg(0).getType();
        ListCalc listCalc = compiler.compileList(call.getArg(1));
        Calc keyCalc = compiler.compileScalar(call.getArg(2), true);
        SortedListCalc sortedListCalc = new SortedListCalc(call, listCalc, keyCalc);
        ExpCacheDescriptor cacheDescriptor = new ExpCacheDescriptor(call, sortedListCalc, compiler.getEvaluator());
        if (type0 instanceof TupleType) {
            TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
            return new Rank3TupleCalc(call, tupleCalc, keyCalc, cacheDescriptor);
        }
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new Rank3MemberCalc(call, memberCalc, keyCalc, cacheDescriptor);
    }

    public Calc compileCall2(ResolvedFunCall call, ExpCompiler compiler) {
        AbstractCalc listCalc;
        boolean tuple = call.getArg(0).getType() instanceof TupleType;
        Exp listExp = call.getArg(1);
        ListCalc listCalc0 = compiler.compileList(listExp);
        RankedListCalc listCalc1 = new RankedListCalc(listCalc0, tuple);
        if (MondrianProperties.instance().EnableExpCache.get()) {
            ExpCacheDescriptor key = new ExpCacheDescriptor(listExp, listCalc1, compiler.getEvaluator());
            listCalc = new CacheCalc(listExp, key);
        } else {
            listCalc = listCalc1;
        }
        if (tuple) {
            TupleCalc tupleCalc = compiler.compileTuple(call.getArg(0));
            return new Rank2TupleCalc(call, tupleCalc, listCalc);
        }
        MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        return new Rank2MemberCalc(call, memberCalc, listCalc);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RankedTupleList {
        final Map<List<Member>, Integer> map = new HashMap<List<Member>, Integer>();

        RankedTupleList(TupleList tupleList) {
            int i = -1;
            for (List tupleMembers : tupleList.fix()) {
                Integer value = this.map.put(tupleMembers, ++i);
                if (value == null) continue;
                this.map.put(tupleMembers, value);
            }
        }

        int indexOf(List<Member> tupleMembers) {
            Integer integer = this.map.get(tupleMembers);
            if (integer == null) {
                return -1;
            }
            return integer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RankedMemberList {
        Map<Member, Integer> map = new HashMap<Member, Integer>();

        RankedMemberList(List<Member> members) {
            int i = -1;
            for (Member member : members) {
                Integer value = this.map.put(member, ++i);
                if (value == null) continue;
                this.map.put(member, value);
            }
        }

        int indexOf(Member m) {
            Integer integer = this.map.get(m);
            if (integer == null) {
                return -1;
            }
            return integer;
        }
    }

    private static class RankedListCalc
    extends AbstractCalc {
        private final ListCalc listCalc;
        private final boolean tuple;

        public RankedListCalc(ListCalc listCalc, boolean tuple) {
            super(new DummyExp(listCalc.getType()), new Calc[]{listCalc});
            this.listCalc = listCalc;
            this.tuple = tuple;
        }

        public Object evaluate(Evaluator evaluator) {
            TupleList tupleList = this.listCalc.evaluateList(evaluator);
            assert (tupleList != null);
            if (this.tuple) {
                return new RankedTupleList(tupleList);
            }
            return new RankedMemberList(tupleList.slice(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TupleSortResult
    extends SortResult {
        final Map<List<Member>, Integer> rankMap;

        public TupleSortResult(Object[] values, Map<List<Member>, Integer> rankMap) {
            super(values);
            this.rankMap = rankMap;
        }

        public Integer rankOf(Member[] tuple) {
            return this.rankMap.get(Arrays.asList(tuple));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberSortResult
    extends SortResult {
        final Map<Member, Integer> rankMap;

        public MemberSortResult(Object[] values, Map<Member, Integer> rankMap) {
            super(values);
            this.rankMap = rankMap;
        }

        public Integer rankOf(Member member) {
            return this.rankMap.get(member);
        }
    }

    private static abstract class SortResult {
        final Object[] values;

        public SortResult(Object[] values) {
            this.values = values;
        }

        public boolean isEmpty() {
            return this.values == null;
        }

        public void print(PrintWriter pw) {
            if (this.values == null) {
                pw.println("SortResult: empty");
            } else {
                pw.println("SortResult {");
                for (int i = 0; i < this.values.length; ++i) {
                    if (i > 0) {
                        pw.println(",");
                    }
                    Object value = this.values[i];
                    pw.print(value);
                }
                pw.println("}");
            }
            pw.flush();
        }
    }

    private static class SortedListCalc
    extends AbstractCalc {
        private final ListCalc listCalc;
        private final Calc keyCalc;
        private static final Integer ONE = 1;

        public SortedListCalc(Exp exp, ListCalc listCalc, Calc keyCalc) {
            super(exp, new Calc[]{listCalc, keyCalc});
            this.listCalc = listCalc;
            this.keyCalc = keyCalc;
        }

        public boolean dependsOn(Hierarchy hierarchy) {
            return SortedListCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object evaluate(Evaluator evaluator) {
            HashMap<Member, Integer> rankMap;
            int numValues;
            HashMap<List, Object> tupleValueMap;
            HashMap<Member, Object> memberValueMap;
            TupleList list;
            int savepoint = evaluator.savepoint();
            RuntimeException exception = null;
            TreeMap<Object, Integer> uniqueValueCounterMap = new TreeMap<Object, Integer>(FunUtil.DescendingValueComparator.instance);
            try {
                Integer valueCounter;
                Object keyValue;
                evaluator.setNonEmpty(false);
                list = this.listCalc.evaluateList(evaluator);
                assert (list != null);
                if (list.isEmpty()) {
                    SortResult sortResult = list.getArity() == 1 ? new MemberSortResult(new Object[0], Collections.<Member, Integer>emptyMap()) : new TupleSortResult(new Object[0], Collections.<List<Member>, Integer>emptyMap());
                    return sortResult;
                }
                if (list.getArity() == 1) {
                    memberValueMap = new HashMap<Member, Object>();
                    tupleValueMap = null;
                    for (Member member : list.slice(0)) {
                        evaluator.setContext(member);
                        keyValue = this.keyCalc.evaluate(evaluator);
                        if (keyValue instanceof RuntimeException) {
                            if (exception != null) continue;
                            exception = (RuntimeException)keyValue;
                            continue;
                        }
                        if (Util.isNull(keyValue)) continue;
                        valueCounter = uniqueValueCounterMap.put(keyValue, ONE);
                        if (valueCounter != null) {
                            uniqueValueCounterMap.put(keyValue, valueCounter + 1);
                        }
                        memberValueMap.put(member, keyValue);
                    }
                    numValues = memberValueMap.keySet().size();
                } else {
                    tupleValueMap = new HashMap<List, Object>();
                    memberValueMap = null;
                    for (List tuple : list) {
                        evaluator.setContext(tuple);
                        keyValue = this.keyCalc.evaluate(evaluator);
                        if (keyValue instanceof RuntimeException) {
                            if (exception != null) continue;
                            exception = (RuntimeException)keyValue;
                            continue;
                        }
                        if (Util.isNull(keyValue)) continue;
                        valueCounter = uniqueValueCounterMap.put(keyValue, ONE);
                        if (valueCounter != null) {
                            uniqueValueCounterMap.put(keyValue, valueCounter + 1);
                        }
                        tupleValueMap.put(tuple, keyValue);
                    }
                    numValues = tupleValueMap.keySet().size();
                }
            }
            finally {
                evaluator.restore(savepoint);
            }
            if (exception != null) {
                return exception;
            }
            Object[] allValuesSorted = new Object[numValues];
            int currentOrdinal = 0;
            TreeMap uniqueValueRankMap = new TreeMap(Collections.reverseOrder());
            for (Map.Entry entry : uniqueValueCounterMap.entrySet()) {
                Object keyValue = entry.getKey();
                Integer valueCount = (Integer)entry.getValue();
                for (int i = 0; i < valueCount; ++i) {
                    allValuesSorted[currentOrdinal + i] = keyValue;
                }
                uniqueValueRankMap.put(keyValue, currentOrdinal + 1);
                currentOrdinal += valueCount.intValue();
            }
            if (list.getArity() == 1) {
                rankMap = new HashMap<Member, Integer>();
                for (Map.Entry entry : memberValueMap.entrySet()) {
                    int oneBasedRank = (Integer)uniqueValueRankMap.get(entry.getValue());
                    rankMap.put((Member)entry.getKey(), oneBasedRank);
                }
                return new MemberSortResult(allValuesSorted, rankMap);
            }
            rankMap = new HashMap();
            for (Map.Entry entry : tupleValueMap.entrySet()) {
                int oneBasedRank = (Integer)uniqueValueRankMap.get(entry.getValue());
                rankMap.put((Member)entry.getKey(), oneBasedRank);
            }
            return new TupleSortResult(allValuesSorted, rankMap);
        }
    }

    private static class Rank3MemberCalc
    extends AbstractIntegerCalc {
        private final MemberCalc memberCalc;
        private final Calc sortCalc;
        private final ExpCacheDescriptor cacheDescriptor;

        public Rank3MemberCalc(ResolvedFunCall call, MemberCalc memberCalc, Calc sortCalc, ExpCacheDescriptor cacheDescriptor) {
            super(call, new Calc[]{memberCalc, sortCalc});
            this.memberCalc = memberCalc;
            this.sortCalc = sortCalc;
            this.cacheDescriptor = cacheDescriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int evaluateInteger(Evaluator evaluator) {
            Object value;
            Member member = this.memberCalc.evaluateMember(evaluator);
            if (member == null || member.isNull()) {
                return -2147483647;
            }
            MemberSortResult sortResult = (MemberSortResult)evaluator.getCachedResult(this.cacheDescriptor);
            if (sortResult.isEmpty()) {
                return -2147483647;
            }
            Integer rank = sortResult.rankOf(member);
            if (rank != null) {
                return rank;
            }
            int savepoint = evaluator.savepoint();
            evaluator.setContext(member);
            try {
                value = this.sortCalc.evaluate(evaluator);
            }
            finally {
                evaluator.restore(savepoint);
            }
            if (value == RolapUtil.valueNotReadyException) {
                return 0;
            }
            if (value == Util.nullValue || value == null) {
                return sortResult.values.length + 1;
            }
            int j = Arrays.binarySearch(sortResult.values, value, Collections.reverseOrder());
            if (j < 0) {
                j = -(j + 1);
            }
            return j + 1;
        }
    }

    private static class Rank3TupleCalc
    extends AbstractIntegerCalc {
        private final TupleCalc tupleCalc;
        private final Calc sortCalc;
        private final ExpCacheDescriptor cacheDescriptor;

        public Rank3TupleCalc(ResolvedFunCall call, TupleCalc tupleCalc, Calc sortCalc, ExpCacheDescriptor cacheDescriptor) {
            super(call, new Calc[]{tupleCalc, sortCalc});
            this.tupleCalc = tupleCalc;
            this.sortCalc = sortCalc;
            this.cacheDescriptor = cacheDescriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int evaluateInteger(Evaluator evaluator) {
            Object value;
            Member[] members = this.tupleCalc.evaluateTuple(evaluator);
            if (members == null) {
                return -2147483647;
            }
            assert (!FunUtil.tupleContainsNullMember(members));
            TupleSortResult sortResult = (TupleSortResult)evaluator.getCachedResult(this.cacheDescriptor);
            if (sortResult.isEmpty()) {
                return -2147483647;
            }
            Integer rank = sortResult.rankOf(members);
            if (rank != null) {
                return rank;
            }
            int savepoint = evaluator.savepoint();
            try {
                evaluator.setContext(members);
                value = this.sortCalc.evaluate(evaluator);
            }
            finally {
                evaluator.restore(savepoint);
            }
            if (value == RolapUtil.valueNotReadyException) {
                return 0;
            }
            if (value == Util.nullValue || value == null) {
                return sortResult.values.length + 1;
            }
            int j = Arrays.binarySearch(sortResult.values, value, Collections.reverseOrder());
            if (j < 0) {
                j = -(j + 1);
            }
            return j + 1;
        }
    }

    private static class Rank2MemberCalc
    extends AbstractIntegerCalc {
        private final MemberCalc memberCalc;
        private final Calc listCalc;

        public Rank2MemberCalc(ResolvedFunCall call, MemberCalc memberCalc, Calc listCalc) {
            super(call, new Calc[]{memberCalc, listCalc});
            this.memberCalc = memberCalc;
            this.listCalc = listCalc;
        }

        public int evaluateInteger(Evaluator evaluator) {
            Member member = this.memberCalc.evaluateMember(evaluator);
            if (member == null || member.isNull()) {
                return -2147483647;
            }
            RankedMemberList rankedMemberList = (RankedMemberList)this.listCalc.evaluate(evaluator);
            if (rankedMemberList == null) {
                return 0;
            }
            int i = rankedMemberList.indexOf(member);
            return i + 1;
        }
    }

    private static class Rank2TupleCalc
    extends AbstractIntegerCalc {
        private final TupleCalc tupleCalc;
        private final Calc listCalc;

        public Rank2TupleCalc(ResolvedFunCall call, TupleCalc tupleCalc, Calc listCalc) {
            super(call, new Calc[]{tupleCalc, listCalc});
            this.tupleCalc = tupleCalc;
            this.listCalc = listCalc;
        }

        public int evaluateInteger(Evaluator evaluator) {
            Member[] members = this.tupleCalc.evaluateTuple(evaluator);
            if (members == null) {
                return -2147483647;
            }
            assert (!FunUtil.tupleContainsNullMember(members));
            RankedTupleList rankedTupleList = (RankedTupleList)this.listCalc.evaluate(evaluator);
            if (rankedTupleList == null) {
                return 0;
            }
            List<Member> memberList = Arrays.asList(members);
            int i = rankedTupleList.indexOf(memberList);
            return i + 1;
        }
    }
}

