/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collections;
import java.util.List;
import mondrian.calc.ResultStyle;
import mondrian.olap.DrillThrough;
import mondrian.olap.Explain;
import mondrian.olap.MondrianException;
import mondrian.olap.Query;
import mondrian.olap.QueryCanceledException;
import mondrian.olap.QueryPart;
import mondrian.olap.QueryTimeoutException;
import mondrian.olap4j.MondrianOlap4jCell;
import mondrian.olap4j.MondrianOlap4jCellSet;
import mondrian.olap4j.MondrianOlap4jCellSetMetaData;
import mondrian.olap4j.MondrianOlap4jConnection;
import mondrian.rolap.RolapConnection;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.server.Statement;
import mondrian.server.StatementImpl;
import mondrian.util.Pair;
import org.olap4j.CellSet;
import org.olap4j.CellSetListener;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.SelectNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MondrianOlap4jStatement
extends StatementImpl
implements OlapStatement,
Statement {
    final MondrianOlap4jConnection olap4jConnection;
    private boolean closed;
    protected boolean closeOnCompletion;
    MondrianOlap4jCellSet openCellSet;

    MondrianOlap4jStatement(MondrianOlap4jConnection olap4jConnection) {
        assert (olap4jConnection != null);
        this.olap4jConnection = olap4jConnection;
        this.closed = false;
    }

    public ResultSet executeQuery(String mdx) throws SQLException {
        return this.executeQuery2(mdx, false, null, null);
    }

    ResultSet executeQuery2(String mdx, boolean advanced, String tabFields, int[] rowCountSlot) throws SQLException {
        QueryPart parseTree;
        if (advanced) {
            throw new UnsupportedOperationException();
        }
        try {
            parseTree = this.olap4jConnection.getMondrianConnection().parseStatement(mdx);
        }
        catch (MondrianException e) {
            throw this.olap4jConnection.helper.createException("mondrian gave exception while parsing query", e);
        }
        if (parseTree instanceof DrillThrough) {
            DrillThrough drillThrough = (DrillThrough)parseTree;
            Query query = drillThrough.getQuery();
            query.setResultStyle(ResultStyle.LIST);
            this.setQuery(query);
            CellSet cellSet = this.executeOlapQueryInternal(query, null);
            List<Integer> coords = Collections.nCopies(cellSet.getAxes().size(), 0);
            MondrianOlap4jCell cell = (MondrianOlap4jCell)cellSet.getCell(coords);
            ResultSet resultSet = cell.drillThroughInternal(drillThrough.getMaxRowCount(), drillThrough.getFirstRowOrdinal(), drillThrough.getReturnList(), true, null, rowCountSlot);
            if (resultSet == null) {
                throw new OlapException("Cannot do DrillThrough operation on the cell");
            }
            return resultSet;
        }
        if (parseTree instanceof Explain) {
            String plan = this.explainInternal(((Explain)parseTree).getQuery());
            return this.olap4jConnection.factory.newFixedResultSet(this.olap4jConnection, Collections.singletonList("PLAN"), Collections.singletonList(Collections.singletonList(plan)));
        }
        throw this.olap4jConnection.helper.createException("Query does not have relational result. Use a DRILLTHROUGH query, or execute using the executeOlapQuery method.");
    }

    private String explainInternal(QueryPart query) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        query.explain(pw);
        pw.flush();
        return sw.toString();
    }

    public int executeUpdate(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.olap4jConnection.mondrianServer.removeStatement(this);
            if (this.openCellSet != null) {
                MondrianOlap4jCellSet c = this.openCellSet;
                this.openCellSet = null;
                c.close();
            }
        }
    }

    public int getMaxFieldSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getMaxRows() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setMaxRows(int max) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getQueryTimeout() throws SQLException {
        long timeoutSeconds = this.getQueryTimeoutMillis() / 1000L;
        if (timeoutSeconds > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (timeoutSeconds == 0L && this.getQueryTimeoutMillis() > 0L) {
            return 1;
        }
        return (int)timeoutSeconds;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw this.olap4jConnection.helper.createException("illegal timeout value " + seconds);
        }
        this.setQueryTimeoutMillis(seconds * 1000);
    }

    @Override
    public synchronized void cancel() throws SQLException {
        if (this.openCellSet != null) {
            this.openCellSet.cancel();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setCursorName(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.openCellSet;
    }

    public int getUpdateCount() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean getMoreResults() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetConcurrency() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetType() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void addBatch(String sql) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void clearBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int[] executeBatch() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public OlapConnection getConnection() {
        return this.olap4jConnection;
    }

    public boolean getMoreResults(int current) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getResultSetHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public void setPoolable(boolean poolable) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isPoolable() throws SQLException {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.olap4jConnection.helper.createException("does not implement '" + iface + "'");
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public CellSet executeOlapQuery(String mdx) throws OlapException {
        Pair<Query, MondrianOlap4jCellSetMetaData> pair = this.parseQuery(mdx);
        return this.executeOlapQueryInternal((Query)pair.left, (MondrianOlap4jCellSetMetaData)pair.right);
    }

    protected Pair<Query, MondrianOlap4jCellSetMetaData> parseQuery(final String mdx) throws OlapException {
        try {
            final RolapConnection mondrianConnection = this.getMondrianConnection();
            return Locus.execute(mondrianConnection, "Parsing query", new Locus.Action<Pair<Query, MondrianOlap4jCellSetMetaData>>(){

                @Override
                public Pair<Query, MondrianOlap4jCellSetMetaData> execute() {
                    Query query = (Query)mondrianConnection.parseStatement(MondrianOlap4jStatement.this, mdx, null, false);
                    MondrianOlap4jCellSetMetaData cellSetMetaData = new MondrianOlap4jCellSetMetaData(MondrianOlap4jStatement.this, query);
                    return Pair.of(query, cellSetMetaData);
                }
            });
        }
        catch (MondrianException e) {
            throw this.olap4jConnection.helper.createException("mondrian gave exception while parsing query", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CellSet executeOlapQueryInternal(Query query, MondrianOlap4jCellSetMetaData cellSetMetaData) throws OlapException {
        MondrianOlap4jStatement mondrianOlap4jStatement = this;
        synchronized (mondrianOlap4jStatement) {
            if (this.openCellSet != null) {
                MondrianOlap4jCellSet cs = this.openCellSet;
                this.openCellSet = null;
                try {
                    cs.close();
                }
                catch (Exception e) {
                    throw this.olap4jConnection.helper.createException(null, "Error while closing previous CellSet", e);
                }
            }
            if (this.olap4jConnection.preferList) {
                query.setResultStyle(ResultStyle.LIST);
            }
            this.query = query;
            this.openCellSet = this.olap4jConnection.factory.newCellSet(this);
        }
        try {
            this.openCellSet.execute();
        }
        catch (QueryCanceledException e) {
            throw this.olap4jConnection.helper.createException("Query canceled");
        }
        catch (QueryTimeoutException e) {
            throw this.olap4jConnection.helper.createException(e.getMessage());
        }
        catch (MondrianException e) {
            throw this.olap4jConnection.helper.createException("mondrian gave exception while executing query", e);
        }
        return this.openCellSet;
    }

    @Override
    public void start(Execution execution) {
        super.start(this.openCellSet);
    }

    public CellSet executeOlapQuery(SelectNode selectNode) throws OlapException {
        String mdx = MondrianOlap4jStatement.toString((ParseTreeNode)selectNode);
        return this.executeOlapQuery(mdx);
    }

    public void addListener(CellSetListener.Granularity granularity, CellSetListener cellSetListener) throws OlapException {
        throw new UnsupportedOperationException();
    }

    private static String toString(ParseTreeNode node) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ParseTreeWriter parseTreeWriter = new ParseTreeWriter(pw);
        node.unparse(parseTreeWriter);
        pw.flush();
        return sw.toString();
    }

    @Override
    public RolapConnection getMondrianConnection() {
        try {
            return this.olap4jConnection.getMondrianConnection();
        }
        catch (OlapException e) {
            throw new RuntimeException(e);
        }
    }

    void onResultSetClose(ResultSet resultSet) {
        if (this.closeOnCompletion) {
            this.close();
        }
    }
}

