/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.FastBatchingCellReader;
import mondrian.rolap.GroupingSetsCollector;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentBuilder;
import mondrian.rolap.agg.SegmentCacheManager;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.rolap.agg.SegmentWithData;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.aggmatcher.AggGen;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.cache.SegmentCacheIndex;
import mondrian.rolap.cache.SegmentCacheIndexImpl;
import mondrian.server.Locus;
import mondrian.spi.Dialect;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentHeader;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BatchLoader {
    private static final Logger LOGGER = Logger.getLogger(FastBatchingCellReader.class);
    private final Locus locus;
    private final SegmentCacheManager cacheMgr;
    private final Dialect dialect;
    private final RolapCube cube;
    private final Map<AggregationKey, Batch> batches = new HashMap<AggregationKey, Batch>();
    private final Set<SegmentHeader> cacheHeaders = new LinkedHashSet<SegmentHeader>();
    private final Map<SegmentHeader, Future<SegmentBody>> futures = new HashMap<SegmentHeader, Future<SegmentBody>>();
    private final List<RollupInfo> rollups = new ArrayList<RollupInfo>();
    private final Set<BitKey> rollupBitmaps = new HashSet<BitKey>();
    private final Map<List, SegmentBuilder.SegmentConverter> converterMap = new HashMap<List, SegmentBuilder.SegmentConverter>();
    private static final Logger BATCH_LOGGER = Logger.getLogger(Batch.class);

    public BatchLoader(Locus locus, SegmentCacheManager cacheMgr, Dialect dialect, RolapCube cube) {
        this.locus = locus;
        this.cacheMgr = cacheMgr;
        this.dialect = dialect;
        this.cube = cube;
    }

    final boolean shouldUseGroupingFunction() {
        return MondrianProperties.instance().EnableGroupingSets.get() && this.dialect.supportsGroupingSets();
    }

    private void recordCellRequest2(CellRequest request) {
        AggregationKey key = new AggregationKey(request);
        SegmentBuilder.SegmentConverterImpl converter = new SegmentBuilder.SegmentConverterImpl(key, request);
        boolean success = this.loadFromCaches(request, key, converter);
        if (this.rollupBitmaps.contains(request.getConstrainedColumnsBitKey())) {
            return;
        }
        if (!success) {
            this.loadFromSql(request, key, converter);
        }
    }

    private boolean loadFromCaches(CellRequest request, AggregationKey key, SegmentBuilder.SegmentConverterImpl converter) {
        List<List<SegmentHeader>> rollup;
        if (MondrianProperties.instance().DisableCaching.get()) {
            return false;
        }
        Map<String, Comparable> mappedCellValues = request.getMappedCellValues();
        List<String> compoundPredicates = AggregationKey.getCompoundPredicateStringList(key.getStar(), key.getCompoundPredicateList());
        for (SegmentHeader header : this.cacheHeaders) {
            if (!SegmentCacheIndexImpl.matches(header, mappedCellValues, compoundPredicates)) continue;
            return true;
        }
        RolapStar.Measure measure = request.getMeasure();
        RolapStar star = measure.getStar();
        RolapSchema schema = star.getSchema();
        SegmentCacheIndex index = this.cacheMgr.getIndexRegistry().getIndex(star);
        List<SegmentHeader> headersInCache = index.locate(schema.getName(), schema.getChecksum(), measure.getCubeName(), measure.getName(), star.getFactTable().getAlias(), request.getConstrainedColumnsBitKey(), mappedCellValues, compoundPredicates);
        if (!headersInCache.isEmpty()) {
            SegmentHeader headerInCache = headersInCache.get(0);
            Future<SegmentBody> future = index.getFuture(headerInCache);
            if (future != null) {
                this.futures.put(headerInCache, future);
            } else {
                this.cacheHeaders.add(headerInCache);
            }
            index.setConverter(headerInCache.schemaName, headerInCache.schemaChecksum, headerInCache.cubeName, headerInCache.rolapStarFactTableName, headerInCache.measureName, headerInCache.compoundPredicates, converter);
            this.converterMap.put(SegmentCacheIndexImpl.makeConverterKey(request, key), converter);
            return true;
        }
        if (MondrianProperties.instance().EnableInMemoryRollup.get() && measure.getAggregator().supportsFastAggregates(measure.getDatatype()) && measure.getAggregator().getRollup().supportsFastAggregates(measure.getDatatype()) && !this.rollupBitmaps.contains(request.getConstrainedColumnsBitKey()) && !(rollup = index.findRollupCandidates(schema.getName(), schema.getChecksum(), measure.getCubeName(), measure.getName(), star.getFactTable().getAlias(), request.getConstrainedColumnsBitKey(), mappedCellValues, AggregationKey.getCompoundPredicateStringList(star, key.getCompoundPredicateList()))).isEmpty()) {
            this.rollups.add(new RollupInfo(request, rollup));
            this.rollupBitmaps.add(request.getConstrainedColumnsBitKey());
            this.converterMap.put(SegmentCacheIndexImpl.makeConverterKey(request, key), new SegmentBuilder.StarSegmentConverter(measure, key.getCompoundPredicateList()));
            return true;
        }
        return false;
    }

    private void loadFromSql(CellRequest request, AggregationKey key, SegmentBuilder.SegmentConverterImpl converter) {
        Batch batch = this.batches.get(key);
        if (batch == null) {
            batch = new Batch(request);
            this.batches.put(key, batch);
            this.converterMap.put(SegmentCacheIndexImpl.makeConverterKey(request, key), converter);
            if (LOGGER.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder(100);
                buf.append("FastBatchingCellReader: bitkey=");
                buf.append(request.getConstrainedColumnsBitKey());
                buf.append(Util.nl);
                for (RolapStar.Column column : request.getConstrainedColumns()) {
                    buf.append("  ");
                    buf.append(column);
                    buf.append(Util.nl);
                }
                LOGGER.debug((Object)buf.toString());
            }
        }
        batch.add(request);
    }

    LoadBatchResponse load(List<CellRequest> cellRequests) {
        if (this.locus.execution != null) {
            this.locus.execution.checkCancelOrTimeout();
        }
        long t1 = System.currentTimeMillis();
        for (CellRequest cellRequest : cellRequests) {
            this.recordCellRequest2(cellRequest);
        }
        ArrayList<Batch> batchList = new ArrayList<Batch>(this.batches.values());
        Collections.sort(batchList, BatchComparator.instance);
        ArrayList<Future<Map<Segment, SegmentWithData>>> segmentMapFutures = new ArrayList<Future<Map<Segment, SegmentWithData>>>();
        if (this.shouldUseGroupingFunction()) {
            LOGGER.debug((Object)"Using grouping sets");
            List<CompositeBatch> groupedBatches = BatchLoader.groupBatches(batchList);
            for (CompositeBatch batch : groupedBatches) {
                batch.load(segmentMapFutures);
            }
        } else {
            for (Batch batch : batchList) {
                batch.loadAggregation(segmentMapFutures);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            long t2 = System.currentTimeMillis();
            LOGGER.debug((Object)("load (millis): " + (t2 - t1)));
        }
        return new LoadBatchResponse(cellRequests, new ArrayList<SegmentHeader>(this.cacheHeaders), this.rollups, this.converterMap, segmentMapFutures, this.futures);
    }

    static List<CompositeBatch> groupBatches(List<Batch> batchList) {
        HashMap<AggregationKey, CompositeBatch> batchGroups = new HashMap<AggregationKey, CompositeBatch>();
        for (int i = 0; i < batchList.size(); ++i) {
            int j = i + 1;
            while (j < batchList.size()) {
                Batch jBatch;
                Batch iBatch = batchList.get(i);
                if (iBatch.canBatch(jBatch = batchList.get(j))) {
                    batchList.remove(j);
                    BatchLoader.addToCompositeBatch(batchGroups, iBatch, jBatch);
                    continue;
                }
                if (jBatch.canBatch(iBatch)) {
                    batchList.set(i, jBatch);
                    batchList.remove(j);
                    BatchLoader.addToCompositeBatch(batchGroups, jBatch, iBatch);
                    j = i + 1;
                    continue;
                }
                ++j;
            }
        }
        BatchLoader.wrapNonBatchedBatchesWithCompositeBatches(batchList, batchGroups);
        CompositeBatch[] compositeBatches = batchGroups.values().toArray(new CompositeBatch[batchGroups.size()]);
        Arrays.sort(compositeBatches, CompositeBatchComparator.instance);
        return Arrays.asList(compositeBatches);
    }

    private static void wrapNonBatchedBatchesWithCompositeBatches(List<Batch> batchList, Map<AggregationKey, CompositeBatch> batchGroups) {
        for (Batch batch : batchList) {
            if (batchGroups.get(batch.batchKey) != null) continue;
            batchGroups.put(batch.batchKey, new CompositeBatch(batch));
        }
    }

    static void addToCompositeBatch(Map<AggregationKey, CompositeBatch> batchGroups, Batch detailedBatch, Batch summaryBatch) {
        CompositeBatch compositeBatchOfSummaryBatch;
        CompositeBatch compositeBatch = batchGroups.get(detailedBatch.batchKey);
        if (compositeBatch == null) {
            compositeBatch = new CompositeBatch(detailedBatch);
            batchGroups.put(detailedBatch.batchKey, compositeBatch);
        }
        if ((compositeBatchOfSummaryBatch = batchGroups.remove(summaryBatch.batchKey)) != null) {
            compositeBatch.merge(compositeBatchOfSummaryBatch);
        } else {
            compositeBatch.add(summaryBatch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueColumnConstraintComparator
    implements Comparator<ValueColumnPredicate> {
        static final ValueColumnConstraintComparator instance = new ValueColumnConstraintComparator();

        private ValueColumnConstraintComparator() {
        }

        @Override
        public int compare(ValueColumnPredicate o1, ValueColumnPredicate o2) {
            Object v1 = o1.getValue();
            Object v2 = o2.getValue();
            if (v1.getClass() == v2.getClass() && v1 instanceof Comparable) {
                return ((Comparable)v1).compareTo(v2);
            }
            return v1.toString().compareTo(v2.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BatchComparator
    implements Comparator<Batch> {
        static final BatchComparator instance = new BatchComparator();

        private BatchComparator() {
        }

        @Override
        public int compare(Batch o1, Batch o2) {
            int c;
            int i;
            if (o1.columns.length != o2.columns.length) {
                return o1.columns.length - o2.columns.length;
            }
            for (i = 0; i < o1.columns.length; ++i) {
                c = o1.columns[i].getName().compareTo(o2.columns[i].getName());
                if (c == 0) continue;
                return c;
            }
            for (i = 0; i < o1.columns.length; ++i) {
                c = this.compare(o1.valueSets[i], o2.valueSets[i]);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        @Override
        <T> int compare(Set<T> set1, Set<T> set2) {
            if (set1.size() != set2.size()) {
                return set1.size() - set2.size();
            }
            Iterator<T> iter1 = set1.iterator();
            Iterator<T> iter2 = set2.iterator();
            while (iter1.hasNext()) {
                T v2;
                T v1 = iter1.next();
                int c = Util.compareKey(v1, v2 = iter2.next());
                if (c == 0) continue;
                return c;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeBatchComparator
    implements Comparator<CompositeBatch> {
        static final CompositeBatchComparator instance = new CompositeBatchComparator();

        private CompositeBatchComparator() {
        }

        @Override
        public int compare(CompositeBatch o1, CompositeBatch o2) {
            return BatchComparator.instance.compare(o1.detailedBatch, o2.detailedBatch);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Batch {
        final RolapStar.Column[] columns;
        final List<RolapStar.Measure> measuresList = new ArrayList<RolapStar.Measure>();
        final Set<StarColumnPredicate>[] valueSets;
        final AggregationKey batchKey;
        private String string;
        private int cellRequestCount;
        private List<StarColumnPredicate[]> tuples = new ArrayList<StarColumnPredicate[]>();

        public Batch(CellRequest request) {
            this.columns = request.getConstrainedColumns();
            this.valueSets = new HashSet[this.columns.length];
            for (int i = 0; i < this.valueSets.length; ++i) {
                this.valueSets[i] = new HashSet<StarColumnPredicate>();
            }
            this.batchKey = new AggregationKey(request);
        }

        public String toString() {
            if (this.string == null) {
                StringBuilder buf = new StringBuilder();
                buf.append("Batch {\n").append("  columns={").append(Arrays.toString(this.columns)).append("}\n").append("  measures={").append(this.measuresList).append("}\n").append("  valueSets={").append(Arrays.toString(this.valueSets)).append("}\n").append("  batchKey=").append(this.batchKey).append("}\n").append("}");
                this.string = buf.toString();
            }
            return this.string;
        }

        public final void add(CellRequest request) {
            ++this.cellRequestCount;
            int valueCount = request.getNumValues();
            StarColumnPredicate[] tuple = new StarColumnPredicate[valueCount];
            for (int j = 0; j < valueCount; ++j) {
                StarColumnPredicate value = request.getValueAt(j);
                this.valueSets[j].add(value);
                tuple[j] = value;
            }
            this.tuples.add(tuple);
            RolapStar.Measure measure = request.getMeasure();
            if (!this.measuresList.contains(measure)) {
                assert (this.measuresList.size() == 0 || measure.getStar() == this.measuresList.get(0).getStar()) : "Measure must belong to same star as other measures";
                this.measuresList.add(measure);
            }
        }

        private RolapStar getStar() {
            RolapStar.Measure measure = this.measuresList.get(0);
            return measure.getStar();
        }

        public BitKey getConstrainedColumnsBitKey() {
            return this.batchKey.getConstrainedColumnsBitKey();
        }

        public SegmentCacheManager getCacheMgr() {
            return BatchLoader.this.cacheMgr;
        }

        public final void loadAggregation(List<Future<Map<Segment, SegmentWithData>>> segmentFutures) {
            GroupingSetsCollector collectorWithGroupingSetsTurnedOff = new GroupingSetsCollector(false);
            this.loadAggregation(collectorWithGroupingSetsTurnedOff, segmentFutures);
        }

        final void loadAggregation(GroupingSetsCollector groupingSetsCollector, List<Future<Map<Segment, SegmentWithData>>> segmentFutures) {
            int measureCount;
            boolean tooManyDistinctMeasures;
            if (MondrianProperties.instance().GenerateAggregateSql.get()) {
                this.generateAggregateSql();
            }
            StarColumnPredicate[] predicates = this.initPredicates();
            long t1 = System.currentTimeMillis();
            int distinctMeasureCount = this.getDistinctMeasureCount(this.measuresList);
            boolean bl = tooManyDistinctMeasures = distinctMeasureCount > 0 && !BatchLoader.this.dialect.allowsCountDistinct() || distinctMeasureCount > 1 && !BatchLoader.this.dialect.allowsMultipleCountDistinct();
            if (tooManyDistinctMeasures) {
                this.doSpecialHandlingOfDistinctCountMeasures(predicates, groupingSetsCollector, segmentFutures);
            }
            if (!BatchLoader.this.dialect.allowsMultipleDistinctSqlMeasures()) {
                List<RolapStar.Measure> distinctSqlMeasureList = this.getDistinctSqlMeasures(this.measuresList);
                for (RolapStar.Measure measure : distinctSqlMeasureList) {
                    AggregationManager.loadAggregation(BatchLoader.this.cacheMgr, this.cellRequestCount, Collections.singletonList(measure), this.columns, this.batchKey, predicates, groupingSetsCollector, segmentFutures);
                    this.measuresList.remove(measure);
                }
            }
            if ((measureCount = this.measuresList.size()) > 0) {
                AggregationManager.loadAggregation(BatchLoader.this.cacheMgr, this.cellRequestCount, this.measuresList, this.columns, this.batchKey, predicates, groupingSetsCollector, segmentFutures);
            }
            if (BATCH_LOGGER.isDebugEnabled()) {
                long t2 = System.currentTimeMillis();
                BATCH_LOGGER.debug((Object)("Batch.load (millis) " + (t2 - t1)));
            }
        }

        private void doSpecialHandlingOfDistinctCountMeasures(StarColumnPredicate[] predicates, GroupingSetsCollector groupingSetsCollector, List<Future<Map<Segment, SegmentWithData>>> segmentFutures) {
            RolapStar.Measure distinctMeasure;
            while ((distinctMeasure = this.getFirstDistinctMeasure(this.measuresList)) != null) {
                String expr = distinctMeasure.getExpression().getGenericExpression();
                ArrayList<RolapStar.Measure> distinctMeasuresList = new ArrayList<RolapStar.Measure>();
                int i = 0;
                while (i < this.measuresList.size()) {
                    RolapStar.Measure measure = this.measuresList.get(i);
                    if (measure.getAggregator().isDistinct() && measure.getExpression().getGenericExpression().equals(expr)) {
                        this.measuresList.remove(i);
                        distinctMeasuresList.add(distinctMeasure);
                        continue;
                    }
                    ++i;
                }
                AggregationManager.loadAggregation(BatchLoader.this.cacheMgr, this.cellRequestCount, distinctMeasuresList, this.columns, this.batchKey, predicates, groupingSetsCollector, segmentFutures);
            }
        }

        private StarColumnPredicate[] initPredicates() {
            StarColumnPredicate[] predicates = new StarColumnPredicate[this.columns.length];
            for (int j = 0; j < this.columns.length; ++j) {
                AbstractColumnPredicate predicate;
                Set<StarColumnPredicate> valueSet = this.valueSets[j];
                if (valueSet == null) {
                    predicate = LiteralStarPredicate.FALSE;
                } else {
                    ValueColumnPredicate[] values = valueSet.toArray(new ValueColumnPredicate[valueSet.size()]);
                    Arrays.sort(values, ValueColumnConstraintComparator.instance);
                    predicate = new ListColumnPredicate(this.columns[j], Arrays.asList((StarColumnPredicate[])values));
                }
                predicates[j] = predicate;
            }
            return predicates;
        }

        private void generateAggregateSql() {
            if (BatchLoader.this.cube == null || BatchLoader.this.cube.isVirtual()) {
                StringBuilder buf = new StringBuilder(64);
                buf.append("AggGen: Sorry, can not create SQL for virtual Cube \"").append(BatchLoader.this.cube == null ? null : BatchLoader.this.cube.getName()).append("\", operation not currently supported");
                BATCH_LOGGER.error((Object)buf.toString());
            } else {
                AggGen aggGen = new AggGen(BatchLoader.this.cube.getName(), BatchLoader.this.cube.getStar(), this.columns);
                if (aggGen.isReady()) {
                    System.out.println("createLost:" + Util.nl + aggGen.createLost());
                    System.out.println("insertIntoLost:" + Util.nl + aggGen.insertIntoLost());
                    System.out.println("createCollapsed:" + Util.nl + aggGen.createCollapsed());
                    System.out.println("insertIntoCollapsed:" + Util.nl + aggGen.insertIntoCollapsed());
                } else {
                    BATCH_LOGGER.error((Object)"AggGen failed");
                }
            }
        }

        final RolapStar.Measure getFirstDistinctMeasure(List<RolapStar.Measure> measuresList) {
            for (RolapStar.Measure measure : measuresList) {
                if (!measure.getAggregator().isDistinct()) continue;
                return measure;
            }
            return null;
        }

        private int getDistinctMeasureCount(List<RolapStar.Measure> measuresList) {
            int count = 0;
            for (RolapStar.Measure measure : measuresList) {
                if (!measure.getAggregator().isDistinct()) continue;
                ++count;
            }
            return count;
        }

        private List<RolapStar.Measure> getDistinctSqlMeasures(List<RolapStar.Measure> measuresList) {
            ArrayList<RolapStar.Measure> distinctSqlMeasureList = new ArrayList<RolapStar.Measure>();
            for (RolapStar.Measure measure : measuresList) {
                if (!measure.getAggregator().isDistinct() || !(measure.getExpression() instanceof MondrianDef.MeasureExpression)) continue;
                MondrianDef.MeasureExpression measureExpr = (MondrianDef.MeasureExpression)measure.getExpression();
                MondrianDef.SQL measureSql = measureExpr.expressions[0];
                if (!measureSql.cdata.toUpperCase().contains("SELECT")) continue;
                distinctSqlMeasureList.add(measure);
            }
            return distinctSqlMeasureList;
        }

        boolean canBatch(Batch other) {
            return this.hasOverlappingBitKeys(other) && this.constraintsMatch(other) && this.hasSameMeasureList(other) && !this.hasDistinctCountMeasure() && !other.hasDistinctCountMeasure() && this.haveSameStarAndAggregation(other) && this.haveSameClosureColumns(other);
        }

        private boolean constraintsMatch(Batch other) {
            if (this.areBothDistinctCountBatches(other)) {
                if (this.getConstrainedColumnsBitKey().equals(other.getConstrainedColumnsBitKey())) {
                    return this.hasSameCompoundPredicate(other) && this.haveSameValues(other);
                }
                return this.hasSameCompoundPredicate(other) || (other.batchKey.getCompoundPredicateList().isEmpty() || this.equalConstraint(this.batchKey.getCompoundPredicateList(), other.batchKey.getCompoundPredicateList())) && this.haveSameValues(other);
            }
            return this.haveSameValues(other);
        }

        private boolean equalConstraint(List<StarPredicate> predList1, List<StarPredicate> predList2) {
            if (predList1.size() != predList2.size()) {
                return false;
            }
            for (int i = 0; i < predList1.size(); ++i) {
                StarPredicate pred2;
                StarPredicate pred1 = predList1.get(i);
                if (pred1.equalConstraint(pred2 = predList2.get(i))) continue;
                return false;
            }
            return true;
        }

        private boolean areBothDistinctCountBatches(Batch other) {
            return this.hasDistinctCountMeasure() && !this.hasNormalMeasures() && other.hasDistinctCountMeasure() && !other.hasNormalMeasures();
        }

        private boolean hasNormalMeasures() {
            return this.getDistinctMeasureCount(this.measuresList) != this.measuresList.size();
        }

        private boolean hasSameMeasureList(Batch other) {
            return this.measuresList.size() == other.measuresList.size() && this.measuresList.containsAll(other.measuresList);
        }

        boolean hasOverlappingBitKeys(Batch other) {
            return this.getConstrainedColumnsBitKey().isSuperSetOf(other.getConstrainedColumnsBitKey());
        }

        boolean hasDistinctCountMeasure() {
            return this.getDistinctMeasureCount(this.measuresList) > 0;
        }

        boolean hasSameCompoundPredicate(Batch other) {
            StarPredicate starPredicate = this.compoundPredicate();
            StarPredicate otherStarPredicate = other.compoundPredicate();
            if (starPredicate == null && otherStarPredicate == null) {
                return true;
            }
            if (starPredicate != null && otherStarPredicate != null) {
                return starPredicate.equalConstraint(otherStarPredicate);
            }
            return false;
        }

        private StarPredicate compoundPredicate() {
            StarPredicate predicate = null;
            for (Set<StarColumnPredicate> valueSet : this.valueSets) {
                StarPredicate orPredicate = null;
                for (StarColumnPredicate starColumnPredicate : valueSet) {
                    if (orPredicate == null) {
                        orPredicate = starColumnPredicate;
                        continue;
                    }
                    orPredicate = orPredicate.or(starColumnPredicate);
                }
                predicate = predicate == null ? orPredicate : predicate.and(orPredicate);
            }
            for (StarPredicate starPredicate : this.batchKey.getCompoundPredicateList()) {
                if (predicate == null) {
                    predicate = starPredicate;
                    continue;
                }
                predicate = predicate.and(starPredicate);
            }
            return predicate;
        }

        boolean haveSameStarAndAggregation(Batch other) {
            boolean[] rollup = new boolean[]{false};
            boolean[] otherRollup = new boolean[]{false};
            boolean hasSameAggregation = this.getAgg(rollup) == other.getAgg(otherRollup);
            boolean hasSameRollupOption = rollup[0] == otherRollup[0];
            boolean hasSameStar = this.getStar().equals(other.getStar());
            return hasSameStar && hasSameAggregation && hasSameRollupOption;
        }

        boolean haveSameClosureColumns(Batch other) {
            BitKey cubeClosureColumnBitKey = ((BatchLoader)BatchLoader.this).cube.closureColumnBitKey;
            if (cubeClosureColumnBitKey == null) {
                return true;
            }
            BitKey closureColumns = this.batchKey.getConstrainedColumnsBitKey().and(cubeClosureColumnBitKey);
            BitKey otherClosureColumns = other.batchKey.getConstrainedColumnsBitKey().and(cubeClosureColumnBitKey);
            return closureColumns.equals(otherClosureColumns);
        }

        private AggStar getAgg(boolean[] rollup) {
            return AggregationManager.findAgg(this.getStar(), this.getConstrainedColumnsBitKey(), this.makeMeasureBitKey(), rollup);
        }

        private BitKey makeMeasureBitKey() {
            BitKey bitKey = this.getConstrainedColumnsBitKey().emptyCopy();
            for (RolapStar.Measure measure : this.measuresList) {
                bitKey.set(measure.getBitPosition());
            }
            return bitKey;
        }

        boolean haveSameValues(Batch other) {
            for (int j = 0; j < this.columns.length; ++j) {
                boolean isCommonColumn = false;
                for (int i = 0; i < other.columns.length; ++i) {
                    if (!this.areSameColumns(other.columns[i], this.columns[j])) continue;
                    if (this.hasSameValues(other.valueSets[i], this.valueSets[j])) {
                        isCommonColumn = true;
                        break;
                    }
                    return false;
                }
                if (isCommonColumn || this.hasAllValues(this.columns[j], this.valueSets[j])) continue;
                return false;
            }
            return true;
        }

        private boolean hasAllValues(RolapStar.Column column, Set<StarColumnPredicate> valueSet) {
            return column.getCardinality() == valueSet.size();
        }

        private boolean areSameColumns(RolapStar.Column otherColumn, RolapStar.Column thisColumn) {
            return otherColumn.equals(thisColumn);
        }

        private boolean hasSameValues(Set<StarColumnPredicate> otherValueSet, Set<StarColumnPredicate> thisValueSet) {
            return ((Object)otherValueSet).equals(thisValueSet);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LoadBatchResponse {
        final List<Future<Map<Segment, SegmentWithData>>> sqlSegmentMapFutures;
        final List<SegmentHeader> cacheSegments;
        final List<CellRequest> cellRequests;
        final List<RollupInfo> rollups;
        final Map<List, SegmentBuilder.SegmentConverter> converterMap;
        final Map<SegmentHeader, Future<SegmentBody>> futures;

        LoadBatchResponse(List<CellRequest> cellRequests, List<SegmentHeader> cacheSegments, List<RollupInfo> rollups, Map<List, SegmentBuilder.SegmentConverter> converterMap, List<Future<Map<Segment, SegmentWithData>>> sqlSegmentMapFutures, Map<SegmentHeader, Future<SegmentBody>> futures) {
            this.cellRequests = cellRequests;
            this.sqlSegmentMapFutures = sqlSegmentMapFutures;
            this.cacheSegments = cacheSegments;
            this.rollups = rollups;
            this.converterMap = converterMap;
            this.futures = futures;
        }

        public SegmentWithData convert(SegmentHeader header, SegmentBody body) {
            SegmentBuilder.SegmentConverter converter = this.converterMap.get(SegmentCacheIndexImpl.makeConverterKey(header));
            return converter.convert(header, body);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RollupInfo {
        final RolapStar.Column[] constrainedColumns;
        final BitKey constrainedColumnsBitKey;
        final RolapStar.Measure measure;
        final List<List<SegmentHeader>> candidateLists;

        RollupInfo(CellRequest request, List<List<SegmentHeader>> candidateLists) {
            this.candidateLists = candidateLists;
            this.constrainedColumns = request.getConstrainedColumns();
            this.constrainedColumnsBitKey = request.getConstrainedColumnsBitKey();
            this.measure = request.getMeasure();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CompositeBatch {
        final Batch detailedBatch;
        final List<Batch> summaryBatches = new ArrayList<Batch>();

        CompositeBatch(Batch detailedBatch) {
            this.detailedBatch = detailedBatch;
        }

        void add(Batch summaryBatch) {
            this.summaryBatches.add(summaryBatch);
        }

        void merge(CompositeBatch summaryBatch) {
            this.summaryBatches.add(summaryBatch.detailedBatch);
            this.summaryBatches.addAll(summaryBatch.summaryBatches);
        }

        public void load(List<Future<Map<Segment, SegmentWithData>>> segmentFutures) {
            GroupingSetsCollector batchCollector = new GroupingSetsCollector(true);
            this.detailedBatch.loadAggregation(batchCollector, segmentFutures);
            int cellRequestCount = 0;
            for (Batch batch : this.summaryBatches) {
                batch.loadAggregation(batchCollector, segmentFutures);
                cellRequestCount += batch.cellRequestCount;
            }
            this.getSegmentLoader().load(cellRequestCount, batchCollector.getGroupingSets(), this.detailedBatch.batchKey.getCompoundPredicateList(), segmentFutures);
        }

        SegmentLoader getSegmentLoader() {
            return new SegmentLoader(this.detailedBatch.getCacheMgr());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LoadBatchCommand
    implements SegmentCacheManager.Command<LoadBatchResponse> {
        private final Locus locus;
        private final SegmentCacheManager cacheMgr;
        private final Dialect dialect;
        private final RolapCube cube;
        private final List<CellRequest> cellRequests;
        private final Map<String, Object> mdc = new HashMap<String, Object>();

        public LoadBatchCommand(Locus locus, SegmentCacheManager cacheMgr, Dialect dialect, RolapCube cube, List<CellRequest> cellRequests) {
            this.locus = locus;
            this.cacheMgr = cacheMgr;
            this.dialect = dialect;
            this.cube = cube;
            this.cellRequests = cellRequests;
            if (MDC.getContext() != null) {
                this.mdc.putAll(MDC.getContext());
            }
        }

        @Override
        public LoadBatchResponse call() {
            if (MDC.getContext() != null) {
                Hashtable old = MDC.getContext();
                old.clear();
                old.putAll(this.mdc);
            }
            return new BatchLoader(this.locus, this.cacheMgr, this.dialect, this.cube).load(this.cellRequests);
        }

        @Override
        public Locus getLocus() {
            return this.locus;
        }
    }
}

