/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.olap.LevelType;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeMember;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.MemberColumnPredicate;
import mondrian.rolap.agg.MemberTuplePredicate;
import mondrian.rolap.agg.RangeColumnPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.spi.MemberFormatter;

public class RolapCubeLevel
extends RolapLevel {
    private final RolapLevel rolapLevel;
    private RolapStar.Column starKeyColumn = null;
    private RolapCubeLevel closedPeerCubeLevel;
    protected LevelReader levelReader;
    private final RolapCubeHierarchy cubeHierarchy;
    private final RolapCubeDimension cubeDimension;
    private final RolapCube cube;
    private final RolapCubeLevel parentCubeLevel;
    private RolapCubeLevel childCubeLevel;

    public RolapCubeLevel(RolapLevel level, RolapCubeHierarchy cubeHierarchy) {
        super(cubeHierarchy, level.getName(), level.getCaption(), level.isVisible(), level.getDescription(), level.getDepth(), level.getKeyExp(), level.getNameExp(), level.getCaptionExp(), level.getOrdinalExp(), level.getParentExp(), level.getNullParentValue(), null, level.getProperties(), level.getFlags(), level.getDatatype(), level.getInternalType(), level.getHideMemberCondition(), level.getLevelType(), "" + level.getApproxRowCount(), level.getAnnotationMap());
        this.rolapLevel = level;
        this.cubeHierarchy = cubeHierarchy;
        this.cubeDimension = (RolapCubeDimension)cubeHierarchy.getDimension();
        this.cube = this.cubeDimension.getCube();
        this.parentCubeLevel = (RolapCubeLevel)super.getParentLevel();
        if (this.parentCubeLevel != null) {
            this.parentCubeLevel.childCubeLevel = this;
        }
        MondrianDef.RelationOrJoin hierarchyRel = cubeHierarchy.getRelation();
        this.keyExp = this.convertExpression(level.getKeyExp(), hierarchyRel);
        this.nameExp = this.convertExpression(level.getNameExp(), hierarchyRel);
        this.captionExp = this.convertExpression(level.getCaptionExp(), hierarchyRel);
        this.ordinalExp = this.convertExpression(level.getOrdinalExp(), hierarchyRel);
        this.parentExp = this.convertExpression(level.getParentExp(), hierarchyRel);
        this.properties = this.convertProperties(level.getProperties(), hierarchyRel);
    }

    void init(MondrianDef.CubeDimension xmlDimension) {
        if (this.isAll()) {
            this.levelReader = new AllLevelReaderImpl();
        } else if (this.getLevelType() == LevelType.Null) {
            this.levelReader = new NullLevelReader();
        } else if (this.rolapLevel.xmlClosure != null) {
            RolapDimension dimension = (RolapDimension)this.rolapLevel.getClosedPeer().getHierarchy().getDimension();
            RolapCubeDimension cubeDimension = new RolapCubeDimension(this.getCube(), dimension, xmlDimension, this.getDimension().getName() + "$Closure", -1, this.getCube().hierarchyList, this.getDimension().isHighCardinality());
            if (!this.getCube().isVirtual()) {
                this.getCube().createUsage((RolapCubeHierarchy)cubeDimension.getHierarchies()[0], xmlDimension);
            }
            cubeDimension.init(xmlDimension);
            this.getCube().registerDimension(cubeDimension);
            this.closedPeerCubeLevel = (RolapCubeLevel)cubeDimension.getHierarchies()[0].getLevels()[1];
            if (!this.getCube().isVirtual()) {
                this.getCube().closureColumnBitKey.set(this.closedPeerCubeLevel.starKeyColumn.getBitPosition());
            }
            this.levelReader = new ParentChildLevelReaderImpl(this);
        } else {
            this.levelReader = new RegularLevelReader(this);
        }
    }

    private RolapProperty[] convertProperties(RolapProperty[] properties, MondrianDef.RelationOrJoin rel) {
        if (properties == null) {
            return null;
        }
        RolapProperty[] convertedProperties = new RolapProperty[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            RolapProperty old = properties[i];
            convertedProperties[i] = new RolapProperty(old.getName(), old.getType(), this.convertExpression(old.getExp(), rel), old.getFormatter(), old.getCaption(), old.dependsOnLevelValue(), old.isInternal(), old.getDescription());
        }
        return convertedProperties;
    }

    private MondrianDef.Expression convertExpression(MondrianDef.Expression exp, MondrianDef.RelationOrJoin rel) {
        if (this.getHierarchy().isUsingCubeFact()) {
            return exp;
        }
        if (exp == null || rel == null) {
            return null;
        }
        if (exp instanceof MondrianDef.Column) {
            MondrianDef.Column col = (MondrianDef.Column)exp;
            if (rel instanceof MondrianDef.Table) {
                return new MondrianDef.Column(((MondrianDef.Table)rel).getAlias(), col.getColumnName());
            }
            if (rel instanceof MondrianDef.Join || rel instanceof MondrianDef.Relation) {
                String alias = this.getHierarchy().lookupAlias(col.getTableAlias());
                return new MondrianDef.Column(alias, col.getColumnName());
            }
        } else if (exp instanceof MondrianDef.ExpressionView) {
            return exp;
        }
        throw new RuntimeException("conversion of Class " + exp.getClass() + " unsupported at this time");
    }

    public void setStarKeyColumn(RolapStar.Column column) {
        this.starKeyColumn = column;
    }

    public RolapStar.Column getStarKeyColumn() {
        return this.starKeyColumn;
    }

    LevelReader getLevelReader() {
        return this.levelReader;
    }

    public RolapStar.Column getBaseStarKeyColumn(RolapCube baseCube) {
        RolapStar.Column column = null;
        if (this.getCube().isVirtual() && baseCube != null) {
            RolapCubeLevel lvl = baseCube.findBaseCubeLevel(this);
            if (lvl != null) {
                column = lvl.getStarKeyColumn();
            }
        } else {
            column = this.getStarKeyColumn();
        }
        return column;
    }

    public final RolapCube getCube() {
        return this.cube;
    }

    public final RolapCubeDimension getDimension() {
        return this.cubeDimension;
    }

    public final RolapCubeHierarchy getHierarchy() {
        return this.cubeHierarchy;
    }

    public final RolapCubeLevel getChildLevel() {
        return this.childCubeLevel;
    }

    public final RolapCubeLevel getParentLevel() {
        return this.parentCubeLevel;
    }

    public String getCaption() {
        return this.rolapLevel.getCaption();
    }

    public void setCaption(String caption) {
        throw new UnsupportedOperationException();
    }

    public RolapLevel getRolapLevel() {
        return this.rolapLevel;
    }

    public boolean equals(RolapCubeLevel level) {
        if (this == level) {
            return true;
        }
        return super.equals(level) && this.getCube().equals(level.getCube());
    }

    boolean hasClosedPeer() {
        return this.closedPeerCubeLevel != null;
    }

    public RolapCubeLevel getClosedPeer() {
        return this.closedPeerCubeLevel;
    }

    public MemberFormatter getMemberFormatter() {
        return this.rolapLevel.getMemberFormatter();
    }

    static final class NullLevelReader
    implements LevelReader {
        NullLevelReader() {
        }

        public boolean constrainRequest(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
            return true;
        }

        public void constrainRegion(StarColumnPredicate predicate, RolapCube baseCube, RolapCacheRegion cacheRegion) {
        }
    }

    static final class AllLevelReaderImpl
    implements LevelReader {
        AllLevelReaderImpl() {
        }

        public boolean constrainRequest(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
            return false;
        }

        public void constrainRegion(StarColumnPredicate predicate, RolapCube baseCube, RolapCacheRegion cacheRegion) {
        }
    }

    static final class ParentChildLevelReaderImpl
    implements LevelReader {
        private final RegularLevelReader regularLevelReader;
        private final RolapCubeLevel closedPeerCubeLevel;
        private final RolapLevel closedPeerLevel;
        private final RolapMember wrappedAllMember;
        private final RolapCubeMember allMember;

        ParentChildLevelReaderImpl(RolapCubeLevel cubeLevel) {
            this.regularLevelReader = new RegularLevelReader(cubeLevel);
            this.closedPeerCubeLevel = cubeLevel.closedPeerCubeLevel;
            this.closedPeerLevel = cubeLevel.rolapLevel.getClosedPeer();
            this.wrappedAllMember = (RolapMember)this.closedPeerLevel.getHierarchy().getDefaultMember();
            this.allMember = this.closedPeerCubeLevel.getHierarchy().getDefaultMember();
            assert (this.allMember.isAll());
        }

        public boolean constrainRequest(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
            if (member.getDataMember() == null) {
                return this.regularLevelReader.constrainRequest(member, baseCube, request);
            }
            if (request.drillThrough) {
                return this.regularLevelReader.constrainRequest(member.getDataMember(), baseCube, request);
            }
            RolapMemberBase wrappedMember = new RolapMemberBase(this.wrappedAllMember, this.closedPeerLevel, member.getKey());
            member = new RolapCubeMember(this.allMember, wrappedMember, this.closedPeerCubeLevel);
            return this.closedPeerCubeLevel.getLevelReader().constrainRequest(member, baseCube, request);
        }

        public void constrainRegion(StarColumnPredicate predicate, RolapCube baseCube, RolapCacheRegion cacheRegion) {
            throw new UnsupportedOperationException();
        }
    }

    static final class RegularLevelReader
    implements LevelReader {
        private RolapCubeLevel cubeLevel;

        RegularLevelReader(RolapCubeLevel cubeLevel) {
            this.cubeLevel = cubeLevel;
        }

        public boolean constrainRequest(RolapCubeMember member, RolapCube baseCube, CellRequest request) {
            LevelReader levelReader;
            assert (member.getLevel() == this.cubeLevel);
            if (member.getKey() == null) {
                if (member == member.getHierarchy().getNullMember()) {
                    return true;
                }
                throw Util.newInternal("why is key null?");
            }
            RolapStar.Column column = this.cubeLevel.getBaseStarKeyColumn(baseCube);
            if (column == null) {
                return member != this.cubeLevel.hierarchy.getDefaultMember() || this.cubeLevel.hierarchy.hasAll();
            }
            ValueColumnPredicate predicate = member.isCalculated() && !member.isParentChildLeaf() ? null : new ValueColumnPredicate(column, member.getKey());
            request.addConstrainedColumn(column, predicate);
            if (request.extendedContext && this.cubeLevel.getNameExp() != null) {
                RolapStar.Column nameColumn = column.getNameColumn();
                assert (nameColumn != null);
                request.addConstrainedColumn(nameColumn, null);
            }
            if (member.isCalculated()) {
                return false;
            }
            if (this.cubeLevel.isUnique()) {
                return false;
            }
            RolapCubeMember parent = member.getParentMember();
            while (true) {
                if (parent == null) {
                    return false;
                }
                RolapCubeLevel level = parent.getLevel();
                levelReader = level.levelReader;
                if (levelReader != this) break;
                parent = parent.getParentMember();
            }
            return levelReader.constrainRequest(parent, baseCube, request);
        }

        public void constrainRegion(StarColumnPredicate predicate, RolapCube baseCube, RolapCacheRegion cacheRegion) {
            RolapStar.Column column = this.cubeLevel.getBaseStarKeyColumn(baseCube);
            if (column == null) {
                return;
            }
            if (predicate instanceof MemberColumnPredicate) {
                MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)predicate;
                RolapMember member = memberColumnPredicate.getMember();
                assert (member.getLevel() == this.cubeLevel);
                assert (!member.isCalculated());
                assert (memberColumnPredicate.getMember().getKey() != null);
                assert (memberColumnPredicate.getMember().getKey() != RolapUtil.sqlNullValue);
                assert (!member.isNull());
                cacheRegion.addPredicate(column, predicate);
                return;
            }
            if (predicate instanceof RangeColumnPredicate) {
                RolapMember upperMember;
                RolapMember lowerMember;
                RangeColumnPredicate rangeColumnPredicate = (RangeColumnPredicate)predicate;
                ValueColumnPredicate lowerBound = rangeColumnPredicate.getLowerBound();
                if (lowerBound == null) {
                    lowerMember = null;
                } else if (lowerBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)lowerBound;
                    lowerMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                ValueColumnPredicate upperBound = rangeColumnPredicate.getUpperBound();
                if (upperBound == null) {
                    upperMember = null;
                } else if (upperBound instanceof MemberColumnPredicate) {
                    MemberColumnPredicate memberColumnPredicate = (MemberColumnPredicate)upperBound;
                    upperMember = memberColumnPredicate.getMember();
                } else {
                    throw new UnsupportedOperationException();
                }
                MemberTuplePredicate predicate2 = new MemberTuplePredicate(baseCube, lowerMember, !rangeColumnPredicate.getLowerInclusive(), upperMember, !rangeColumnPredicate.getUpperInclusive());
                cacheRegion.addPredicate(predicate2);
                return;
            }
            throw new UnsupportedOperationException();
        }
    }

    static interface LevelReader {
        public boolean constrainRequest(RolapCubeMember var1, RolapCube var2, CellRequest var3);

        public void constrainRegion(StarColumnPredicate var1, RolapCube var2, RolapCacheRegion var3);
    }
}

