/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import mondrian.mdx.HierarchyExpr;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Exp;
import mondrian.olap.Id;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.rolap.DelegatingRolapMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberInCube;

public class RolapCubeMember
extends DelegatingRolapMember
implements RolapMemberInCube {
    protected final RolapCubeLevel cubeLevel;
    protected final RolapCubeMember parentCubeMember;

    public RolapCubeMember(RolapCubeMember parent, RolapMember member, RolapCubeLevel cubeLevel) {
        super(member);
        this.parentCubeMember = parent;
        this.cubeLevel = cubeLevel;
        assert (!member.isAll() || this.getClass() != RolapCubeMember.class);
    }

    public String getUniqueName() {
        return this.cubeLevel.getHierarchy().convertMemberName(this.member.getUniqueName());
    }

    public final RolapMember getRolapMember() {
        return this.member;
    }

    public final RolapCube getCube() {
        return this.cubeLevel.getCube();
    }

    public final RolapCubeMember getDataMember() {
        RolapMember member = (RolapMember)super.getDataMember();
        if (member == null) {
            return null;
        }
        return new RolapCubeMember(this.parentCubeMember, member, this.cubeLevel);
    }

    public int compareTo(Object o) {
        RolapCubeMember other = null;
        other = o instanceof VisualTotalsFunDef.VisualTotalMember ? (RolapCubeMember)((VisualTotalsFunDef.VisualTotalMember)o).getMember() : (RolapCubeMember)o;
        return this.member.compareTo(other.member);
    }

    public String toString() {
        return this.getUniqueName();
    }

    public int hashCode() {
        return this.member.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RolapCubeMember) {
            return this.equals((RolapCubeMember)o);
        }
        if (o instanceof Member) {
            return this.getUniqueName().equals(((Member)o).getUniqueName());
        }
        return false;
    }

    public boolean equals(OlapElement o) {
        return o.getClass() == RolapCubeMember.class && this.equals((RolapCubeMember)o);
    }

    private boolean equals(RolapCubeMember that) {
        assert (that != null);
        return this.cubeLevel == that.cubeLevel && this.member.equals(that.member);
    }

    public final RolapCubeHierarchy getHierarchy() {
        return this.cubeLevel.getHierarchy();
    }

    public final RolapCubeDimension getDimension() {
        return this.cubeLevel.getDimension();
    }

    public final RolapCubeLevel getLevel() {
        return this.cubeLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperty(String name, Object value) {
        RolapCubeMember rolapCubeMember = this;
        synchronized (rolapCubeMember) {
            super.setProperty(name, value);
        }
    }

    public Object getPropertyValue(String propertyName, boolean matchCase) {
        Property property = Property.lookup(propertyName, matchCase);
        if (property != null) {
            switch (property.ordinal) {
                case 13: {
                    return this.getDimension().getUniqueName();
                }
                case 14: {
                    return this.getHierarchy().getUniqueName();
                }
                case 15: {
                    return this.getLevel().getUniqueName();
                }
                case 19: {
                    return this.getUniqueName();
                }
                case 18: {
                    return this.getName();
                }
                case 22: {
                    return this.getCaption();
                }
                case 25: {
                    return this.parentCubeMember == null ? null : this.parentCubeMember.getUniqueName();
                }
                case 45: 
                case 46: {
                    return this == this.getHierarchy().getAllMember() ? Integer.valueOf(0) : this.getKey();
                }
            }
        }
        return this.member.getPropertyValue(propertyName, matchCase);
    }

    public final RolapCubeMember getParentMember() {
        return this.parentCubeMember;
    }

    public Exp getExpression() {
        Exp exp = this.member.getExpression();
        if (exp instanceof ResolvedFunCall) {
            ResolvedFunCall fcall = (ResolvedFunCall)exp;
            for (int i = 0; i < fcall.getArgCount(); ++i) {
                HierarchyExpr expr;
                if (!(fcall.getArg(i) instanceof HierarchyExpr) || !(expr = (HierarchyExpr)fcall.getArg(i)).getHierarchy().equals(this.member.getHierarchy())) continue;
                fcall.getArgs()[i] = new HierarchyExpr(this.getHierarchy());
            }
        }
        return exp;
    }

    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment childName, MatchType matchType) {
        return schemaReader.lookupMemberChildByName(this, childName, matchType);
    }
}

