/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.AbstractCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NameResolver;
import mondrian.olap.NamedSet;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.OlapElement;
import mondrian.olap.Parameter;
import mondrian.olap.ParameterImpl;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.type.StringType;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberCacheHelper;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaParameter;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.olap4j.mdx.IdentifierSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapSchemaReader
implements SchemaReader,
RolapNativeSet.SchemaReaderWithMemberReaderAvailable,
NameResolver.Namespace {
    protected final Role role;
    private final Map<Hierarchy, MemberReader> hierarchyReaders = new HashMap<Hierarchy, MemberReader>();
    protected final RolapSchema schema;
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    private static final Logger LOGGER = Logger.getLogger(RolapSchemaReader.class);

    RolapSchemaReader(Role role, RolapSchema schema) {
        assert (role != null) : "precondition: role != null";
        assert (schema != null);
        this.role = role;
        this.schema = schema;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    @Override
    public List<Member> getHierarchyRootMembers(Hierarchy hierarchy) {
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        Level[] levels = hierarchy.getLevels();
        Level firstLevel = hierarchyAccess == null ? levels[0] : levels[hierarchyAccess.getTopLevelDepth()];
        return this.getLevelMembers(firstLevel, true);
    }

    @Override
    public synchronized MemberReader getMemberReader(Hierarchy hierarchy) {
        MemberReader memberReader = this.hierarchyReaders.get(hierarchy);
        if (memberReader == null) {
            memberReader = ((RolapHierarchy)hierarchy).createMemberReader(this.role);
            this.hierarchyReaders.put(hierarchy, memberReader);
        }
        return memberReader;
    }

    @Override
    public Member substitute(Member member) {
        MemberReader memberReader = this.getMemberReader(member.getHierarchy());
        return memberReader.substitute((RolapMember)member);
    }

    @Override
    public void getMemberRange(Level level, Member startMember, Member endMember, List<Member> list) {
        this.getMemberReader(level.getHierarchy()).getMemberRange((RolapLevel)level, (RolapMember)startMember, (RolapMember)endMember, Util.cast(list));
    }

    @Override
    public int compareMembersHierarchically(Member m1, Member m2) {
        RolapMember member1 = (RolapMember)m1;
        RolapMember member2 = (RolapMember)m2;
        RolapHierarchy hierarchy = member1.getHierarchy();
        Util.assertPrecondition(hierarchy == m2.getHierarchy());
        return this.getMemberReader(hierarchy).compare(member1, member2, true);
    }

    @Override
    public Member getMemberParent(Member member) {
        return this.getMemberReader(member.getHierarchy()).getMemberParent((RolapMember)member);
    }

    @Override
    public int getMemberDepth(Member member) {
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(member.getHierarchy());
        if (hierarchyAccess != null) {
            int memberDepth = member.getLevel().getDepth();
            int topLevelDepth = hierarchyAccess.getTopLevelDepth();
            return memberDepth - topLevelDepth;
        }
        if (((RolapLevel)member.getLevel()).isParentChild()) {
            int depth = 0;
            for (Member m = member.getParentMember(); m != null; m = m.getParentMember()) {
                ++depth;
            }
            return depth;
        }
        return member.getLevel().getDepth();
    }

    @Override
    public List<Member> getMemberChildren(Member member) {
        return this.getMemberChildren(member, null);
    }

    @Override
    public List<Member> getMemberChildren(Member member, Evaluator context) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        List<RolapMember> memberList = this.internalGetMemberChildren(member, constraint);
        return Util.cast(memberList);
    }

    private List<RolapMember> internalGetMemberChildren(Member member, MemberChildrenConstraint constraint) {
        ArrayList<RolapMember> children = new ArrayList<RolapMember>();
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        memberReader.getMemberChildren((RolapMember)member, children, constraint);
        return children;
    }

    @Override
    public void getParentChildContributingChildren(Member dataMember, Hierarchy hierarchy, List<Member> list) {
        List<RolapMember> rolapMemberList = Util.cast(list);
        list.add(dataMember);
        ((RolapHierarchy)hierarchy).getMemberReader().getMemberChildren((RolapMember)dataMember, rolapMemberList);
    }

    @Override
    public int getChildrenCountFromCache(Member member) {
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        if (memberReader instanceof RolapCubeHierarchy.RolapCubeHierarchyMemberReader) {
            List<RolapMember> list = ((RolapCubeHierarchy.RolapCubeHierarchyMemberReader)memberReader).getRolapCubeMemberCacheHelper().getChildrenFromCache((RolapMember)member, null);
            if (list == null) {
                return -1;
            }
            return list.size();
        }
        if (memberReader instanceof SmartMemberReader) {
            List<RolapMember> list = ((SmartMemberReader)memberReader).getMemberCache().getChildrenFromCache((RolapMember)member, null);
            if (list == null) {
                return -1;
            }
            return list.size();
        }
        if (!(memberReader instanceof MemberCache)) {
            return -1;
        }
        List<RolapMember> list = ((MemberCache)((Object)memberReader)).getChildrenFromCache((RolapMember)member, null);
        if (list == null) {
            return -1;
        }
        return list.size();
    }

    private int getLevelCardinalityFromCache(Level level) {
        Hierarchy hierarchy = level.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        if (memberReader instanceof RolapCubeHierarchy.RolapCubeHierarchyMemberReader) {
            MemberCacheHelper cache = ((RolapCubeHierarchy.RolapCubeHierarchyMemberReader)memberReader).getRolapCubeMemberCacheHelper();
            if (cache == null) {
                return Integer.MIN_VALUE;
            }
            List<RolapMember> list = cache.getLevelMembersFromCache((RolapLevel)level, null);
            if (list == null) {
                return Integer.MIN_VALUE;
            }
            return list.size();
        }
        if (memberReader instanceof SmartMemberReader) {
            List<RolapMember> list = ((SmartMemberReader)memberReader).getMemberCache().getLevelMembersFromCache((RolapLevel)level, null);
            if (list == null) {
                return Integer.MIN_VALUE;
            }
            return list.size();
        }
        if (memberReader instanceof MemberCache) {
            List<RolapMember> list = ((MemberCache)((Object)memberReader)).getLevelMembersFromCache((RolapLevel)level, null);
            if (list == null) {
                return Integer.MIN_VALUE;
            }
            return list.size();
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int getLevelCardinality(Level level, boolean approximate, boolean materialize) {
        if (!this.role.canAccess(level)) {
            return 1;
        }
        int rowCount = Integer.MIN_VALUE;
        if (approximate) {
            rowCount = level.getApproxRowCount();
        }
        if (rowCount == Integer.MIN_VALUE) {
            rowCount = this.getLevelCardinalityFromCache(level);
        }
        if (rowCount == Integer.MIN_VALUE && materialize) {
            MemberReader memberReader = this.getMemberReader(level.getHierarchy());
            rowCount = memberReader.getLevelMemberCount((RolapLevel)level);
            ((RolapLevel)level).setApproxRowCount(rowCount);
        }
        return rowCount;
    }

    @Override
    public List<Member> getMemberChildren(List<Member> members) {
        return this.getMemberChildren(members, null);
    }

    @Override
    public List<Member> getMemberChildren(List<Member> members, Evaluator context) {
        if (members.size() == 0) {
            return Collections.emptyList();
        }
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(context);
        Hierarchy hierarchy = members.get(0).getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        List<RolapMember> rolapMemberList = Util.cast(members);
        ArrayList<RolapMember> children = new ArrayList<RolapMember>();
        memberReader.getMemberChildren(rolapMemberList, children, constraint);
        return Util.cast(children);
    }

    @Override
    public void getMemberAncestors(Member member, List<Member> ancestorList) {
        Member parentMember = this.getMemberParent(member);
        while (parentMember != null) {
            ancestorList.add(parentMember);
            parentMember = this.getMemberParent(parentMember);
        }
    }

    @Override
    public Cube getCube() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaReader withoutAccessControl() {
        assert (this.getClass() == RolapSchemaReader.class) : "Subclass " + this.getClass() + " must override";
        if (this.role == this.schema.getDefaultRole()) {
            return this;
        }
        return new RolapSchemaReader(this.schema.getDefaultRole(), this.schema);
    }

    @Override
    public OlapElement getElementChild(OlapElement parent, Id.Segment name) {
        return this.getElementChild(parent, name, MatchType.EXACT);
    }

    @Override
    public OlapElement getElementChild(OlapElement parent, Id.Segment name, MatchType matchType) {
        return parent.lookupChild(this, name, matchType);
    }

    @Override
    public final Member getMemberByUniqueName(List<Id.Segment> uniqueNameParts, boolean failIfNotFound) {
        return this.getMemberByUniqueName(uniqueNameParts, failIfNotFound, MatchType.EXACT);
    }

    @Override
    public Member getMemberByUniqueName(List<Id.Segment> uniqueNameParts, boolean failIfNotFound, MatchType matchType) {
        return null;
    }

    @Override
    public OlapElement lookupCompound(OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category) {
        return this.lookupCompound(parent, names, failIfNotFound, category, MatchType.EXACT);
    }

    @Override
    public final OlapElement lookupCompound(OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category, MatchType matchType) {
        if (MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return new NameResolver().resolve(parent, Util.toOlap4j(names), failIfNotFound, category, matchType, this.getNamespaces());
        }
        return this.lookupCompoundInternal(parent, names, failIfNotFound, category, matchType);
    }

    public final OlapElement lookupCompoundInternal(OlapElement parent, List<Id.Segment> names, boolean failIfNotFound, int category, MatchType matchType) {
        return Util.lookupCompound(this, parent, names, failIfNotFound, category, matchType);
    }

    @Override
    public List<NameResolver.Namespace> getNamespaces() {
        return Collections.singletonList(this);
    }

    @Override
    public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment) {
        return this.lookupChild(parent, segment, MatchType.EXACT);
    }

    @Override
    public OlapElement lookupChild(OlapElement parent, IdentifierSegment segment, MatchType matchType) {
        OlapElement element = this.getElementChild(parent, Util.convert(segment), matchType);
        if (element != null) {
            return element;
        }
        if (parent instanceof Cube) {
            element = this.schema.getNamedSet(segment);
        }
        return element;
    }

    @Override
    public Member lookupMemberChildByName(Member parent, Id.Segment childName, MatchType matchType) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("looking for child \"" + childName + "\" of " + parent));
        }
        assert (!(parent instanceof RolapHierarchy.LimitedRollupMember));
        try {
            MemberChildrenConstraint constraint = childName instanceof Id.NameSegment && matchType.isExact() ? this.sqlConstraintFactory.getChildByNameConstraint((RolapMember)parent, (Id.NameSegment)childName) : this.sqlConstraintFactory.getMemberChildrenConstraint(null);
            List<RolapMember> children = this.internalGetMemberChildren(parent, constraint);
            if (children.size() > 0) {
                return RolapUtil.findBestMemberMatch(children, (RolapMember)parent, children.get(0).getLevel(), childName, matchType, true);
            }
        }
        catch (NumberFormatException e) {
            LOGGER.debug((Object)("NumberFormatException in lookupMemberChildByName for parent = \"" + parent + "\", childName=\"" + childName + "\", exception: " + e.getMessage()));
        }
        return null;
    }

    @Override
    public Member getCalculatedMember(List<Id.Segment> nameParts) {
        return null;
    }

    @Override
    public NamedSet getNamedSet(List<Id.Segment> nameParts) {
        if (nameParts.size() != 1) {
            return null;
        }
        if (!(nameParts.get(0) instanceof Id.NameSegment)) {
            return null;
        }
        String name = ((Id.NameSegment)nameParts.get((int)0)).name;
        return this.schema.getNamedSet(name);
    }

    @Override
    public Member getLeadMember(Member member, int n) {
        MemberReader memberReader = this.getMemberReader(member.getHierarchy());
        return memberReader.getLeadMember((RolapMember)member, n);
    }

    @Override
    public List<Member> getLevelMembers(Level level, boolean includeCalculated) {
        List<Member> members = this.getLevelMembers(level, null);
        if (!includeCalculated) {
            members = SqlConstraintUtils.removeCalculatedMembers(members);
        }
        return members;
    }

    @Override
    public List<Member> getLevelMembers(Level level, Evaluator context) {
        TupleConstraint constraint = this.sqlConstraintFactory.getLevelMembersConstraint(context, new Level[]{level});
        MemberReader memberReader = this.getMemberReader(level.getHierarchy());
        List<RolapMember> membersInLevel = memberReader.getMembersInLevel((RolapLevel)level, constraint);
        return Util.cast(membersInLevel);
    }

    @Override
    public List<Dimension> getCubeDimensions(Cube cube) {
        assert (cube != null);
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        block3: for (Dimension dimension : cube.getDimensions()) {
            switch (this.role.getAccess(dimension)) {
                case NONE: {
                    continue block3;
                }
                default: {
                    dimensions.add(dimension);
                }
            }
        }
        return dimensions;
    }

    @Override
    public List<Hierarchy> getDimensionHierarchies(Dimension dimension) {
        assert (dimension != null);
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        block3: for (Hierarchy hierarchy : dimension.getHierarchies()) {
            switch (this.role.getAccess(hierarchy)) {
                case NONE: {
                    continue block3;
                }
                default: {
                    hierarchies.add(hierarchy);
                }
            }
        }
        return hierarchies;
    }

    @Override
    public List<Level> getHierarchyLevels(Hierarchy hierarchy) {
        assert (hierarchy != null);
        Role.HierarchyAccess hierarchyAccess = this.role.getAccessDetails(hierarchy);
        Level[] levels = hierarchy.getLevels();
        if (hierarchyAccess == null) {
            return Arrays.asList(levels);
        }
        Level topLevel = levels[hierarchyAccess.getTopLevelDepth()];
        Level bottomLevel = levels[hierarchyAccess.getBottomLevelDepth()];
        List<Level> restrictedLevels = Arrays.asList(levels).subList(topLevel.getDepth(), bottomLevel.getDepth() + 1);
        assert (restrictedLevels.size() >= 1) : "postcondition";
        return restrictedLevels;
    }

    @Override
    public Member getHierarchyDefaultMember(Hierarchy hierarchy) {
        assert (hierarchy != null);
        if (this.role.getAccess(hierarchy) == Access.NONE) {
            return hierarchy.getDefaultMember();
        }
        return this.getMemberReader(hierarchy).getDefaultMember();
    }

    @Override
    public boolean isDrillable(Member member) {
        RolapLevel level = (RolapLevel)member.getLevel();
        if (level.getParentExp() != null) {
            return this.getMemberChildren(member).size() > 0;
        }
        Level childLevel = level.getChildLevel();
        return childLevel != null && this.role.getAccess(childLevel) != Access.NONE;
    }

    @Override
    public boolean isVisible(Member member) {
        return !member.isHidden() && this.role.canAccess(member);
    }

    @Override
    public Cube[] getCubes() {
        List<RolapCube> cubes = this.schema.getCubeList();
        ArrayList<RolapCube> visibleCubes = new ArrayList<RolapCube>(cubes.size());
        for (RolapCube cube : cubes) {
            if (!this.role.canAccess(cube)) continue;
            visibleCubes.add(cube);
        }
        return visibleCubes.toArray(new Cube[visibleCubes.size()]);
    }

    @Override
    public List<Member> getCalculatedMembers(Hierarchy hierarchy) {
        return Collections.emptyList();
    }

    @Override
    public List<Member> getCalculatedMembers(Level level) {
        return Collections.emptyList();
    }

    @Override
    public List<Member> getCalculatedMembers() {
        return Collections.emptyList();
    }

    @Override
    public NativeEvaluator getNativeSetEvaluator(FunDef fun, Exp[] args, Evaluator evaluator, Calc calc) {
        RolapEvaluator revaluator = (RolapEvaluator)AbstractCalc.simplifyEvaluator(calc, evaluator);
        if (evaluator.nativeEnabled()) {
            return this.schema.getNativeRegistry().createEvaluator(revaluator, fun, args);
        }
        return null;
    }

    @Override
    public Parameter getParameter(String name) {
        for (RolapSchemaParameter parameter : this.schema.parameterList) {
            if (!Util.equalName(parameter.getName(), name)) continue;
            return parameter;
        }
        List propertyList = MondrianProperties.instance().getPropertyList();
        for (Property property : propertyList) {
            if (!property.getPath().equals(name)) continue;
            return new SystemPropertyParameter(name, false);
        }
        if (System.getProperty(name) != null) {
            return new SystemPropertyParameter(name, true);
        }
        return null;
    }

    @Override
    public DataSource getDataSource() {
        return this.schema.getInternalConnection().getDataSource();
    }

    @Override
    public RolapSchema getSchema() {
        return this.schema;
    }

    @Override
    public SchemaReader withLocus() {
        return RolapUtil.locusSchemaReader(this.schema.getInternalConnection(), this);
    }

    @Override
    public Map<? extends Member, Access> getMemberChildrenWithDetails(Member member, Evaluator evaluator) {
        MemberChildrenConstraint constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(evaluator);
        Hierarchy hierarchy = member.getHierarchy();
        MemberReader memberReader = this.getMemberReader(hierarchy);
        ArrayList<RolapMember> memberChildren = new ArrayList<RolapMember>();
        return memberReader.getMemberChildren((RolapMember)member, memberChildren, constraint);
    }

    private static class SystemPropertyParameter
    extends ParameterImpl {
        private final boolean system;
        private final Property propertyDefinition;

        public SystemPropertyParameter(String name, boolean system) {
            super(name, Literal.nullValue, "System property '" + name + "'", new StringType());
            this.system = system;
            this.propertyDefinition = system ? null : MondrianProperties.instance().getPropertyDefinition(name);
        }

        public Parameter.Scope getScope() {
            return Parameter.Scope.System;
        }

        public boolean isModifiable() {
            return false;
        }

        public Calc compile(ExpCompiler compiler) {
            return new GenericCalc(new DummyExp(this.getType())){

                public Calc[] getCalcs() {
                    return new Calc[0];
                }

                public Object evaluate(Evaluator evaluator) {
                    if (SystemPropertyParameter.this.system) {
                        String name = SystemPropertyParameter.this.getName();
                        return System.getProperty(name);
                    }
                    return SystemPropertyParameter.this.propertyDefinition.stringValue();
                }
            };
        }
    }
}

