/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.List;
import java.util.SortedSet;
import mondrian.rolap.CellKey;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.DenseObjectSegmentBody;
import mondrian.rolap.agg.DenseSegmentDataset;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;
import mondrian.spi.SegmentBody;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DenseObjectSegmentDataset
extends DenseSegmentDataset {
    final Object[] values;

    DenseObjectSegmentDataset(SegmentAxis[] axes, int size) {
        this(axes, new Object[size]);
    }

    DenseObjectSegmentDataset(SegmentAxis[] axes, Object[] values) {
        super(axes);
        this.values = values;
    }

    @Override
    public Object getObject(CellKey key) {
        int offset = key.getOffset(this.axisMultipliers);
        return this.values[offset];
    }

    @Override
    public boolean isNull(CellKey pos) {
        return this.getObject(pos) != null;
    }

    @Override
    public boolean exists(CellKey pos) {
        return this.getObject(pos) != null;
    }

    @Override
    public void populateFrom(int[] pos, SegmentDataset data, CellKey key) {
        this.values[this.getOffset((int[])pos)] = data.getObject(key);
    }

    @Override
    public void populateFrom(int[] pos, SegmentLoader.RowList rowList, int column) {
        int offset = this.getOffset(pos);
        this.values[offset] = rowList.getObject(column);
    }

    @Override
    public SqlStatement.Type getType() {
        return SqlStatement.Type.OBJECT;
    }

    public void put(CellKey key, Object value) {
        int offset = key.getOffset(this.axisMultipliers);
        this.values[offset] = value;
    }

    @Override
    protected Object getObject(int i) {
        return this.values[i];
    }

    @Override
    protected int getSize() {
        return this.values.length;
    }

    @Override
    public SegmentBody createSegmentBody(List<Pair<SortedSet<Comparable>, Boolean>> axes) {
        return new DenseObjectSegmentBody(this.values, axes);
    }
}

