/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.agg.DenseDoubleSegmentDataset;
import mondrian.rolap.agg.DenseIntSegmentDataset;
import mondrian.rolap.agg.DenseObjectSegmentDataset;
import mondrian.rolap.agg.SegmentAxis;
import mondrian.rolap.agg.SegmentBuilder;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SparseSegmentDataset;
import mondrian.spi.SegmentHeader;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segment {
    private static int nextId = 0;
    final int id = nextId++;
    private String desc;
    protected final RolapStar.Column[] columns;
    public final RolapStar.Measure measure;
    public final StarColumnPredicate[] predicates;
    protected final RolapStar star;
    protected final BitKey constrainedColumnsBitKey;
    protected final List<ExcludedRegion> excludedRegions;
    private final int aggregationKeyHashCode;
    protected final List<StarPredicate> compoundPredicateList;
    private final SegmentHeader segmentHeader;
    private static final Logger LOGGER = Logger.getLogger(Segment.class);

    public Segment(RolapStar star, BitKey constrainedColumnsBitKey, RolapStar.Column[] columns, RolapStar.Measure measure, StarColumnPredicate[] predicates, List<ExcludedRegion> excludedRegions, final List<StarPredicate> compoundPredicateList) {
        this.star = star;
        this.constrainedColumnsBitKey = constrainedColumnsBitKey;
        this.columns = columns;
        this.measure = measure;
        this.predicates = predicates;
        this.excludedRegions = excludedRegions;
        this.compoundPredicateList = compoundPredicateList;
        AbstractList<BitKey> compoundPredicateBitKeys = compoundPredicateList == null ? null : new AbstractList<BitKey>(){

            @Override
            public BitKey get(int index) {
                return ((StarPredicate)compoundPredicateList.get(index)).getConstrainedColumnBitKey();
            }

            @Override
            public int size() {
                return compoundPredicateList.size();
            }
        };
        this.aggregationKeyHashCode = AggregationKey.computeHashCode(constrainedColumnsBitKey, star, (Collection<BitKey>)compoundPredicateBitKeys);
        this.segmentHeader = SegmentBuilder.toHeader(this);
    }

    public RolapStar.Column[] getColumns() {
        return this.columns;
    }

    public RolapStar getStar() {
        return this.star;
    }

    public List<StarPredicate> getCompoundPredicateList() {
        return this.compoundPredicateList;
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.constrainedColumnsBitKey;
    }

    private void describe(StringBuilder buf, boolean values) {
        String sep = Util.nl + "    ";
        buf.append(this.printSegmentHeaderInfo(sep));
        for (int i = 0; i < this.columns.length; ++i) {
            buf.append(sep);
            buf.append(this.columns[i].getExpression().getGenericExpression());
            this.describeAxes(buf, i, values);
        }
        if (!this.excludedRegions.isEmpty()) {
            buf.append(sep);
            buf.append("excluded={");
            int k = 0;
            for (ExcludedRegion excludedRegion : this.excludedRegions) {
                if (k++ > 0) {
                    buf.append(", ");
                }
                excludedRegion.describe(buf);
            }
            buf.append('}');
        }
        buf.append('}');
    }

    protected void describeAxes(StringBuilder buf, int i, boolean values) {
        this.predicates[i].describe(buf);
    }

    private String printSegmentHeaderInfo(String sep) {
        StringBuilder buf = new StringBuilder();
        buf.append("Segment #");
        buf.append(this.id);
        buf.append(" {");
        buf.append(sep);
        buf.append("measure=");
        buf.append(this.measure.getExpression() == null ? this.measure.getAggregator().getExpression("*") : this.measure.getAggregator().getExpression(this.measure.getExpression().getGenericExpression()));
        return buf.toString();
    }

    public String toString() {
        if (this.desc == null) {
            StringBuilder buf = new StringBuilder(64);
            this.describe(buf, false);
            this.desc = buf.toString();
        }
        return this.desc;
    }

    protected final boolean isExcluded(Object[] keys) {
        int n = this.excludedRegions.size();
        for (int i = 0; i < n; ++i) {
            ExcludedRegion excludedRegion = this.excludedRegions.get(i);
            if (!excludedRegion.wouldContain(keys)) continue;
            return true;
        }
        return false;
    }

    public void print(PrintWriter pw) {
        StringBuilder buf = new StringBuilder();
        this.describe(buf, true);
        pw.print(buf.toString());
        pw.println();
    }

    public List<ExcludedRegion> getExcludedRegions() {
        return this.excludedRegions;
    }

    SegmentDataset createDataset(SegmentAxis[] axes, boolean sparse, SqlStatement.Type type, int size) {
        if (sparse) {
            return new SparseSegmentDataset();
        }
        switch (type) {
            case OBJECT: 
            case LONG: 
            case STRING: {
                return new DenseObjectSegmentDataset(axes, size);
            }
            case INT: {
                return new DenseIntSegmentDataset(axes, size);
            }
            case DOUBLE: {
                return new DenseDoubleSegmentDataset(axes, size);
            }
        }
        throw Util.unexpected(type);
    }

    public boolean matches(AggregationKey aggregationKey, RolapStar.Measure measure) {
        return this.aggregationKeyHashCode == aggregationKey.hashCode() && this.measure == measure && this.matchesInternal(aggregationKey);
    }

    private boolean matchesInternal(AggregationKey aggKey) {
        return this.constrainedColumnsBitKey.equals(aggKey.getConstrainedColumnsBitKey()) && this.star.equals(aggKey.getStar()) && AggregationKey.equal(this.compoundPredicateList, aggKey.compoundPredicateList);
    }

    public SegmentHeader getHeader() {
        return this.segmentHeader;
    }

    public static interface ExcludedRegion {
        public boolean wouldContain(Object[] var1);

        public int getArity();

        public void describe(StringBuilder var1);

        public int getCellCount();
    }
}

