/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.cache;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import mondrian.spi.SegmentBody;
import mondrian.spi.SegmentCache;
import mondrian.spi.SegmentHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemorySegmentCache
implements SegmentCache {
    private final Map<SegmentHeader, SoftReference<SegmentBody>> map = new ConcurrentHashMap<SegmentHeader, SoftReference<SegmentBody>>();
    private final List<SegmentCache.SegmentCacheListener> listeners = new CopyOnWriteArrayList<SegmentCache.SegmentCacheListener>();

    @Override
    public SegmentBody get(SegmentHeader header) {
        SoftReference<SegmentBody> ref = this.map.get(header);
        if (ref == null) {
            return null;
        }
        SegmentBody body = ref.get();
        if (body == null) {
            this.map.remove(header);
        }
        return body;
    }

    public boolean contains(SegmentHeader header) {
        SoftReference<SegmentBody> ref = this.map.get(header);
        if (ref == null) {
            return false;
        }
        SegmentBody body = ref.get();
        if (body == null) {
            this.map.remove(header);
            return false;
        }
        return true;
    }

    @Override
    public List<SegmentHeader> getSegmentHeaders() {
        return new ArrayList<SegmentHeader>(this.map.keySet());
    }

    @Override
    public boolean put(final SegmentHeader header, SegmentBody body) {
        assert (header != null);
        assert (body != null);
        this.map.put(header, new SoftReference<SegmentBody>(body));
        this.fireSegmentCacheEvent(new SegmentCache.SegmentCacheListener.SegmentCacheEvent(){

            public boolean isLocal() {
                return true;
            }

            public SegmentHeader getSource() {
                return header;
            }

            public SegmentCache.SegmentCacheListener.SegmentCacheEvent.EventType getEventType() {
                return SegmentCache.SegmentCacheListener.SegmentCacheEvent.EventType.ENTRY_CREATED;
            }
        });
        return true;
    }

    @Override
    public boolean remove(final SegmentHeader header) {
        boolean result;
        boolean bl = result = this.map.remove(header) != null;
        if (result) {
            this.fireSegmentCacheEvent(new SegmentCache.SegmentCacheListener.SegmentCacheEvent(){

                public boolean isLocal() {
                    return true;
                }

                public SegmentHeader getSource() {
                    return header;
                }

                public SegmentCache.SegmentCacheListener.SegmentCacheEvent.EventType getEventType() {
                    return SegmentCache.SegmentCacheListener.SegmentCacheEvent.EventType.ENTRY_DELETED;
                }
            });
        }
        return result;
    }

    @Override
    public void tearDown() {
        this.map.clear();
        this.listeners.clear();
    }

    @Override
    public void addListener(SegmentCache.SegmentCacheListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(SegmentCache.SegmentCacheListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public boolean supportsRichIndex() {
        return true;
    }

    public void fireSegmentCacheEvent(SegmentCache.SegmentCacheListener.SegmentCacheEvent evt) {
        for (SegmentCache.SegmentCacheListener listener : this.listeners) {
            listener.handle(evt);
        }
    }
}

