/*
 * Decompiled with CFR 0.152.
 */
package mondrian.server;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import mondrian.olap.MemoryLimitExceededException;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianServer;
import mondrian.olap.Query;
import mondrian.olap.QueryTiming;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapConnection;
import mondrian.server.Locus;
import mondrian.server.Statement;
import mondrian.server.StatementImpl;
import mondrian.server.monitor.ExecutionEndEvent;
import mondrian.server.monitor.ExecutionPhaseEvent;
import mondrian.server.monitor.ExecutionStartEvent;
import org.apache.log4j.MDC;

public class Execution {
    private static AtomicLong SEQ = new AtomicLong();
    final StatementImpl statement;
    private final Map<Locus, java.sql.Statement> statements = new HashMap<Locus, java.sql.Statement>();
    private State state = State.FRESH;
    private final Object sqlStateLock = new Object();
    private String outOfMemoryMsg;
    private long startTimeMillis;
    private long timeoutTimeMillis;
    private long timeoutIntervalMillis;
    private final QueryTiming queryTiming = new QueryTiming();
    private int phase;
    private int cellCacheHitCount;
    private int cellCacheMissCount;
    private int cellCachePendingCount;
    private final long id;
    public static final Execution NONE = new Execution(null, 0L);
    private final Map<String, Object> mdc = new HashMap<String, Object>();
    private final Execution parent;

    public Execution(Statement statement, long timeoutIntervalMillis) {
        Execution parentExec;
        try {
            parentExec = Locus.peek().execution;
        }
        catch (EmptyStackException e) {
            parentExec = null;
        }
        this.parent = parentExec;
        this.id = SEQ.getAndIncrement();
        this.statement = (StatementImpl)statement;
        this.timeoutIntervalMillis = timeoutIntervalMillis;
    }

    public void copyMDC() {
        this.mdc.clear();
        Hashtable currentMdc = MDC.getContext();
        if (currentMdc != null) {
            this.mdc.putAll(currentMdc);
        }
    }

    public void setContextMap() {
        Hashtable old = MDC.getContext();
        if (old != null) {
            old.clear();
            old.putAll(this.mdc);
        }
    }

    public void start() {
        assert (this.state == State.FRESH);
        this.startTimeMillis = System.currentTimeMillis();
        this.timeoutTimeMillis = this.timeoutIntervalMillis > 0L ? this.startTimeMillis + this.timeoutIntervalMillis : 0L;
        this.state = State.RUNNING;
        this.queryTiming.init(true);
        this.fireExecutionStartEvent();
    }

    private String getMdx() {
        Query query = this.statement.query;
        return query != null ? Util.unparse(query) : null;
    }

    public void tracePhase(int hitCount, int missCount, int pendingCount) {
        RolapConnection connection = this.statement.getMondrianConnection();
        MondrianServer server = connection.getServer();
        int hitCountInc = hitCount - this.cellCacheHitCount;
        int missCountInc = missCount - this.cellCacheMissCount;
        int pendingCountInc = pendingCount - this.cellCachePendingCount;
        server.getMonitor().sendEvent(new ExecutionPhaseEvent(System.currentTimeMillis(), server.getId(), connection.getId(), this.statement.getId(), this.id, this.phase, hitCountInc, missCountInc, pendingCountInc));
        ++this.phase;
        this.cellCacheHitCount = hitCount;
        this.cellCacheMissCount = missCount;
        this.cellCachePendingCount = pendingCount;
    }

    public void cancel() {
        this.state = State.CANCELED;
        if (this.parent != null) {
            this.parent.cancel();
        }
        this.fireExecutionEndEvent();
    }

    public final void setOutOfMemory(String msg) {
        assert (msg != null);
        this.outOfMemoryMsg = msg;
        this.state = State.ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkCancelOrTimeout() throws MondrianException {
        if (this.parent != null) {
            this.parent.checkCancelOrTimeout();
        }
        boolean needInterrupt = false;
        switch (this.state) {
            case CANCELED: {
                try {
                    if (Thread.interrupted()) {
                        needInterrupt = true;
                    }
                    this.fireExecutionEndEvent();
                }
                finally {
                    if (needInterrupt) {
                        Thread.currentThread().interrupt();
                    }
                }
                throw MondrianResource.instance().QueryCanceled.ex();
            }
            case RUNNING: {
                long currTime;
                if (this.timeoutTimeMillis <= 0L || (currTime = System.currentTimeMillis()) <= this.timeoutTimeMillis) break;
                this.state = State.TIMEOUT;
                this.fireExecutionEndEvent();
                throw MondrianResource.instance().QueryTimeout.ex(this.timeoutIntervalMillis / 1000L);
            }
            case ERROR: {
                try {
                    if (Thread.interrupted()) {
                        needInterrupt = true;
                    }
                    this.fireExecutionEndEvent();
                }
                finally {
                    if (needInterrupt) {
                        Thread.currentThread().interrupt();
                    }
                }
                throw new MemoryLimitExceededException(this.outOfMemoryMsg);
            }
        }
    }

    public boolean isCancelOrTimeout() {
        if (this.parent != null && this.parent.isCancelOrTimeout()) {
            return true;
        }
        return this.state == State.CANCELED || this.state == State.ERROR || this.state == State.RUNNING && this.timeoutTimeMillis > 0L && System.currentTimeMillis() > this.timeoutTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelSqlStatements() {
        if (this.parent != null) {
            this.parent.cancelSqlStatements();
        }
        Object object = this.sqlStateLock;
        synchronized (object) {
            Iterator<Map.Entry<Locus, java.sql.Statement>> iterator = this.statements.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Locus, java.sql.Statement> entry = iterator.next();
                java.sql.Statement statement1 = entry.getValue();
                iterator.remove();
                Util.cancelAndCloseStatement(statement1);
            }
        }
    }

    public void end() {
        this.queryTiming.done();
        this.state = State.DONE;
        this.statements.clear();
        this.fireExecutionEndEvent();
    }

    public final long getStartTime() {
        return this.startTimeMillis;
    }

    public final Statement getMondrianStatement() {
        return this.statement;
    }

    public final QueryTiming getQueryTiming() {
        return this.queryTiming;
    }

    public final long getId() {
        return this.id;
    }

    public final long getElapsedMillis() {
        return System.currentTimeMillis() - this.startTimeMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerStatement(Locus locus, java.sql.Statement statement) {
        Object object = this.sqlStateLock;
        synchronized (object) {
            if (this.state == State.FRESH) {
                this.start();
            }
            if (this.state == State.RUNNING) {
                this.statements.put(locus, statement);
            }
        }
    }

    private void fireExecutionEndEvent() {
        RolapConnection connection = this.statement.getMondrianConnection();
        MondrianServer server = connection.getServer();
        server.getMonitor().sendEvent(new ExecutionEndEvent(this.startTimeMillis, server.getId(), connection.getId(), this.statement.getId(), this.id, this.phase, this.state, this.cellCacheHitCount, this.cellCacheMissCount, this.cellCachePendingCount));
    }

    private void fireExecutionStartEvent() {
        RolapConnection connection = this.statement.getMondrianConnection();
        MondrianServer server = connection.getServer();
        server.getMonitor().sendEvent(new ExecutionStartEvent(this.startTimeMillis, server.getId(), connection.getId(), this.statement.getId(), this.id, this.getMdx()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        FRESH,
        RUNNING,
        ERROR,
        CANCELED,
        TIMEOUT,
        DONE;

    }
}

