/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.SQLException;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.PostgreSqlDialect;

public class NetezzaDialect
extends PostgreSqlDialect {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(NetezzaDialect.class, Dialect.DatabaseProduct.POSTGRESQL){

        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && PostgreSqlDialect.isNetezza(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public NetezzaDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.NETEZZA;
    }

    public boolean allowsRegularExpressionInWhereClause() {
        return false;
    }

    public String generateRegularExpression(String source, String javaRegex) {
        throw new UnsupportedOperationException();
    }
}

