/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDialect
extends JdbcDialectImpl {
    private final String flagsRegexp = "^(\\(\\?([a-zA-Z])\\)).*$";
    private final Pattern flagsPattern = Pattern.compile("^(\\(\\?([a-zA-Z])\\)).*$");
    private final String escapeRegexp = "(\\\\Q([^\\\\Q]+)\\\\E)";
    private final Pattern escapePattern = Pattern.compile("(\\\\Q([^\\\\Q]+)\\\\E)");
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(OracleDialect.class, Dialect.DatabaseProduct.ORACLE);

    public OracleDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public boolean allowsAs() {
        return false;
    }

    @Override
    public String generateInline(List<String> columnNames, List<String> columnTypes, List<String[]> valueList) {
        return this.generateInlineGeneric(columnNames, columnTypes, valueList, " from dual", false);
    }

    @Override
    public boolean supportsGroupingSets() {
        return true;
    }

    @Override
    public String generateOrderByNulls(String expr, boolean ascending, boolean collateNullsLast) {
        return this.generateOrderByNullsAnsi(expr, ascending, collateNullsLast);
    }

    @Override
    public boolean allowsJoinOn() {
        return false;
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public String generateRegularExpression(String source, String javaRegex) {
        String suffix;
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        Matcher flagsMatcher = this.flagsPattern.matcher(javaRegex);
        if (flagsMatcher.matches()) {
            StringBuilder suffixSb = new StringBuilder();
            String flags = flagsMatcher.group(2);
            if (flags.contains("i")) {
                suffixSb.append("i");
            }
            if (flags.contains("c")) {
                suffixSb.append("c");
            }
            if (flags.contains("m")) {
                suffixSb.append("m");
            }
            suffix = suffixSb.toString();
            javaRegex = javaRegex.substring(0, flagsMatcher.start(1)) + javaRegex.substring(flagsMatcher.end(1));
        } else {
            suffix = "";
        }
        Matcher escapeMatcher = this.escapePattern.matcher(javaRegex);
        while (escapeMatcher.find()) {
            javaRegex = javaRegex.replace(escapeMatcher.group(1), escapeMatcher.group(2));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("REGEXP_LIKE(");
        sb.append(source);
        sb.append(", ");
        this.quoteStringLiteral(sb, javaRegex);
        sb.append(", ");
        this.quoteStringLiteral(sb, suffix);
        sb.append(")");
        return sb.toString();
    }

    @Override
    public void quoteDateLiteral(StringBuilder buf, String value) {
        Date date;
        try {
            date = Date.valueOf(value);
        }
        catch (IllegalArgumentException ex) {
            try {
                date = new Date(Timestamp.valueOf(value).getTime());
            }
            catch (IllegalArgumentException ex2) {
                throw new NumberFormatException("Illegal DATE literal:  " + value);
            }
        }
        this.quoteDateLiteral(buf, value, date);
    }
}

