/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;
import org.apache.log4j.Logger;

public class PostgreSqlDialect
extends JdbcDialectImpl {
    private static final Logger LOGGER = Logger.getLogger(PostgreSqlDialect.class);
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(PostgreSqlDialect.class, Dialect.DatabaseProduct.POSTGRESQL){

        protected boolean acceptsConnection(Connection connection) {
            try {
                return super.acceptsConnection(connection) && !PostgreSqlDialect.isGreenplum(connection.getMetaData()) && !PostgreSqlDialect.isNetezza(connection.getMetaData());
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while instantiating dialect");
            }
        }
    };

    public PostgreSqlDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public boolean requiresAliasForFromQuery() {
        return true;
    }

    protected String generateOrderByNulls(String expr, boolean ascending, boolean collateNullsLast) {
        if (this.productVersion.compareTo("8.3") >= 0) {
            return this.generateOrderByNullsAnsi(expr, ascending, collateNullsLast);
        }
        return super.generateOrderByNulls(expr, ascending, collateNullsLast);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNetezza(DatabaseMetaData databaseMetaData) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            if (databaseMetaData.getDatabaseProductName().toLowerCase().contains("netezza")) {
                LOGGER.info((Object)"Using NETEZZA dialect");
                boolean bl = true;
                return bl;
            }
            statement = databaseMetaData.getConnection().createStatement();
            resultSet = statement.executeQuery("select version()");
            if (resultSet.next()) {
                String version = resultSet.getString(1);
                LOGGER.info((Object)("Version=" + version));
                if (version != null && version.toLowerCase().indexOf("netezza") != -1) {
                    LOGGER.info((Object)"Using NETEZZA dialect");
                    boolean e = true;
                    return e;
                }
            }
            LOGGER.info((Object)"NOT Using NETEZZA dialect");
            boolean version = false;
            return version;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while running query to detect Netezza database");
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    public static boolean isGreenplum(DatabaseMetaData databaseMetaData) {
        boolean version2;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = databaseMetaData.getConnection().createStatement();
            resultSet = statement.executeQuery("select version()");
            if (resultSet.next()) {
                String version2 = resultSet.getString(1);
                LOGGER.info((Object)("Version=" + version2));
                if (version2 != null && version2.toLowerCase().indexOf("greenplum") != -1) {
                    LOGGER.info((Object)"Using GREENPLUM dialect");
                    boolean bl = true;
                    return bl;
                }
            }
            LOGGER.info((Object)"Using POSTGRES dialect");
            version2 = false;
        }
        catch (SQLException e) {
            throw Util.newInternal(e, "while running query to detect Greenplum database");
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {}
            }
        }
        return version2;
    }

    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.POSTGRESQL;
    }

    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    public String generateRegularExpression(String source, String javaRegex) {
        try {
            Pattern.compile(javaRegex);
        }
        catch (PatternSyntaxException e) {
            return null;
        }
        javaRegex = javaRegex.replace("\\Q", "");
        javaRegex = javaRegex.replace("\\E", "");
        StringBuilder sb = new StringBuilder();
        sb.append("cast(");
        sb.append(source);
        sb.append(" as text) ~ ");
        this.quoteStringLiteral(sb, javaRegex);
        return sb.toString();
    }
}

