/*
 * Decompiled with CFR 0.152.
 */
package it.sauronsoftware.feed4j;

import it.sauronsoftware.feed4j.Constants;
import it.sauronsoftware.feed4j.TypeAbstract;
import it.sauronsoftware.feed4j.bean.Feed;
import it.sauronsoftware.feed4j.bean.FeedEnclosure;
import it.sauronsoftware.feed4j.bean.FeedHeader;
import it.sauronsoftware.feed4j.bean.FeedImage;
import it.sauronsoftware.feed4j.bean.FeedItem;
import it.sauronsoftware.feed4j.bean.RawElement;
import it.sauronsoftware.feed4j.bean.RawNode;
import it.sauronsoftware.feed4j.html.HTMLFragmentHelper;
import it.sauronsoftware.feed4j.html.HTMLOptimizer;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

class TypeRSS_2_0
extends TypeAbstract {
    TypeRSS_2_0() {
    }

    public static Feed feed(URL source, Document document) {
        Element root = document.getRootElement();
        Namespace ns = root.getNamespace();
        String nsuri = ns.getURI();
        Feed feed = new Feed();
        FeedHeader header = new FeedHeader();
        header.setURL(source);
        Element channel = root.element(new QName("channel", ns));
        if (channel != null) {
            TypeRSS_2_0.populateRawElement((RawElement)header, channel);
            int i = 0;
            while (i < header.getNodeCount()) {
                RawNode node = header.getNode(i);
                if (node instanceof RawElement) {
                    RawElement element = (RawElement)node;
                    String ensuri = element.getNamespaceURI();
                    String ename = element.getName();
                    String evalue = element.getValue();
                    if (evalue != null) {
                        if (ensuri.equals(nsuri)) {
                            if (ename.equals("title")) {
                                header.setTitle(evalue);
                            } else if (ename.equals("description")) {
                                header.setDescription(evalue);
                            } else if (ename.equals("link")) {
                                try {
                                    header.setLink(new URL(evalue));
                                }
                                catch (MalformedURLException malformedURLException) {}
                            } else if (ename.equals("pubDate")) {
                                try {
                                    header.setPubDate(Constants.RFC_822_DATE_FORMAT.parse(evalue));
                                }
                                catch (ParseException parseException) {}
                            } else if (ename.equals("language") && TypeRSS_2_0.isValidLanguageCode(evalue)) {
                                header.setLanguage(evalue);
                            }
                        }
                    } else if (ensuri.equals(nsuri)) {
                        if (ename.equals("item")) {
                            FeedItem item = TypeRSS_2_0.handleItem(source, element);
                            if (item != null) {
                                feed.addItem(item);
                            }
                        } else if (ename.equals("image")) {
                            header.setImage(TypeRSS_2_0.handleImage(element));
                        }
                    }
                }
                ++i;
            }
        }
        RawElement[] rawitems = header.getElements(nsuri, "item");
        int i = 0;
        while (i < rawitems.length) {
            header.removeNode(rawitems[i]);
            ++i;
        }
        RawElement[] rawimages = header.getElements(nsuri, "image");
        int i2 = 0;
        while (i2 < rawimages.length) {
            header.removeNode(rawimages[i2]);
            ++i2;
        }
        feed.setHeader(header);
        return feed;
    }

    private static FeedItem handleItem(URL source, RawElement rawItem) {
        String nsuri = rawItem.getNamespaceURI();
        FeedItem item = new FeedItem();
        TypeRSS_2_0.populateRawElement((RawElement)item, rawItem);
        int i = 0;
        while (i < item.getNodeCount()) {
            RawNode node = item.getNode(i);
            if (node instanceof RawElement) {
                FeedEnclosure enclosure;
                RawElement element = (RawElement)node;
                String ensuri = element.getNamespaceURI();
                String ename = element.getName();
                String evalue = element.getValue();
                if (evalue != null) {
                    if (ensuri.equals(nsuri)) {
                        if (ename.equals("title")) {
                            item.setTitle(evalue);
                        } else if (ename.equals("link")) {
                            try {
                                item.setLink(new URL(evalue));
                            }
                            catch (MalformedURLException malformedURLException) {}
                        } else if (ename.equals("pubDate")) {
                            try {
                                item.setPubDate(Constants.RFC_822_DATE_FORMAT.parse(evalue));
                            }
                            catch (ParseException parseException) {}
                        } else if (ename.equals("description")) {
                            if ((evalue = HTMLOptimizer.optimize(evalue)).length() > 0) {
                                item.setDescriptionAsHTML(evalue);
                                item.setDescriptionAsText(HTMLFragmentHelper.fromHTMLtoTextPlain(evalue));
                            }
                        } else if (ename.equals("comments")) {
                            try {
                                item.setComments(new URL(evalue));
                            }
                            catch (MalformedURLException malformedURLException) {}
                        } else if (ename.equals("guid")) {
                            String isPermaLink = element.getAttributeValue(ensuri, "isPermaLink");
                            if (isPermaLink != null && isPermaLink.equals("true")) {
                                try {
                                    item.setLink(new URL(evalue));
                                }
                                catch (MalformedURLException malformedURLException) {
                                    // empty catch block
                                }
                            }
                            item.setGUID(evalue);
                        }
                    }
                } else if (ename.equals("enclosure") && ensuri.equals(nsuri) && (enclosure = TypeRSS_2_0.handleEnclosure(element)) != null) {
                    item.addEnclosure(enclosure);
                }
            }
            ++i;
        }
        if (item.getTitle() == null || item.getLink() == null) {
            return null;
        }
        String rssGuid = item.getGUID();
        if (rssGuid == null) {
            rssGuid = item.getLink().toExternalForm();
        }
        item.setGUID(TypeRSS_2_0.buildGUID(source.hashCode(), rssGuid.hashCode()));
        RawElement[] enclosures = item.getElements(nsuri, "enclosure");
        int i2 = 0;
        while (i2 < enclosures.length) {
            item.removeNode(enclosures[i2]);
            ++i2;
        }
        return item;
    }

    private static FeedEnclosure handleEnclosure(RawElement rawEnclosure) {
        String nsuri = rawEnclosure.getNamespaceURI();
        FeedEnclosure enclosure = new FeedEnclosure();
        TypeRSS_2_0.populateRawElement((RawElement)enclosure, rawEnclosure);
        String value = enclosure.getAttributeValue(nsuri, "url");
        if (value != null) {
            try {
                enclosure.setURL(new URL(value));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((value = enclosure.getAttributeValue(nsuri, "type")) != null) {
            enclosure.setMimeType(value);
        }
        if ((value = enclosure.getAttributeValue(nsuri, "length")) != null) {
            long length = -1L;
            try {
                length = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (length > 0L) {
                enclosure.setLength(length);
            }
        }
        if (enclosure.getURL() == null || enclosure.getMimeType() == null) {
            return null;
        }
        return enclosure;
    }

    private static FeedImage handleImage(RawElement rawImage) {
        String nsuri = rawImage.getNamespaceURI();
        FeedImage image = new FeedImage();
        TypeRSS_2_0.populateRawElement((RawElement)image, rawImage);
        String value = image.getElementValue(nsuri, "url");
        if (value != null) {
            try {
                image.setURL(new URL(value));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if ((value = image.getElementValue(nsuri, "description")) != null) {
            image.setDescription(value);
        }
        if ((value = image.getElementValue(nsuri, "width")) != null) {
            int intvalue = 0;
            try {
                intvalue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (intvalue > 0) {
                image.setWidth(intvalue);
            }
        }
        if ((value = image.getElementValue(nsuri, "height")) != null) {
            int intvalue = 0;
            try {
                intvalue = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (intvalue > 0) {
                image.setHeight(intvalue);
            }
        }
        if (image.getURL() == null) {
            return null;
        }
        return image;
    }
}

