/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.util.List;
import org.olap4j.impl.UnmodifiableArrayList;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.NameSegment;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.Quoting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeySegment
implements IdentifierSegment {
    private final List<NameSegment> subSegmentList;

    public KeySegment(NameSegment ... subSegments) {
        if (subSegments.length < 1) {
            throw new IllegalArgumentException();
        }
        this.subSegmentList = UnmodifiableArrayList.asCopyOf(subSegments);
    }

    public KeySegment(List<NameSegment> subSegmentList) {
        if (subSegmentList.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.subSegmentList = new UnmodifiableArrayList<NameSegment>(subSegmentList.toArray(new NameSegment[subSegmentList.size()]));
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    @Override
    public void toString(StringBuilder buf) {
        for (NameSegment segment : this.subSegmentList) {
            buf.append('&');
            segment.toString(buf);
        }
    }

    @Override
    public ParseRegion getRegion() {
        return IdentifierNode.sumSegmentRegions(this.subSegmentList);
    }

    @Override
    public Quoting getQuoting() {
        return Quoting.KEY;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public List<NameSegment> getKeyParts() {
        return this.subSegmentList;
    }
}

