/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.io.PrintWriter;
import java.io.Writer;

public class ParseTreeWriter {
    private final PrintWriter pw;
    private int linePrefixLength;
    private String linePrefix;
    private static final int INDENT = 4;
    private static String bigString = "                ";

    public ParseTreeWriter(PrintWriter pw) {
        this((Writer)pw);
    }

    public ParseTreeWriter(Writer w) {
        this.pw = new PrintWriter(w){

            public void println() {
                super.println();
                this.print(ParseTreeWriter.this.linePrefix);
            }
        };
        this.linePrefixLength = 0;
        this.setPrefix();
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public void indent() {
        this.linePrefixLength += 4;
        this.setPrefix();
    }

    private void setPrefix() {
        this.linePrefix = ParseTreeWriter.spaces(this.linePrefixLength);
    }

    public void outdent() {
        this.linePrefixLength -= 4;
        this.setPrefix();
    }

    private static synchronized String spaces(int n) {
        while (n > bigString.length()) {
            bigString = bigString + bigString;
        }
        return bigString.substring(0, n);
    }
}

