/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.IndexBuilder;
import com.healthmarketscience.jackcess.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class TableBuilder {
    private String _name;
    private List<Column> _columns = new ArrayList<Column>();
    private List<IndexBuilder> _indexes = new ArrayList<IndexBuilder>();
    private boolean _escapeIdentifiers;

    public TableBuilder(String name) {
        this(name, false);
    }

    public TableBuilder(String name, boolean escapeIdentifiers) {
        this._name = name;
        this._escapeIdentifiers = escapeIdentifiers;
        if (this._escapeIdentifiers) {
            this._name = Database.escapeIdentifier(this._name);
        }
    }

    public TableBuilder addColumn(Column column) {
        if (this._escapeIdentifiers) {
            column.setName(Database.escapeIdentifier(column.getName()));
        }
        this._columns.add(column);
        return this;
    }

    public TableBuilder addColumn(ColumnBuilder columnBuilder) {
        return this.addColumn(columnBuilder.toColumn());
    }

    public TableBuilder addIndex(IndexBuilder index) {
        if (this._escapeIdentifiers) {
            index.setName(Database.escapeIdentifier(index.getName()));
            for (IndexBuilder.Column col : index.getColumns()) {
                col.setName(Database.escapeIdentifier(col.getName()));
            }
        }
        this._indexes.add(index);
        return this;
    }

    public TableBuilder setEscapeIdentifiers(boolean escapeIdentifiers) {
        this._escapeIdentifiers = escapeIdentifiers;
        return this;
    }

    public TableBuilder escapeName() {
        this._name = Database.escapeIdentifier(this._name);
        return this;
    }

    public Table toTable(Database db) throws IOException {
        db.createTable(this._name, this._columns, this._indexes);
        return db.getTable(this._name);
    }
}

