/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.query;

import com.healthmarketscience.jackcess.query.BaseSelectQuery;
import com.healthmarketscience.jackcess.query.Query;
import com.healthmarketscience.jackcess.query.QueryFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppendQuery
extends BaseSelectQuery {
    public AppendQuery(String name, List<Query.Row> rows, int objectId) {
        super(name, rows, objectId, Query.Type.APPEND);
    }

    public String getTargetTable() {
        return this.getTypeRow().name1;
    }

    public String getRemoteDbPath() {
        return this.getTypeRow().name2;
    }

    public String getRemoteDbType() {
        return this.getTypeRow().expression;
    }

    protected List<Query.Row> getValueRows() {
        return AppendQuery.filterRowsByFlag(super.getColumnRows(), (short)Short.MIN_VALUE);
    }

    @Override
    protected List<Query.Row> getColumnRows() {
        return AppendQuery.filterRowsByNotFlag(super.getColumnRows(), (short)Short.MIN_VALUE);
    }

    public List<String> getValues() {
        return new Query.RowFormatter(this.getValueRows()){

            protected void format(StringBuilder builder, Query.Row row) {
                builder.append(row.expression);
            }
        }.format();
    }

    @Override
    protected void toSQLString(StringBuilder builder) {
        builder.append("INSERT INTO ").append(this.getTargetTable());
        AppendQuery.toRemoteDb(builder, this.getRemoteDbPath(), this.getRemoteDbType());
        builder.append(QueryFormat.NEWLINE);
        List<String> values = this.getValues();
        if (!values.isEmpty()) {
            builder.append("VALUES (").append(values).append(')');
        } else {
            this.toSQLSelectString(builder, true);
        }
    }
}

