/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class CacheDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1972;
        }
        return -1;
    }

    public boolean supportsSetCharacterStream() {
        return false;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean supportsAutoInc() {
        return false;
    }

    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.intersys.jdbc.CacheDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        return "jdbc:Cache://" + hostname + ":" + port + "/" + databaseName;
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD COLUMN ( " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false) + " ) ";
    }

    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ALTER COLUMN " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk)) {
                    retval = retval + "DECIMAL";
                    break;
                }
                if (length < 0 || precision < 0) {
                    retval = retval + "DOUBLE";
                    break;
                }
                if (precision > 0 || length > 9) {
                    retval = retval + "DECIMAL(" + length;
                    if (precision > 0) {
                        retval = retval + ", " + precision;
                    }
                    retval = retval + ")";
                    break;
                }
                retval = retval + "INT";
                break;
            }
            case 2: {
                retval = retval + "VARCHAR";
                if (length <= 0) break;
                retval = retval + "(" + length + ")";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String[] getUsedLibraries() {
        return new String[]{"CacheDB.jar"};
    }

    public boolean requiresCreateTablePrimaryKeyAppend() {
        return true;
    }

    public boolean supportsNewLinesInSQL() {
        return false;
    }
}

