/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;

public class ConnectionPoolUtil {
    private static Class<?> PKG = Database.class;
    private static PoolingDriver pd = new PoolingDriver();
    public static final int defaultInitialNrOfConnections = 5;
    public static final int defaultMaximumNrOfConnections = 10;

    private static boolean isPoolRegistered(DatabaseMeta dbMeta, String partitionId) throws KettleDatabaseException {
        try {
            String name = dbMeta.getName() + Const.NVL((String)partitionId, (String)"");
            return Const.indexOfString((String)name, (String[])pd.getPoolNames()) >= 0;
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.UnableToCheckIfConnectionPoolExists.Exception", (String[])new String[0]), (Throwable)e);
        }
    }

    private static void createPool(LogChannelInterface log, DatabaseMeta databaseMeta, String partitionId, int initialSize, int maximumSize) throws KettleDatabaseException {
        String password;
        String userName;
        String url;
        log.logBasic(BaseMessages.getString(PKG, (String)"Database.CreatingConnectionPool", (String[])new String[]{databaseMeta.getName()}));
        GenericObjectPool gpool = new GenericObjectPool();
        gpool.setMaxIdle(-1);
        gpool.setWhenExhaustedAction((byte)2);
        gpool.setMaxActive(maximumSize);
        String clazz = databaseMeta.getDriverClass();
        try {
            Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.UnableToLoadConnectionPoolDriver.Exception", (String[])new String[]{databaseMeta.getName(), clazz}), (Throwable)e);
        }
        try {
            url = databaseMeta.environmentSubstitute(databaseMeta.getURL(partitionId));
            userName = databaseMeta.environmentSubstitute(databaseMeta.getUsername());
            password = databaseMeta.environmentSubstitute(databaseMeta.getPassword());
        }
        catch (RuntimeException e) {
            url = databaseMeta.getURL(partitionId);
            userName = databaseMeta.getUsername();
            password = databaseMeta.getPassword();
        }
        Properties originalProperties = databaseMeta.getConnectionPoolingProperties();
        originalProperties.setProperty("user", Const.NVL((String)userName, (String)""));
        originalProperties.setProperty("password", Const.NVL((String)password, (String)""));
        Properties properties = new Properties();
        for (String string : originalProperties.keySet()) {
            String value = originalProperties.getProperty(string);
            properties.put(string, databaseMeta.environmentSubstitute(value));
        }
        DriverManagerConnectionFactory driverManagerConnectionFactory = new DriverManagerConnectionFactory(url, properties);
        new PoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, (ObjectPool)gpool, null, null, false, false);
        for (int i = 0; i < initialSize; ++i) {
            try {
                gpool.addObject();
                continue;
            }
            catch (Exception e) {
                throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.UnableToPreLoadConnectionToConnectionPool.Exception", (String[])new String[0]), (Throwable)e);
            }
        }
        pd.registerPool(databaseMeta.getName(), (ObjectPool)gpool);
        log.logBasic(BaseMessages.getString(PKG, (String)"Database.CreatedConnectionPool", (String[])new String[]{databaseMeta.getName()}));
    }

    public static Connection getConnection(LogChannelInterface log, DatabaseMeta dbMeta, String partitionId) throws Exception {
        return ConnectionPoolUtil.getConnection(log, dbMeta, partitionId, dbMeta.getInitialPoolSize(), dbMeta.getMaximumPoolSize());
    }

    public static Connection getConnection(LogChannelInterface log, DatabaseMeta dbMeta, String partitionId, int initialSize, int maximumSize) throws Exception {
        if (!ConnectionPoolUtil.isPoolRegistered(dbMeta, partitionId)) {
            ConnectionPoolUtil.createPool(log, dbMeta, partitionId, initialSize, maximumSize);
        }
        return DriverManager.getConnection("jdbc:apache:commons:dbcp:" + dbMeta.getName());
    }
}

