/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.io.Reader;
import java.io.StringReader;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.DBCacheEntry;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.ConnectionPoolUtil;
import org.pentaho.di.core.database.DataSourceProviderFactory;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.Exasol4DatabaseMeta;
import org.pentaho.di.core.database.GreenplumDatabaseMeta;
import org.pentaho.di.core.database.MSSQLServerDatabaseMeta;
import org.pentaho.di.core.database.MSSQLServerNativeDatabaseMeta;
import org.pentaho.di.core.database.MySQLDatabaseMeta;
import org.pentaho.di.core.database.NeoviewDatabaseMeta;
import org.pentaho.di.core.database.OracleDatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.database.PostgreSQLDatabaseMeta;
import org.pentaho.di.core.database.SqlCommentScrubber;
import org.pentaho.di.core.database.SybaseDatabaseMeta;
import org.pentaho.di.core.database.SybaseIQDatabaseMeta;
import org.pentaho.di.core.database.TeradataDatabaseMeta;
import org.pentaho.di.core.database.VerticaDatabaseMeta;
import org.pentaho.di.core.database.map.DatabaseConnectionMap;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseBatchException;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Database
implements VariableSpace,
LoggingObjectInterface {
    private static Class<?> PKG = Database.class;
    private DatabaseMeta databaseMeta;
    private int rowlimit;
    private int commitsize;
    private Connection connection;
    private Statement sel_stmt;
    private PreparedStatement pstmt;
    private PreparedStatement prepStatementLookup;
    private PreparedStatement prepStatementUpdate;
    private PreparedStatement prepStatementInsert;
    private PreparedStatement pstmt_seq;
    private CallableStatement cstmt;
    private DatabaseMetaData dbmd;
    private RowMetaInterface rowMeta;
    private int written;
    private LogChannelInterface log;
    private LoggingObjectInterface parentLoggingObject;
    private int opened;
    private int copy;
    private String connectionGroup;
    private String partitionId;
    private VariableSpace variables = new Variables();
    private LogLevel logLevel = DefaultLogLevel.getLogLevel();
    private String containerObjectId;
    private int nrExecutedCommits;

    public Database(DatabaseMeta databaseMeta) {
        this.parentLoggingObject = null;
        this.databaseMeta = databaseMeta;
        this.shareVariablesWith(databaseMeta);
        this.log = new LogChannel((Object)this);
        this.logLevel = this.log.getLogLevel();
        this.containerObjectId = this.log.getContainerObjectId();
        this.pstmt = null;
        this.rowMeta = null;
        this.dbmd = null;
        this.rowlimit = 0;
        this.written = 0;
        if (this.log.isDetailed()) {
            this.log.logDetailed("New database connection defined");
        }
    }

    public Database(LoggingObjectInterface parentObject, DatabaseMeta databaseMeta) {
        this.parentLoggingObject = parentObject;
        this.databaseMeta = databaseMeta;
        this.shareVariablesWith(databaseMeta);
        if (parentObject instanceof VariableSpace) {
            this.shareVariablesWith((VariableSpace)parentObject);
        }
        this.log = new LogChannel((Object)this, parentObject);
        this.containerObjectId = this.log.getContainerObjectId();
        this.logLevel = this.log.getLogLevel();
        this.pstmt = null;
        this.rowMeta = null;
        this.dbmd = null;
        this.rowlimit = 0;
        this.written = 0;
        if (this.log.isDetailed()) {
            this.log.logDetailed("New database connection defined");
        }
    }

    public boolean equals(Object obj) {
        Database other = (Database)obj;
        return other.databaseMeta.equals(other.databaseMeta);
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setQueryLimit(int rows) {
        this.rowlimit = rows;
    }

    public PreparedStatement getPrepStatementInsert() {
        return this.prepStatementInsert;
    }

    public PreparedStatement getPrepStatementLookup() {
        return this.prepStatementLookup;
    }

    public PreparedStatement getPrepStatementUpdate() {
        return this.prepStatementUpdate;
    }

    public void connect() throws KettleDatabaseException {
        this.connect(null);
    }

    public void connect(String partitionId) throws KettleDatabaseException {
        this.connect(null, partitionId);
    }

    public synchronized void connect(String group, String partitionId) throws KettleDatabaseException {
        if (!Const.isEmpty((String)group)) {
            this.connectionGroup = group;
            this.partitionId = partitionId;
            DatabaseConnectionMap map = DatabaseConnectionMap.getInstance();
            Database lookup = map.getDatabase(group, partitionId, this);
            if (lookup == null) {
                this.normalConnect(partitionId);
                ++this.opened;
                this.copy = this.opened;
                map.storeDatabase(group, partitionId, this);
            } else {
                this.connection = lookup.getConnection();
                lookup.setOpened(lookup.getOpened() + 1);
                this.copy = lookup.getOpened();
            }
        } else {
            this.normalConnect(partitionId);
        }
    }

    public void normalConnect(String partitionId) throws KettleDatabaseException {
        block9: {
            if (this.databaseMeta == null) {
                throw new KettleDatabaseException("No valid database connection defined!");
            }
            try {
                String sql;
                if (this.databaseMeta.isUsingConnectionPool() && this.databaseMeta.getAccessType() != 4) {
                    try {
                        this.connection = ConnectionPoolUtil.getConnection(this.log, this.databaseMeta, partitionId);
                        break block9;
                    }
                    catch (Exception e) {
                        throw new KettleDatabaseException("Error occured while trying to connect to the database", (Throwable)e);
                    }
                }
                this.connectUsingClass(this.databaseMeta.getDriverClass(), partitionId);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Connected to database.");
                }
                if (!Const.isEmpty((String)(sql = this.environmentSubstitute(this.databaseMeta.getConnectSQL()))) && !Const.onlySpaces((String)sql)) {
                    this.execStatements(sql);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Executed connect time SQL statements:" + Const.CR + sql);
                    }
                }
            }
            catch (Exception e) {
                throw new KettleDatabaseException("Error occured while trying to connect to the database", (Throwable)e);
            }
        }
    }

    private void initWithNamedDataSource(String dataSourceName) throws KettleDatabaseException {
        this.connection = null;
        DataSource dataSource = DataSourceProviderFactory.getDataSourceProviderInterface().getNamedDataSource(dataSourceName);
        if (dataSource != null) {
            try {
                this.connection = dataSource.getConnection();
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Invalid JNDI connection " + dataSourceName + " : " + e.getMessage());
            }
            if (this.connection == null) {
                throw new KettleDatabaseException("Invalid JNDI connection " + dataSourceName);
            }
        } else {
            throw new KettleDatabaseException("Invalid JNDI connection " + dataSourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectUsingClass(String classname, String partitionId) throws KettleDatabaseException {
        if (this.databaseMeta.getAccessType() == 4) {
            this.initWithNamedDataSource(this.environmentSubstitute(this.databaseMeta.getDatabaseName()));
            return;
        }
        try {
            Class<DriverManager> clazz = DriverManager.class;
            synchronized (DriverManager.class) {
                Class.forName(classname);
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (NoClassDefFoundError e) {
            throw new KettleDatabaseException("Exception while loading class", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new KettleDatabaseException("Exception while loading class", (Throwable)e);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Exception while loading class", (Throwable)e);
        }
        {
            try {
                String password;
                String username;
                PartitionDatabaseMeta partition;
                String url = this.databaseMeta.isPartitioned() && !Const.isEmpty((String)partitionId) ? this.environmentSubstitute(this.databaseMeta.getURL(partitionId)) : this.environmentSubstitute(this.databaseMeta.getURL());
                String clusterUsername = null;
                String clusterPassword = null;
                if (this.databaseMeta.isPartitioned() && !Const.isEmpty((String)partitionId) && (partition = this.databaseMeta.getPartitionMeta(partitionId)) != null) {
                    clusterUsername = partition.getUsername();
                    clusterPassword = Encr.decryptPasswordOptionallyEncrypted((String)partition.getPassword());
                }
                if (!Const.isEmpty(clusterUsername)) {
                    username = clusterUsername;
                    password = clusterPassword;
                } else {
                    username = this.environmentSubstitute(this.databaseMeta.getUsername());
                    password = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.databaseMeta.getPassword()));
                }
                if (this.databaseMeta.supportsOptionsInURL()) {
                    String instance;
                    this.connection = !Const.isEmpty((String)username) || !Const.isEmpty((String)password) ? (this.databaseMeta.getDatabaseInterface() instanceof MSSQLServerNativeDatabaseMeta ? (Const.isEmpty((String)(instance = this.environmentSubstitute(this.databaseMeta.getSQLServerInstance()))) ? DriverManager.getConnection(url + ";user=" + username + ";password=" + password) : DriverManager.getConnection(url + ";user=" + username + ";password=" + password + ";instanceName=" + instance)) : DriverManager.getConnection(url, Const.NVL((String)username, (String)" "), Const.NVL((String)password, (String)""))) : DriverManager.getConnection(url);
                } else {
                    Properties properties = this.databaseMeta.getConnectionProperties();
                    if (!Const.isEmpty((String)username)) {
                        properties.put("user", username);
                    }
                    if (!Const.isEmpty((String)password)) {
                        properties.put("password", password);
                    }
                    this.connection = DriverManager.getConnection(url, properties);
                }
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error connecting to database: (using class " + classname + ")", (Throwable)e);
            }
            catch (Throwable e) {
                throw new KettleDatabaseException("Error connecting to database: (using class " + classname + ")", e);
            }
            return;
        }
    }

    public synchronized void disconnect() {
        try {
            if (this.connection == null) {
                return;
            }
            if (this.connection.isClosed()) {
                return;
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            if (this.prepStatementLookup != null) {
                this.prepStatementLookup.close();
                this.prepStatementLookup = null;
            }
            if (this.prepStatementInsert != null) {
                this.prepStatementInsert.close();
                this.prepStatementInsert = null;
            }
            if (this.prepStatementUpdate != null) {
                this.prepStatementUpdate.close();
                this.prepStatementUpdate = null;
            }
            if (this.pstmt_seq != null) {
                this.pstmt_seq.close();
                this.pstmt_seq = null;
            }
            if (!Const.isEmpty((String)this.connectionGroup)) {
                return;
            }
            if (!this.isAutoCommit()) {
                this.commit();
            }
            this.closeConnectionOnly();
        }
        catch (SQLException ex) {
            this.log.logError("Error disconnecting from database:" + Const.CR + ex.getMessage());
            this.log.logError(Const.getStackTracker((Throwable)ex));
        }
        catch (KettleDatabaseException dbe) {
            this.log.logError("Error disconnecting from database:" + Const.CR + dbe.getMessage());
            this.log.logError(Const.getStackTracker((Throwable)dbe));
        }
    }

    public synchronized void closeConnectionOnly() throws KettleDatabaseException {
        try {
            if (this.connection != null) {
                this.connection.close();
                if (!this.databaseMeta.isUsingConnectionPool()) {
                    this.connection = null;
                }
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed("Connection to database closed!");
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error disconnecting from database '" + this.toString() + "'", (Throwable)e);
        }
    }

    public void cancelQuery() throws KettleDatabaseException {
        if (this.databaseMeta.isMySQLVariant() && this.databaseMeta.isStreamingResults()) {
            return;
        }
        this.cancelStatement(this.pstmt);
        this.cancelStatement(this.sel_stmt);
    }

    public void cancelStatement(Statement statement) throws KettleDatabaseException {
        try {
            if (statement != null) {
                statement.cancel();
            }
            if (this.log.isDebug()) {
                this.log.logDebug("Statement canceled!");
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error cancelling statement", (Throwable)ex);
        }
    }

    public void setCommit(int commsize) {
        block3: {
            this.commitsize = commsize;
            String onOff = this.commitsize <= 0 ? "on" : "off";
            try {
                this.connection.setAutoCommit(this.commitsize <= 0);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Auto commit " + onOff);
                }
            }
            catch (Exception e) {
                if (!this.log.isDebug()) break block3;
                this.log.logDebug("Can't turn auto commit " + onOff + Const.CR + Const.getStackTracker((Throwable)e));
            }
        }
    }

    public void setAutoCommit(boolean useAutoCommit) throws KettleDatabaseException {
        try {
            this.connection.setAutoCommit(useAutoCommit);
        }
        catch (SQLException e) {
            if (useAutoCommit) {
                throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.Exception.UnableToEnableAutoCommit", (String[])new String[]{this.toString()}));
            }
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.Exception.UnableToDisableAutoCommit", (String[])new String[]{this.toString()}));
        }
    }

    public void commit() throws KettleDatabaseException {
        this.commit(false);
    }

    public void commit(boolean force) throws KettleDatabaseException {
        block7: {
            try {
                if (!Const.isEmpty((String)this.connectionGroup) && !force) {
                    return;
                }
                if (this.getDatabaseMetaData().supportsTransactions()) {
                    if (this.log.isDebug()) {
                        this.log.logDebug("Commit on database connection [" + this.toString() + "]");
                    }
                    this.connection.commit();
                    ++this.nrExecutedCommits;
                } else if (this.log.isDetailed()) {
                    this.log.logDetailed("No commit possible on database connection [" + this.toString() + "]");
                }
            }
            catch (Exception e) {
                if (!this.databaseMeta.supportsEmptyTransactions()) break block7;
                throw new KettleDatabaseException("Error comitting connection", (Throwable)e);
            }
        }
    }

    public void rollback() throws KettleDatabaseException {
        this.rollback(false);
    }

    public void rollback(boolean force) throws KettleDatabaseException {
        try {
            if (!Const.isEmpty((String)this.connectionGroup) && !force) {
                return;
            }
            if (this.getDatabaseMetaData().supportsTransactions()) {
                if (this.connection != null) {
                    if (this.log.isDebug()) {
                        this.log.logDebug("Rollback on database connection [" + this.toString() + "]");
                    }
                    this.connection.rollback();
                }
            } else if (this.log.isDetailed()) {
                this.log.logDetailed("No rollback possible on database connection [" + this.toString() + "]");
            }
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Error performing rollback on connection", (Throwable)e);
        }
    }

    public void prepareInsert(RowMetaInterface rowMeta, String tableName) throws KettleDatabaseException {
        this.prepareInsert(rowMeta, null, tableName);
    }

    public void prepareInsert(RowMetaInterface rowMeta, String schemaName, String tableName) throws KettleDatabaseException {
        if (rowMeta.size() == 0) {
            throw new KettleDatabaseException("No fields in row, can't insert!");
        }
        String ins = this.getInsertStatement(schemaName, tableName, rowMeta);
        if (this.log.isDetailed()) {
            this.log.logDetailed("Preparing statement: " + Const.CR + ins);
        }
        this.prepStatementInsert = this.prepareSQL(ins);
    }

    public PreparedStatement prepareSQL(String sql) throws KettleDatabaseException {
        return this.prepareSQL(sql, false);
    }

    public PreparedStatement prepareSQL(String sql, boolean returnKeys) throws KettleDatabaseException {
        try {
            if (returnKeys) {
                return this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1);
            }
            return this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't prepare statement:" + Const.CR + sql, (Throwable)ex);
        }
    }

    public void closeLookup() throws KettleDatabaseException {
        this.closePreparedStatement(this.pstmt);
        this.pstmt = null;
    }

    public void closePreparedStatement(PreparedStatement ps) throws KettleDatabaseException {
        if (ps != null) {
            try {
                ps.close();
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing prepared statement", (Throwable)e);
            }
        }
    }

    public void closeInsert() throws KettleDatabaseException {
        if (this.prepStatementInsert != null) {
            try {
                this.prepStatementInsert.close();
                this.prepStatementInsert = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing insert prepared statement.", (Throwable)e);
            }
        }
    }

    public void closeUpdate() throws KettleDatabaseException {
        if (this.prepStatementUpdate != null) {
            try {
                this.prepStatementUpdate.close();
                this.prepStatementUpdate = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing update prepared statement.", (Throwable)e);
            }
        }
    }

    public void setValues(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.pstmt);
    }

    public void setValues(RowMetaAndData row) throws KettleDatabaseException {
        this.setValues(row.getRowMeta(), row.getData());
    }

    public void setValuesInsert(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementInsert);
    }

    public void setValuesInsert(RowMetaAndData row) throws KettleDatabaseException {
        this.setValues(row.getRowMeta(), row.getData(), this.prepStatementInsert);
    }

    public void setValuesUpdate(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementUpdate);
    }

    public void setValuesLookup(RowMetaInterface rowMeta, Object[] data) throws KettleDatabaseException {
        this.setValues(rowMeta, data, this.prepStatementLookup);
    }

    public void setProcValues(RowMetaInterface rowMeta, Object[] data, int[] argnrs, String[] argdir, boolean result) throws KettleDatabaseException {
        int pos = result ? 2 : 1;
        for (int i = 0; i < argnrs.length; ++i) {
            if (argdir[i].equalsIgnoreCase("IN") || argdir[i].equalsIgnoreCase("INOUT")) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(argnrs[i]);
                Object value = data[argnrs[i]];
                this.setValue(this.cstmt, valueMeta, value, pos);
                ++pos;
                continue;
            }
            ++pos;
        }
    }

    public void setValue(PreparedStatement ps, ValueMetaInterface v, Object object, int pos) throws KettleDatabaseException {
        String debug = "";
        try {
            switch (v.getType()) {
                case 1: {
                    if (!v.isNull(object)) {
                        debug = "Number, not null, getting number from value";
                        double num = v.getNumber(object);
                        if (this.databaseMeta.supportsFloatRoundingOnUpdate() && v.getPrecision() >= 0) {
                            debug = "Number, rounding to precision [" + v.getPrecision() + "]";
                            num = Const.round((double)num, (int)v.getPrecision());
                        }
                        debug = "Number, setting [" + num + "] on position #" + pos + " of the prepared statement";
                        ps.setDouble(pos, num);
                        break;
                    }
                    ps.setNull(pos, 8);
                    break;
                }
                case 5: {
                    debug = "Integer";
                    if (!v.isNull(object)) {
                        if (this.databaseMeta.supportsSetLong()) {
                            ps.setLong(pos, v.getInteger(object));
                            break;
                        }
                        double d = v.getNumber(object);
                        if (this.databaseMeta.supportsFloatRoundingOnUpdate() && v.getPrecision() >= 0) {
                            ps.setDouble(pos, d);
                            break;
                        }
                        ps.setDouble(pos, Const.round((double)d, (int)v.getPrecision()));
                        break;
                    }
                    ps.setNull(pos, 4);
                    break;
                }
                case 2: {
                    debug = "String";
                    if (v.getLength() < 9999999) {
                        if (!v.isNull(object)) {
                            ps.setString(pos, v.getString(object));
                            break;
                        }
                        ps.setNull(pos, 12);
                        break;
                    }
                    if (!v.isNull(object)) {
                        String string = v.getString(object);
                        int maxlen = this.databaseMeta.getMaxTextFieldLength();
                        int len = string.length();
                        int begin = len - maxlen;
                        if (begin < 0) {
                            begin = 0;
                        }
                        String logging = string.substring(begin);
                        if (this.databaseMeta.supportsSetCharacterStream()) {
                            StringReader sr = new StringReader(logging);
                            ps.setCharacterStream(pos, (Reader)sr, logging.length());
                            break;
                        }
                        ps.setString(pos, logging);
                        break;
                    }
                    ps.setNull(pos, 12);
                    break;
                }
                case 3: {
                    debug = "Date";
                    if (!v.isNull(object)) {
                        long dat = v.getInteger(object);
                        if (v.getPrecision() == 1 || !this.databaseMeta.supportsTimeStampToDateConversion()) {
                            Date ddate = new Date(dat);
                            ps.setDate(pos, ddate);
                            break;
                        }
                        Timestamp sdate = new Timestamp(dat);
                        ps.setTimestamp(pos, sdate);
                        break;
                    }
                    if (v.getPrecision() == 1 || !this.databaseMeta.supportsTimeStampToDateConversion()) {
                        ps.setNull(pos, 91);
                        break;
                    }
                    ps.setNull(pos, 93);
                    break;
                }
                case 4: {
                    debug = "Boolean";
                    if (this.databaseMeta.supportsBooleanDataType()) {
                        if (!v.isNull(object)) {
                            ps.setBoolean(pos, v.getBoolean(object));
                            break;
                        }
                        ps.setNull(pos, 16);
                        break;
                    }
                    if (!v.isNull(object)) {
                        ps.setString(pos, v.getBoolean(object) != false ? "Y" : "N");
                        break;
                    }
                    ps.setNull(pos, 1);
                    break;
                }
                case 6: {
                    debug = "BigNumber";
                    if (!v.isNull(object)) {
                        ps.setBigDecimal(pos, v.getBigNumber(object));
                        break;
                    }
                    ps.setNull(pos, 3);
                    break;
                }
                case 8: {
                    debug = "Binary";
                    if (!v.isNull(object)) {
                        ps.setBytes(pos, v.getBinary(object));
                        break;
                    }
                    ps.setNull(pos, -2);
                    break;
                }
                default: {
                    debug = "default";
                    ps.setNull(pos, 12);
                }
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error setting value #" + pos + " [" + v.toString() + "] on prepared statement (" + debug + ")" + Const.CR + ex.toString(), (Throwable)ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Error setting value #" + pos + " [" + (v == null ? "NULL" : v.toString()) + "] on prepared statement (" + debug + ")" + Const.CR + e.toString(), (Throwable)e);
        }
    }

    public void setValues(RowMetaAndData row, PreparedStatement ps) throws KettleDatabaseException {
        this.setValues(row.getRowMeta(), row.getData(), ps);
    }

    public void setValues(RowMetaInterface rowMeta, Object[] data, PreparedStatement ps) throws KettleDatabaseException {
        for (int i = 0; i < rowMeta.size(); ++i) {
            ValueMetaInterface v = rowMeta.getValueMeta(i);
            Object object = data[i];
            try {
                this.setValue(ps, v, object, i + 1);
                continue;
            }
            catch (KettleDatabaseException e) {
                throw new KettleDatabaseException("offending row : " + rowMeta, (Throwable)e);
            }
        }
    }

    public void setValues(RowMetaInterface rowMeta, Object[] data, PreparedStatement ps, int ignoreThisValueIndex) throws KettleDatabaseException {
        int index = 0;
        for (int i = 0; i < rowMeta.size(); ++i) {
            if (i == ignoreThisValueIndex) continue;
            ValueMetaInterface v = rowMeta.getValueMeta(i);
            Object object = data[i];
            try {
                this.setValue(ps, v, object, index + 1);
                ++index;
                continue;
            }
            catch (KettleDatabaseException e) {
                throw new KettleDatabaseException("offending row : " + rowMeta, (Throwable)e);
            }
        }
    }

    public RowMetaAndData getGeneratedKeys(PreparedStatement ps) throws KettleDatabaseException {
        ResultSet keys = null;
        try {
            RowMeta rowMeta;
            keys = ps.getGeneratedKeys();
            ResultSetMetaData resultSetMetaData = keys.getMetaData();
            if (resultSetMetaData == null) {
                resultSetMetaData = ps.getMetaData();
            }
            if (resultSetMetaData == null) {
                rowMeta = new RowMeta();
                rowMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ai-key", 5));
            } else {
                rowMeta = this.getRowInfo(resultSetMetaData, false, false);
            }
            RowMetaAndData rowMetaAndData = new RowMetaAndData((RowMetaInterface)rowMeta, this.getRow(keys, resultSetMetaData, (RowMetaInterface)rowMeta));
            return rowMetaAndData;
        }
        catch (Exception ex) {
            throw new KettleDatabaseException("Unable to retrieve key(s) from auto-increment field(s)", (Throwable)ex);
        }
        finally {
            if (keys != null) {
                try {
                    keys.close();
                }
                catch (SQLException e) {
                    throw new KettleDatabaseException("Unable to close resultset of auto-generated keys", (Throwable)e);
                }
            }
        }
    }

    public Long getNextSequenceValue(String sequenceName, String keyfield) throws KettleDatabaseException {
        return this.getNextSequenceValue(null, sequenceName, keyfield);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextSequenceValue(String schemaName, String sequenceName, String keyfield) throws KettleDatabaseException {
        Long retval = null;
        String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, sequenceName);
        try {
            if (this.pstmt_seq == null) {
                this.pstmt_seq = this.connection.prepareStatement(this.databaseMeta.getSeqNextvalSQL(this.databaseMeta.stripCR(schemaSequence)));
            }
            ResultSet rs = null;
            try {
                rs = this.pstmt_seq.executeQuery();
                if (rs.next()) {
                    retval = rs.getLong(1);
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to get next value for sequence : " + schemaSequence, (Throwable)ex);
        }
        return retval;
    }

    public void insertRow(String tableName, RowMetaInterface fields, Object[] data) throws KettleDatabaseException {
        this.insertRow(null, tableName, fields, data);
    }

    public void insertRow(String schemaName, String tableName, RowMetaInterface fields, Object[] data) throws KettleDatabaseException {
        this.prepareInsert(fields, schemaName, tableName);
        this.setValuesInsert(fields, data);
        this.insertRow();
        this.closeInsert();
    }

    public String getInsertStatement(String tableName, RowMetaInterface fields) {
        return this.getInsertStatement(null, tableName, fields);
    }

    public String getInsertStatement(String schemaName, String tableName, RowMetaInterface fields) {
        int i;
        StringBuffer ins = new StringBuffer(128);
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        ins.append("INSERT INTO ").append(schemaTable).append(" (");
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins.append(", ");
            }
            String name = fields.getValueMeta(i).getName();
            ins.append(this.databaseMeta.quoteField(name));
        }
        ins.append(") VALUES (");
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                ins.append(", ");
            }
            ins.append(" ?");
        }
        ins.append(')');
        return ins.toString();
    }

    public void insertRow() throws KettleDatabaseException {
        this.insertRow(this.prepStatementInsert);
    }

    public void insertRow(boolean batch) throws KettleDatabaseException {
        this.insertRow(this.prepStatementInsert, batch);
    }

    public void updateRow() throws KettleDatabaseException {
        this.insertRow(this.prepStatementUpdate);
    }

    public void insertRow(PreparedStatement ps) throws KettleDatabaseException {
        this.insertRow(ps, false);
    }

    public boolean insertRow(PreparedStatement ps, boolean batch) throws KettleDatabaseException {
        return this.insertRow(ps, batch, true);
    }

    public boolean insertRow(PreparedStatement ps, boolean batch, boolean handleCommit) throws KettleDatabaseException {
        String debug = "insertRow start";
        boolean rowsAreSafe = false;
        try {
            boolean useBatchInsert;
            boolean bl = useBatchInsert = batch && this.getDatabaseMetaData().supportsBatchUpdates() && this.databaseMeta.supportsBatchUpdates() && Const.isEmpty((String)this.connectionGroup);
            if (!this.isAutoCommit()) {
                if (useBatchInsert) {
                    debug = "insertRow add batch";
                    ps.addBatch();
                } else {
                    debug = "insertRow exec update";
                    ps.executeUpdate();
                }
            } else {
                ps.executeUpdate();
            }
            ++this.written;
            if (handleCommit && !this.isAutoCommit() && this.written % this.commitsize == 0) {
                if (useBatchInsert) {
                    debug = "insertRow executeBatch commit";
                    ps.executeBatch();
                    this.commit();
                    ps.clearBatch();
                } else {
                    debug = "insertRow normal commit";
                    this.commit();
                }
                rowsAreSafe = true;
            }
            return rowsAreSafe;
        }
        catch (BatchUpdateException ex) {
            KettleDatabaseBatchException kdbe = new KettleDatabaseBatchException("Error updating batch", (Throwable)ex);
            kdbe.setUpdateCounts(ex.getUpdateCounts());
            ArrayList<BatchUpdateException> exceptions = new ArrayList<BatchUpdateException>();
            SQLException nextException = ex;
            do {
                exceptions.add((BatchUpdateException)nextException);
            } while ((nextException = nextException.getNextException()) != null);
            kdbe.setExceptionsList(exceptions);
            throw kdbe;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error inserting/updating row", (Throwable)ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unexpected error inserting/updating row in part [" + debug + "]", (Throwable)e);
        }
    }

    public void clearInsertBatch() throws KettleDatabaseException {
        this.clearBatch(this.prepStatementInsert);
    }

    public void clearBatch(PreparedStatement preparedStatement) throws KettleDatabaseException {
        try {
            preparedStatement.clearBatch();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to clear batch for prepared statement", (Throwable)e);
        }
    }

    public void insertFinished(boolean batch) throws KettleDatabaseException {
        this.insertFinished(this.prepStatementInsert, batch);
        this.prepStatementInsert = null;
    }

    public void emptyAndCommit(PreparedStatement ps, boolean batch) throws KettleDatabaseException {
        this.emptyAndCommit(ps, batch, this.written);
    }

    public void emptyAndCommit(PreparedStatement ps, boolean batch, int batchCounter) throws KettleDatabaseException {
        try {
            if (ps != null) {
                if (!this.isAutoCommit()) {
                    if (batch && this.getDatabaseMetaData().supportsBatchUpdates() && batchCounter > 0) {
                        ps.executeBatch();
                        this.commit();
                        ps.clearBatch();
                    } else {
                        this.commit();
                    }
                }
                ps.close();
            }
        }
        catch (BatchUpdateException ex) {
            KettleDatabaseBatchException kdbe = new KettleDatabaseBatchException("Error updating batch", (Throwable)ex);
            kdbe.setUpdateCounts(ex.getUpdateCounts());
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            SQLException oldException = null;
            for (SQLException nextException = ex.getNextException(); nextException != null && oldException != nextException; nextException = nextException.getNextException()) {
                exceptions.add(nextException);
                oldException = nextException;
            }
            kdbe.setExceptionsList(exceptions);
            throw kdbe;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to empty ps and commit connection.", (Throwable)ex);
        }
    }

    public void insertFinished(PreparedStatement ps, boolean batch) throws KettleDatabaseException {
        try {
            if (ps != null) {
                if (!this.isAutoCommit()) {
                    if (batch && this.getDatabaseMetaData().supportsBatchUpdates()) {
                        ps.executeBatch();
                        this.commit();
                    } else {
                        this.commit();
                    }
                }
                ps.close();
            }
        }
        catch (BatchUpdateException ex) {
            KettleDatabaseBatchException kdbe = new KettleDatabaseBatchException("Error updating batch", (Throwable)ex);
            kdbe.setUpdateCounts(ex.getUpdateCounts());
            ArrayList<SQLException> exceptions = new ArrayList<SQLException>();
            SQLException oldException = null;
            for (SQLException nextException = ex.getNextException(); nextException != null && oldException != nextException; nextException = nextException.getNextException()) {
                exceptions.add(nextException);
                oldException = nextException;
            }
            kdbe.setExceptionsList(exceptions);
            throw kdbe;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to commit connection after having inserted rows.", (Throwable)ex);
        }
    }

    public Result execStatement(String sql) throws KettleDatabaseException {
        return this.execStatement(sql, null, null);
    }

    public Result execStatement(String rawsql, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        Result result = new Result();
        String sql = SqlCommentScrubber.removeComments(rawsql).trim();
        try {
            int count;
            boolean resultSet;
            if (params != null) {
                PreparedStatement prep_stmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                this.setValues(params, data, prep_stmt);
                resultSet = prep_stmt.execute();
                count = prep_stmt.getUpdateCount();
                prep_stmt.close();
            } else {
                String sqlStripped = this.databaseMeta.stripCR(sql);
                Statement stmt = this.connection.createStatement();
                resultSet = stmt.execute(sqlStripped);
                count = stmt.getUpdateCount();
                stmt.close();
            }
            String upperSql = sql.toUpperCase();
            if (!resultSet && count > 0) {
                if (upperSql.startsWith("INSERT")) {
                    result.setNrLinesOutput((long)count);
                } else if (upperSql.startsWith("UPDATE")) {
                    result.setNrLinesUpdated((long)count);
                } else if (upperSql.startsWith("DELETE")) {
                    result.setNrLinesDeleted((long)count);
                }
            }
            if (upperSql.startsWith("ALTER TABLE") || upperSql.startsWith("DROP TABLE") || upperSql.startsWith("CREATE TABLE")) {
                DBCache.getInstance().clear(this.databaseMeta.getName());
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't execute SQL: " + sql + Const.CR, (Throwable)ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unexpected error executing SQL: " + Const.CR, (Throwable)e);
        }
        return result;
    }

    public Result execStatements(String script) throws KettleDatabaseException {
        Result result = new Result();
        String all = SqlCommentScrubber.removeComments(script);
        String[] statements = all.split(";");
        int nrstats = 0;
        for (int i = 0; i < statements.length; ++i) {
            String stat = statements[i];
            if (Const.onlySpaces((String)stat)) continue;
            String sql = Const.trim((String)stat);
            if (sql.toUpperCase().startsWith("SELECT")) {
                if (this.log.isDetailed()) {
                    this.log.logDetailed("launch SELECT statement: " + Const.CR + sql);
                }
                ++nrstats;
                ResultSet rs = null;
                try {
                    rs = this.openQuery(sql);
                    if (rs != null) {
                        Object[] row = this.getRow(rs);
                        while (row != null) {
                            result.setNrLinesRead(result.getNrLinesRead() + 1L);
                            if (this.log.isDetailed()) {
                                this.log.logDetailed(this.rowMeta.getString(row));
                            }
                            row = this.getRow(rs);
                        }
                        continue;
                    }
                    if (!this.log.isDebug()) continue;
                    this.log.logDebug("Error executing query: " + Const.CR + sql);
                    continue;
                }
                catch (KettleValueException e) {
                    throw new KettleDatabaseException((Throwable)e);
                }
                finally {
                    block18: {
                        try {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                        catch (SQLException ex) {
                            if (!this.log.isDebug()) break block18;
                            this.log.logDebug("Error closing query: " + Const.CR + sql);
                        }
                    }
                }
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed("launch DDL statement: " + Const.CR + sql);
            }
            ++nrstats;
            Result res = this.execStatement(sql);
            result.add(res);
        }
        if (this.log.isDetailed()) {
            this.log.logDetailed(nrstats + " statement" + (nrstats == 1 ? "" : "s") + " executed");
        }
        return result;
    }

    public ResultSet openQuery(String sql) throws KettleDatabaseException {
        return this.openQuery(sql, null, null);
    }

    public ResultSet openQuery(String sql, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        return this.openQuery(sql, params, data, 1000);
    }

    public ResultSet openQuery(String sql, RowMetaInterface params, Object[] data, int fetch_mode) throws KettleDatabaseException {
        return this.openQuery(sql, params, data, fetch_mode, false);
    }

    public ResultSet openQuery(String sql, RowMetaInterface params, Object[] data, int fetch_mode, boolean lazyConversion) throws KettleDatabaseException {
        ResultSet res;
        String debug = "Start";
        try {
            if (params != null) {
                debug = "P create prepared statement (con==null? " + (this.connection == null) + ")";
                this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1003, 1007);
                debug = "P Set values";
                this.setValues(params, data);
                if (this.canWeSetFetchSize(this.pstmt)) {
                    int fs;
                    debug = "P Set fetchsize";
                    int n = fs = 5000 <= this.pstmt.getMaxRows() ? this.pstmt.getMaxRows() : 5000;
                    if (this.databaseMeta.isMySQLVariant() && this.databaseMeta.isStreamingResults()) {
                        this.pstmt.setFetchSize(Integer.MIN_VALUE);
                    } else {
                        this.pstmt.setFetchSize(fs);
                    }
                    debug = "P Set fetch direction";
                    this.pstmt.setFetchDirection(fetch_mode);
                }
                debug = "P Set max rows";
                if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                    this.pstmt.setMaxRows(this.rowlimit);
                }
                debug = "exec query";
                res = this.pstmt.executeQuery();
            } else {
                debug = "create statement";
                this.sel_stmt = this.connection.createStatement();
                if (this.canWeSetFetchSize(this.sel_stmt)) {
                    int fs;
                    debug = "Set fetchsize";
                    int n = fs = 5000 <= this.sel_stmt.getMaxRows() ? this.sel_stmt.getMaxRows() : 5000;
                    if (this.databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta && this.databaseMeta.isStreamingResults()) {
                        this.sel_stmt.setFetchSize(Integer.MIN_VALUE);
                    } else {
                        this.sel_stmt.setFetchSize(fs);
                    }
                    debug = "Set fetch direction";
                    this.sel_stmt.setFetchDirection(fetch_mode);
                }
                debug = "Set max rows";
                if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                    this.sel_stmt.setMaxRows(this.rowlimit);
                }
                debug = "exec query";
                res = this.sel_stmt.executeQuery(this.databaseMeta.stripCR(sql));
            }
            debug = "openQuery : get rowinfo";
            this.rowMeta = this.getRowInfo(res.getMetaData(), this.databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta, lazyConversion);
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("An error occurred executing SQL: " + Const.CR + sql, (Throwable)ex);
        }
        catch (Exception e) {
            this.log.logError("ERROR executing query: " + e.toString());
            this.log.logError("ERROR in part: " + debug);
            throw new KettleDatabaseException("An error occurred executing SQL in part [" + debug + "]:" + Const.CR + sql, (Throwable)e);
        }
        return res;
    }

    private boolean canWeSetFetchSize(Statement statement) throws SQLException {
        return this.databaseMeta.isFetchSizeSupported() && (statement.getMaxRows() > 0 || this.databaseMeta.getDatabaseInterface() instanceof PostgreSQLDatabaseMeta || this.databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta && this.databaseMeta.isStreamingResults());
    }

    public ResultSet openQuery(PreparedStatement ps, RowMetaInterface params, Object[] data) throws KettleDatabaseException {
        ResultSet res;
        String debug = "Start";
        try {
            debug = "OQ Set values";
            this.setValues(params, data, ps);
            if (this.canWeSetFetchSize(ps)) {
                int fs;
                debug = "OQ Set fetchsize";
                int n = fs = 5000 <= ps.getMaxRows() ? ps.getMaxRows() : 5000;
                if (this.databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta && this.databaseMeta.isStreamingResults()) {
                    ps.setFetchSize(Integer.MIN_VALUE);
                } else {
                    ps.setFetchSize(fs);
                }
                debug = "OQ Set fetch direction";
                ps.setFetchDirection(1000);
            }
            debug = "OQ Set max rows";
            if (this.rowlimit > 0 && this.databaseMeta.supportsSetMaxRows()) {
                ps.setMaxRows(this.rowlimit);
            }
            debug = "OQ exec query";
            res = ps.executeQuery();
            debug = "OQ getRowInfo()";
            this.rowMeta = this.getRowInfo(res.getMetaData(), this.databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta, false);
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("ERROR executing query in part[" + debug + "]", (Throwable)ex);
        }
        catch (Exception e) {
            throw new KettleDatabaseException("ERROR executing query in part[" + debug + "]", (Throwable)e);
        }
        return res;
    }

    public RowMetaInterface getTableFields(String tablename) throws KettleDatabaseException {
        return this.getQueryFields(this.databaseMeta.getSQLQueryFields(tablename), false);
    }

    public RowMetaInterface getQueryFields(String sql, boolean param) throws KettleDatabaseException {
        return this.getQueryFields(sql, param, null, null);
    }

    public boolean checkTableExists(String tablename) throws KettleDatabaseException {
        try {
            if (this.log.isDebug()) {
                this.log.logDebug("Checking if table [" + tablename + "] exists!");
            }
            String sql = this.databaseMeta.getSQLTableExists(tablename);
            try {
                this.getOneRow(sql);
                return true;
            }
            catch (KettleDatabaseException e) {
                return false;
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to check if table [" + tablename + "] exists on connection [" + this.databaseMeta.getName() + "]", (Throwable)e);
        }
    }

    public boolean checkColumnExists(String columnname, String tablename) throws KettleDatabaseException {
        try {
            if (this.log.isDebug()) {
                this.log.logDebug("Checking if column [" + columnname + "] exists in table [" + tablename + "] !");
            }
            String sql = this.databaseMeta.getSQLColumnExists(columnname, tablename);
            try {
                this.getOneRow(sql);
                return true;
            }
            catch (KettleDatabaseException e) {
                return false;
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to check if column [" + columnname + "] exists in table [" + tablename + "] on connection [" + this.databaseMeta.getName() + "]", (Throwable)e);
        }
    }

    public boolean checkSequenceExists(String sequenceName) throws KettleDatabaseException {
        return this.checkSequenceExists(null, sequenceName);
    }

    public boolean checkSequenceExists(String schemaName, String sequenceName) throws KettleDatabaseException {
        boolean retval = false;
        if (!this.databaseMeta.supportsSequences()) {
            return retval;
        }
        String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, sequenceName);
        try {
            String sql = this.databaseMeta.getSQLSequenceExists(schemaSequence);
            ResultSet res = this.openQuery(sql);
            if (res != null) {
                Object[] row = this.getRow(res);
                if (row != null) {
                    retval = true;
                }
                this.closeQuery(res);
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unexpected error checking whether or not sequence [" + schemaSequence + "] exists", (Throwable)e);
        }
        return retval;
    }

    public boolean checkIndexExists(String tableName, String[] idx_fields) throws KettleDatabaseException {
        return this.checkIndexExists(null, tableName, idx_fields);
    }

    public boolean checkIndexExists(String schemaName, String tableName, String[] idx_fields) throws KettleDatabaseException {
        String tablename = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        if (!this.checkTableExists(tablename)) {
            return false;
        }
        if (this.log.isDebug()) {
            this.log.logDebug("CheckIndexExists() tablename = " + tablename + " type = " + this.databaseMeta.getPluginId());
        }
        return this.databaseMeta.getDatabaseInterface().checkIndexExists(this, schemaName, tableName, idx_fields);
    }

    public String getCreateIndexStatement(String tablename, String indexname, String[] idx_fields, boolean tk, boolean unique, boolean bitmap, boolean semi_colon) {
        return this.getCreateIndexStatement(null, tablename, indexname, idx_fields, tk, unique, bitmap, semi_colon);
    }

    public String getCreateIndexStatement(String schemaname, String tablename, String indexname, String[] idx_fields, boolean tk, boolean unique, boolean bitmap, boolean semi_colon) {
        String cr_index = "";
        DatabaseInterface databaseInterface = this.databaseMeta.getDatabaseInterface();
        if (databaseInterface instanceof Exasol4DatabaseMeta) {
            return "";
        }
        cr_index = cr_index + "CREATE ";
        if (unique || tk && databaseInterface instanceof SybaseDatabaseMeta) {
            cr_index = cr_index + "UNIQUE ";
        }
        if (bitmap && this.databaseMeta.supportsBitmapIndex()) {
            cr_index = cr_index + "BITMAP ";
        }
        cr_index = cr_index + "INDEX " + this.databaseMeta.quoteField(indexname) + Const.CR + " ";
        cr_index = cr_index + "ON ";
        cr_index = cr_index + tablename;
        cr_index = cr_index + Const.CR + "( " + Const.CR;
        for (int i = 0; i < idx_fields.length; ++i) {
            cr_index = i > 0 ? cr_index + ", " : cr_index + "  ";
            cr_index = cr_index + this.databaseMeta.quoteField(idx_fields[i]) + Const.CR;
        }
        cr_index = cr_index + ")" + Const.CR;
        cr_index = cr_index + databaseInterface.getIndexTablespaceDDL(this.variables, this.databaseMeta);
        if (semi_colon) {
            cr_index = cr_index + ";" + Const.CR;
        }
        return cr_index;
    }

    public String getCreateSequenceStatement(String sequence, long start_at, long increment_by, long max_value, boolean semi_colon) {
        return this.getCreateSequenceStatement(null, sequence, Long.toString(start_at), Long.toString(increment_by), Long.toString(max_value), semi_colon);
    }

    public String getCreateSequenceStatement(String sequence, String start_at, String increment_by, String max_value, boolean semi_colon) {
        return this.getCreateSequenceStatement(null, sequence, start_at, increment_by, max_value, semi_colon);
    }

    public String getCreateSequenceStatement(String schemaName, String sequence, long start_at, long increment_by, long max_value, boolean semi_colon) {
        return this.getCreateSequenceStatement(schemaName, sequence, Long.toString(start_at), Long.toString(increment_by), Long.toString(max_value), semi_colon);
    }

    public String getCreateSequenceStatement(String schemaName, String sequenceName, String start_at, String increment_by, String max_value, boolean semi_colon) {
        String cr_seq = "";
        if (Const.isEmpty((String)sequenceName)) {
            return cr_seq;
        }
        if (this.databaseMeta.supportsSequences()) {
            String schemaSequence = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, sequenceName);
            cr_seq = cr_seq + "CREATE SEQUENCE " + schemaSequence + " " + Const.CR;
            cr_seq = cr_seq + "START WITH " + start_at + " " + Const.CR;
            cr_seq = cr_seq + "INCREMENT BY " + increment_by + " " + Const.CR;
            if (max_value != null) {
                cr_seq = this.databaseMeta.supportsSequenceNoMaxValueOption() && max_value.trim().equals("-1") ? cr_seq + "NOMAXVALUE" + Const.CR : cr_seq + "MAXVALUE " + max_value + Const.CR;
            }
            if (semi_colon) {
                cr_seq = cr_seq + ";" + Const.CR;
            }
        }
        return cr_seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowMetaInterface getQueryFields(String sql, boolean param, RowMetaInterface inform, Object[] data) throws KettleDatabaseException {
        RowMetaInterface fields;
        DBCache dbcache = DBCache.getInstance();
        DBCacheEntry entry = null;
        if (dbcache != null && (fields = dbcache.get(entry = new DBCacheEntry(this.databaseMeta.getName(), sql))) != null) {
            return fields;
        }
        if (this.connection == null) {
            return null;
        }
        if (this.databaseMeta.supportsPreparedStatementMetadataRetrieval()) {
            Statement preparedStatement = null;
            try {
                preparedStatement = this.connection.prepareStatement(this.databaseMeta.stripCR(sql), 1003, 1007);
                ResultSetMetaData rsmd = preparedStatement.getMetaData();
                fields = this.getRowInfo(rsmd, false, false);
            }
            catch (Exception e) {
                fields = this.getQueryFieldsFallback(sql, param, inform, data);
            }
            finally {
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException e) {
                        throw new KettleDatabaseException("Unable to close prepared statement after determining SQL layout", (Throwable)e);
                    }
                }
            }
        } else {
            fields = this.getQueryFieldsFallback(sql, param, inform, data);
        }
        if (dbcache != null && entry != null && fields != null) {
            dbcache.put(entry, fields);
        }
        return fields;
    }

    private RowMetaInterface getQueryFieldsFallback(String sql, boolean param, RowMetaInterface inform, Object[] data) throws KettleDatabaseException {
        RowMetaInterface fields;
        try {
            if (inform == null && this.databaseMeta.getDatabaseInterface() instanceof MSSQLServerDatabaseMeta || this.databaseMeta.getDatabaseInterface().supportsResultSetMetadataRetrievalOnly()) {
                this.sel_stmt = this.connection.createStatement(1003, 1007);
                if (this.databaseMeta.isFetchSizeSupported() && this.sel_stmt.getMaxRows() >= 1) {
                    if (this.databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta) {
                        this.sel_stmt.setFetchSize(Integer.MIN_VALUE);
                    } else {
                        this.sel_stmt.setFetchSize(1);
                    }
                }
                if (this.databaseMeta.supportsSetMaxRows()) {
                    this.sel_stmt.setMaxRows(1);
                }
                ResultSet r = this.sel_stmt.executeQuery(this.databaseMeta.stripCR(sql));
                fields = this.getRowInfo(r.getMetaData(), false, false);
                r.close();
                this.sel_stmt.close();
                this.sel_stmt = null;
            } else {
                PreparedStatement ps = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
                if (param) {
                    RowMetaInterface par = inform;
                    if (par == null || par.isEmpty()) {
                        par = this.getParameterMetaData(ps);
                    }
                    if (par == null || par.isEmpty()) {
                        par = this.getParameterMetaData(sql, inform, data);
                    }
                    this.setValues(par, data, ps);
                }
                ResultSet r = ps.executeQuery();
                fields = this.getRowInfo(ps.getMetaData(), false, false);
                r.close();
                ps.close();
            }
        }
        catch (Exception ex) {
            throw new KettleDatabaseException("Couldn't get field info from [" + sql + "]" + Const.CR, (Throwable)ex);
        }
        return fields;
    }

    public void closeQuery(ResultSet res) throws KettleDatabaseException {
        try {
            if (res != null) {
                res.close();
            }
            if (this.sel_stmt != null) {
                this.sel_stmt.close();
                this.sel_stmt = null;
            }
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Couldn't close query: resultset or prepared statements", (Throwable)ex);
        }
    }

    private RowMetaInterface getRowInfo(ResultSetMetaData rm, boolean ignoreLength, boolean lazyConversion) throws KettleDatabaseException {
        if (rm == null) {
            throw new KettleDatabaseException("No result set metadata available to retrieve row metadata!");
        }
        this.rowMeta = new RowMeta();
        try {
            int fieldNr = 1;
            int nrcols = rm.getColumnCount();
            for (int i = 1; i <= nrcols; ++i) {
                String name = this.databaseMeta.isMySQLVariant() && this.getDatabaseMetaData().getDriverMajorVersion() > 3 ? new String(rm.getColumnLabel(i)) : new String(rm.getColumnName(i));
                if (Const.isEmpty((String)name) || Const.onlySpaces((String)name)) {
                    name = "Field" + fieldNr;
                    ++fieldNr;
                }
                ValueMetaInterface v = this.getValueFromSQLType(name, rm, i, ignoreLength, lazyConversion);
                this.rowMeta.addValueMeta(v);
            }
            return this.rowMeta;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error getting row information from database: ", (Throwable)ex);
        }
    }

    private ValueMetaInterface getValueFromSQLType(String name, ResultSetMetaData rm, int index, boolean ignoreLength, boolean lazyConversion) throws SQLException {
        int length = -1;
        int precision = -1;
        int valtype = 0;
        boolean isClob = false;
        int type = rm.getColumnType(index);
        boolean signed = rm.isSigned(index);
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                valtype = 2;
                if (ignoreLength) break;
                length = rm.getColumnDisplaySize(index);
                break;
            }
            case 2005: {
                valtype = 2;
                length = 9999999;
                isClob = true;
                break;
            }
            case -5: {
                if (signed) {
                    valtype = 5;
                    precision = 0;
                    length = 15;
                    break;
                }
                valtype = 6;
                precision = 0;
                length = 16;
                break;
            }
            case 4: {
                valtype = 5;
                precision = 0;
                length = 9;
                break;
            }
            case 5: {
                valtype = 5;
                precision = 0;
                length = 4;
                break;
            }
            case -6: {
                valtype = 5;
                precision = 0;
                length = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                valtype = 1;
                length = rm.getPrecision(index);
                precision = rm.getScale(index);
                if (length >= 126) {
                    length = -1;
                }
                if (precision >= 126) {
                    precision = -1;
                }
                if (type == 8 || type == 6 || type == 7) {
                    if (precision == 0) {
                        precision = -1;
                    }
                    if (this.databaseMeta.getDatabaseInterface() instanceof PostgreSQLDatabaseMeta && type == 8 && precision >= 16 && length >= 16) {
                        precision = -1;
                        length = -1;
                    }
                    if (this.databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta && precision >= length) {
                        precision = -1;
                        length = -1;
                    }
                    if (length > 15 || precision > 15) {
                        valtype = 6;
                    }
                } else if (precision == 0) {
                    if (length <= 18 && length > 0) {
                        valtype = 5;
                    } else if (length > 18) {
                        valtype = 6;
                    }
                } else if (length > 15 || precision > 15) {
                    valtype = 6;
                }
                if ((this.databaseMeta.getDatabaseInterface() instanceof PostgreSQLDatabaseMeta || this.databaseMeta.getDatabaseInterface() instanceof GreenplumDatabaseMeta) && type == 2 && length == 0 && precision == 0) {
                    valtype = 6;
                    length = -1;
                    precision = -1;
                }
                if (!(this.databaseMeta.getDatabaseInterface() instanceof OracleDatabaseMeta)) break;
                if (precision == 0 && length == 38) {
                    valtype = 5;
                }
                if (precision > 0 || length > 0) break;
                valtype = 6;
                length = -1;
                precision = -1;
                break;
            }
            case 91: {
                if (this.databaseMeta.getDatabaseInterface() instanceof TeradataDatabaseMeta) {
                    precision = 1;
                }
            }
            case 92: 
            case 93: {
                String property;
                valtype = 3;
                if (!(this.databaseMeta.getDatabaseInterface() instanceof MySQLDatabaseMeta) || (property = this.databaseMeta.getConnectionProperties().getProperty("yearIsDateType")) == null || !property.equalsIgnoreCase("false") || !rm.getColumnTypeName(index).equalsIgnoreCase("YEAR")) break;
                valtype = 5;
                precision = 0;
                length = 4;
                break;
            }
            case -7: 
            case 16: {
                valtype = 4;
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                valtype = 8;
                if (this.databaseMeta.isDisplaySizeTwiceThePrecision() && 2 * rm.getPrecision(index) == rm.getColumnDisplaySize(index)) {
                    length = rm.getPrecision(index);
                } else if (this.databaseMeta.getDatabaseInterface() instanceof OracleDatabaseMeta && (type == -3 || type == -4)) {
                    valtype = 2;
                    length = rm.getColumnDisplaySize(index);
                } else if (this.databaseMeta.isMySQLVariant() && (type == -3 || type == -4)) {
                    valtype = 2;
                    length = -1;
                } else {
                    length = -1;
                }
                precision = -1;
                break;
            }
            default: {
                valtype = 2;
                precision = rm.getScale(index);
            }
        }
        String comments = rm.getColumnLabel(index);
        int originalColumnType = rm.getColumnType(index);
        String originalColumnTypeName = rm.getColumnTypeName(index);
        int originalPrecision = -1;
        if (!ignoreLength) {
            rm.getPrecision(index);
        }
        int originalScale = rm.getScale(index);
        boolean originalSigned = rm.isSigned(index);
        ValueMeta v = new ValueMeta(name, valtype);
        v.setLength(length);
        v.setPrecision(precision);
        v.setComments(comments);
        v.setLargeTextField(isClob);
        v.setOriginalColumnType(originalColumnType);
        v.setOriginalColumnTypeName(originalColumnTypeName);
        v.setOriginalPrecision(originalPrecision);
        v.setOriginalScale(originalScale);
        v.setOriginalSigned(originalSigned);
        if (lazyConversion && valtype == 2) {
            v.setStorageType(1);
            ValueMetaInterface storageMetaData = v.clone();
            storageMetaData.setType(2);
            storageMetaData.setStorageType(0);
            v.setStorageMetadata(storageMetaData);
        }
        return v;
    }

    public boolean absolute(ResultSet rs, int position) throws KettleDatabaseException {
        try {
            return rs.absolute(position);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move resultset to position " + position, (Throwable)e);
        }
    }

    public boolean relative(ResultSet rs, int rows) throws KettleDatabaseException {
        try {
            return rs.relative(rows);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move the resultset forward " + rows + " rows", (Throwable)e);
        }
    }

    public void afterLast(ResultSet rs) throws KettleDatabaseException {
        try {
            rs.afterLast();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move resultset to after the last position", (Throwable)e);
        }
    }

    public void first(ResultSet rs) throws KettleDatabaseException {
        try {
            rs.first();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to move resultset to the first position", (Throwable)e);
        }
    }

    public Object[] getRow(ResultSet rs) throws KettleDatabaseException {
        return this.getRow(rs, false);
    }

    public Object[] getRow(ResultSet rs, boolean lazyConversion) throws KettleDatabaseException {
        if (this.rowMeta == null) {
            ResultSetMetaData rsmd = null;
            try {
                rsmd = rs.getMetaData();
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Unable to retrieve metadata from resultset", (Throwable)e);
            }
            this.rowMeta = this.getRowInfo(rsmd, false, lazyConversion);
        }
        return this.getRow(rs, null, this.rowMeta);
    }

    public Object[] getRow(ResultSet rs, ResultSetMetaData dummy, RowMetaInterface rowInfo) throws KettleDatabaseException {
        try {
            int nrcols = rowInfo.size();
            Object[] data = RowDataUtil.allocateRowData((int)nrcols);
            if (rs.next()) {
                for (int i = 0; i < nrcols; ++i) {
                    ValueMetaInterface val = rowInfo.getValueMeta(i);
                    data[i] = this.databaseMeta.getValueFromResultSet(rs, val, i);
                }
            } else {
                data = null;
            }
            return data;
        }
        catch (Exception ex) {
            throw new KettleDatabaseException("Couldn't get row from result set", (Throwable)ex);
        }
    }

    public void printSQLException(SQLException ex) {
        this.log.logError("==> SQLException: ");
        while (ex != null) {
            this.log.logError("Message:   " + ex.getMessage());
            this.log.logError("SQLState:  " + ex.getSQLState());
            this.log.logError("ErrorCode: " + ex.getErrorCode());
            ex = ex.getNextException();
            this.log.logError("");
        }
    }

    public void setLookup(String table, String[] codes, String[] condition, String[] gets, String[] rename, String orderby) throws KettleDatabaseException {
        this.setLookup(table, codes, condition, gets, rename, orderby, false);
    }

    public void setLookup(String schema, String table, String[] codes, String[] condition, String[] gets, String[] rename, String orderby) throws KettleDatabaseException {
        this.setLookup(schema, table, codes, condition, gets, rename, orderby, false);
    }

    public void setLookup(String tableName, String[] codes, String[] condition, String[] gets, String[] rename, String orderby, boolean checkForMultipleResults) throws KettleDatabaseException {
        this.setLookup(null, tableName, codes, condition, gets, rename, orderby, checkForMultipleResults);
    }

    public void setLookup(String schemaName, String tableName, String[] codes, String[] condition, String[] gets, String[] rename, String orderby, boolean checkForMultipleResults) throws KettleDatabaseException {
        int i;
        String table = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        String sql = "SELECT ";
        for (i = 0; i < gets.length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + this.databaseMeta.quoteField(gets[i]);
            if (rename == null || rename[i] == null || gets[i].equalsIgnoreCase(rename[i])) continue;
            sql = sql + " AS " + this.databaseMeta.quoteField(rename[i]);
        }
        sql = sql + " FROM " + table + " WHERE ";
        for (i = 0; i < codes.length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + this.databaseMeta.quoteField(codes[i]);
            sql = "BETWEEN".equalsIgnoreCase(condition[i]) ? sql + " BETWEEN ? AND ? " : ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i]) ? sql + " " + condition[i] + " " : sql + " " + condition[i] + " ? ");
        }
        if (orderby != null && orderby.length() != 0) {
            sql = sql + " ORDER BY " + orderby;
        }
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed("Setting preparedStatement to [" + sql + "]");
            }
            this.prepStatementLookup = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            if (!checkForMultipleResults && this.databaseMeta.supportsSetMaxRows()) {
                this.prepStatementLookup.setMaxRows(1);
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for update [" + sql + "]", (Throwable)ex);
        }
    }

    public boolean prepareUpdate(String table, String[] codes, String[] condition, String[] sets) {
        return this.prepareUpdate(null, table, codes, condition, sets);
    }

    public boolean prepareUpdate(String schemaName, String tableName, String[] codes, String[] condition, String[] sets) {
        int i;
        StringBuffer sql = new StringBuffer(128);
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        sql.append("UPDATE ").append(schemaTable).append(Const.CR).append("SET ");
        for (i = 0; i < sets.length; ++i) {
            if (i != 0) {
                sql.append(",   ");
            }
            sql.append(this.databaseMeta.quoteField(sets[i]));
            sql.append(" = ?").append(Const.CR);
        }
        sql.append("WHERE ");
        for (i = 0; i < codes.length; ++i) {
            if (i != 0) {
                sql.append("AND   ");
            }
            sql.append(this.databaseMeta.quoteField(codes[i]));
            if ("BETWEEN".equalsIgnoreCase(condition[i])) {
                sql.append(" BETWEEN ? AND ? ");
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i])) {
                sql.append(' ').append(condition[i]).append(' ');
                continue;
            }
            sql.append(' ').append(condition[i]).append(" ? ");
        }
        try {
            String s = sql.toString();
            if (this.log.isDetailed()) {
                this.log.logDetailed("Setting update preparedStatement to [" + s + "]");
            }
            this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(s));
        }
        catch (SQLException ex) {
            this.printSQLException(ex);
            return false;
        }
        return true;
    }

    public boolean prepareDelete(String table, String[] codes, String[] condition) {
        return this.prepareDelete(null, table, codes, condition);
    }

    public boolean prepareDelete(String schemaName, String tableName, String[] codes, String[] condition) {
        String table = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        String sql = "DELETE FROM " + table + Const.CR;
        sql = sql + "WHERE ";
        for (int i = 0; i < codes.length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + codes[i];
            sql = "BETWEEN".equalsIgnoreCase(condition[i]) ? sql + " BETWEEN ? AND ? " : ("IS NULL".equalsIgnoreCase(condition[i]) || "IS NOT NULL".equalsIgnoreCase(condition[i]) ? sql + " " + condition[i] + " " : sql + " " + condition[i] + " ? ");
        }
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed("Setting update preparedStatement to [" + sql + "]");
            }
            this.prepStatementUpdate = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            this.printSQLException(ex);
            return false;
        }
        return true;
    }

    public void setProcLookup(String proc, String[] arg, String[] argdir, int[] argtype, String returnvalue, int returntype) throws KettleDatabaseException {
        int i;
        int pos = 0;
        String sql = "{ ";
        if (returnvalue != null && returnvalue.length() != 0) {
            sql = sql + "? = ";
        }
        sql = sql + "call " + proc + " ";
        if (arg.length > 0) {
            sql = sql + "(";
        }
        for (i = 0; i < arg.length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + " ?";
        }
        if (arg.length > 0) {
            sql = sql + ")";
        }
        sql = sql + "}";
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed("DBA setting callableStatement to [" + sql + "]");
            }
            this.cstmt = this.connection.prepareCall(sql);
            pos = 1;
            if (!Const.isEmpty((String)returnvalue)) {
                switch (returntype) {
                    case 1: {
                        this.cstmt.registerOutParameter(pos, 8);
                        break;
                    }
                    case 6: {
                        this.cstmt.registerOutParameter(pos, 3);
                        break;
                    }
                    case 5: {
                        this.cstmt.registerOutParameter(pos, -5);
                        break;
                    }
                    case 2: {
                        this.cstmt.registerOutParameter(pos, 12);
                        break;
                    }
                    case 3: {
                        this.cstmt.registerOutParameter(pos, 93);
                        break;
                    }
                    case 4: {
                        this.cstmt.registerOutParameter(pos, 16);
                        break;
                    }
                }
                ++pos;
            }
            block19: for (i = 0; i < arg.length; ++i) {
                if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase("INOUT")) continue;
                switch (argtype[i]) {
                    case 1: {
                        this.cstmt.registerOutParameter(i + pos, 8);
                        continue block19;
                    }
                    case 6: {
                        this.cstmt.registerOutParameter(i + pos, 3);
                        continue block19;
                    }
                    case 5: {
                        this.cstmt.registerOutParameter(i + pos, -5);
                        continue block19;
                    }
                    case 2: {
                        this.cstmt.registerOutParameter(i + pos, 12);
                        continue block19;
                    }
                    case 3: {
                        this.cstmt.registerOutParameter(i + pos, 93);
                        continue block19;
                    }
                    case 4: {
                        this.cstmt.registerOutParameter(i + pos, 16);
                        continue block19;
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare database procedure call", (Throwable)ex);
        }
    }

    public Object[] getLookup() throws KettleDatabaseException {
        return this.getLookup(this.prepStatementLookup);
    }

    public Object[] getLookup(boolean failOnMultipleResults) throws KettleDatabaseException {
        return this.getLookup(this.prepStatementLookup, failOnMultipleResults);
    }

    public Object[] getLookup(PreparedStatement ps) throws KettleDatabaseException {
        return this.getLookup(ps, false);
    }

    public Object[] getLookup(PreparedStatement ps, boolean failOnMultipleResults) throws KettleDatabaseException {
        ResultSet res = null;
        try {
            res = ps.executeQuery();
            this.rowMeta = this.getRowInfo(res.getMetaData(), false, false);
            Object[] ret = this.getRow(res);
            if (failOnMultipleResults && ret != null && res.next()) {
                throw new KettleDatabaseException("Only 1 row was expected as a result of a lookup, and at least 2 were found!");
            }
            Object[] objectArray = ret;
            return objectArray;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Error looking up row in database", (Throwable)ex);
        }
        finally {
            try {
                if (res != null) {
                    res.close();
                }
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Unable to close resultset after looking up data", (Throwable)e);
            }
        }
    }

    public DatabaseMetaData getDatabaseMetaData() throws KettleDatabaseException {
        try {
            if (this.dbmd == null) {
                this.dbmd = this.connection.getMetaData();
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to get database metadata from this database connection", (Throwable)e);
        }
        return this.dbmd;
    }

    public String getDDL(String tablename, RowMetaInterface fields) throws KettleDatabaseException {
        return this.getDDL(tablename, fields, null, false, null, true);
    }

    public String getDDL(String tablename, RowMetaInterface fields, String tk, boolean use_autoinc, String pk) throws KettleDatabaseException {
        return this.getDDL(tablename, fields, tk, use_autoinc, pk, true);
    }

    public String getDDL(String tableName, RowMetaInterface fields, String tk, boolean use_autoinc, String pk, boolean semicolon) throws KettleDatabaseException {
        this.databaseMeta.quoteReservedWords(fields);
        String quotedTk = tk != null ? this.databaseMeta.quoteField(tk) : null;
        String retval = this.checkTableExists(tableName) ? this.getAlterTableStatement(tableName, fields, quotedTk, use_autoinc, pk, semicolon) : this.getCreateTableStatement(tableName, fields, quotedTk, use_autoinc, pk, semicolon);
        return retval;
    }

    public String getCreateTableStatement(String tableName, RowMetaInterface fields, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        int i;
        StringBuilder retval = new StringBuilder("CREATE TABLE ");
        retval.append(tableName + Const.CR);
        retval.append("(").append(Const.CR);
        for (i = 0; i < fields.size(); ++i) {
            if (i > 0) {
                retval.append(", ");
            } else {
                retval.append("  ");
            }
            ValueMetaInterface v = fields.getValueMeta(i);
            retval.append(this.databaseMeta.getFieldDefinition(v, tk, pk, use_autoinc));
        }
        if (tk != null && this.databaseMeta.requiresCreateTablePrimaryKeyAppend()) {
            retval.append(", PRIMARY KEY (").append(tk).append(")").append(Const.CR);
        }
        if (pk != null && this.databaseMeta.requiresCreateTablePrimaryKeyAppend()) {
            retval.append(", PRIMARY KEY (").append(pk).append(")").append(Const.CR);
        }
        retval.append(")").append(Const.CR);
        retval.append(this.databaseMeta.getDatabaseInterface().getDataTablespaceDDL(this.variables, this.databaseMeta));
        if (pk == null && tk == null && this.databaseMeta.getDatabaseInterface() instanceof NeoviewDatabaseMeta) {
            retval.append("NO PARTITION");
        }
        if (semicolon) {
            retval.append(";");
        }
        if (this.databaseMeta.getDatabaseInterface() instanceof VerticaDatabaseMeta) {
            retval.append(Const.CR).append("CREATE PROJECTION ").append(tableName).append("_unseg_super").append(Const.CR);
            retval.append("(").append(Const.CR);
            for (i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    retval.append(", ");
                } else {
                    retval.append("  ");
                }
                retval.append(fields.getValueMeta(i).getName()).append(Const.CR);
            }
            retval.append(")").append(Const.CR);
            retval.append("AS SELECT").append(Const.CR);
            for (i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    retval.append(", ");
                } else {
                    retval.append("  ");
                }
                retval.append(fields.getValueMeta(i).getName()).append(Const.CR);
            }
            retval.append("FROM ").append(tableName).append(Const.CR);
            retval.append("-- Replace UNSEGMENTED with a hash segmentation for optimum performance").append(Const.CR);
            retval.append("--SEGMENTED BY HASH(X,Y,Z)").append(Const.CR);
            retval.append("UNSEGMENTED ALL NODES").append(Const.CR);
            retval.append(";");
        }
        return retval.toString();
    }

    public String getAlterTableStatement(String tableName, RowMetaInterface fields, String tk, boolean use_autoinc, String pk, boolean semicolon) throws KettleDatabaseException {
        int i;
        ValueMetaInterface v;
        int i2;
        ValueMetaInterface v2;
        int i3;
        String retval = "";
        RowMetaInterface tabFields = this.getTableFields(tableName);
        this.databaseMeta.quoteReservedWords(tabFields);
        RowMeta missing = new RowMeta();
        for (i3 = 0; i3 < fields.size(); ++i3) {
            v2 = fields.getValueMeta(i3);
            if (tabFields.searchValueMeta(v2.getName()) != null) continue;
            missing.addValueMeta(v2);
        }
        if (missing.size() != 0) {
            for (i3 = 0; i3 < missing.size(); ++i3) {
                v2 = missing.getValueMeta(i3);
                retval = retval + this.databaseMeta.getAddColumnStatement(tableName, v2, tk, use_autoinc, pk, true);
            }
        }
        RowMeta surplus = new RowMeta();
        for (i2 = 0; i2 < tabFields.size(); ++i2) {
            v = tabFields.getValueMeta(i2);
            if (fields.searchValueMeta(v.getName()) != null) continue;
            surplus.addValueMeta(v);
        }
        if (surplus.size() != 0) {
            for (i2 = 0; i2 < surplus.size(); ++i2) {
                v = surplus.getValueMeta(i2);
                retval = retval + this.databaseMeta.getDropColumnStatement(tableName, v, tk, use_autoinc, pk, true);
            }
        }
        RowMeta modify = new RowMeta();
        for (i = 0; i < fields.size(); ++i) {
            String currentDDL;
            boolean mod;
            ValueMetaInterface desiredField = fields.getValueMeta(i);
            ValueMetaInterface currentField = tabFields.searchValueMeta(desiredField.getName());
            if (desiredField == null || currentField == null) continue;
            String desiredDDL = this.databaseMeta.getFieldDefinition(desiredField, tk, pk, use_autoinc);
            boolean bl = mod = !desiredDDL.equalsIgnoreCase(currentDDL = this.databaseMeta.getFieldDefinition(currentField, tk, pk, use_autoinc));
            if (!mod) continue;
            modify.addValueMeta(desiredField);
        }
        if (modify.size() > 0) {
            for (i = 0; i < modify.size(); ++i) {
                ValueMetaInterface v3 = modify.getValueMeta(i);
                retval = retval + this.databaseMeta.getModifyColumnStatement(tableName, v3, tk, use_autoinc, pk, true);
            }
        }
        return retval;
    }

    public void truncateTable(String tablename) throws KettleDatabaseException {
        if (Const.isEmpty((String)this.connectionGroup)) {
            this.execStatement(this.databaseMeta.getTruncateTableStatement(null, tablename));
        } else {
            this.execStatement("DELETE FROM " + this.databaseMeta.quoteField(tablename));
        }
    }

    public void truncateTable(String schema, String tablename) throws KettleDatabaseException {
        if (Const.isEmpty((String)this.connectionGroup)) {
            this.execStatement(this.databaseMeta.getTruncateTableStatement(schema, tablename));
        } else {
            this.execStatement("DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(schema, tablename));
        }
    }

    public RowMetaAndData getOneRow(String sql) throws KettleDatabaseException {
        ResultSet rs = this.openQuery(sql);
        if (rs != null) {
            Object[] row = this.getRow(rs);
            try {
                rs.close();
            }
            catch (Exception e) {
                throw new KettleDatabaseException("Unable to close resultset", (Throwable)e);
            }
            if (this.pstmt != null) {
                try {
                    this.pstmt.close();
                }
                catch (Exception e) {
                    throw new KettleDatabaseException("Unable to close prepared statement pstmt", (Throwable)e);
                }
                this.pstmt = null;
            }
            if (this.sel_stmt != null) {
                try {
                    this.sel_stmt.close();
                }
                catch (Exception e) {
                    throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", (Throwable)e);
                }
                this.sel_stmt = null;
            }
            return new RowMetaAndData(this.rowMeta, row);
        }
        throw new KettleDatabaseException("error opening resultset for query: " + sql);
    }

    public RowMeta getMetaFromRow(Object[] row, ResultSetMetaData md) throws SQLException {
        RowMeta meta = new RowMeta();
        for (int i = 0; i < md.getColumnCount(); ++i) {
            String name = md.getColumnName(i + 1);
            ValueMetaInterface valueMeta = this.getValueFromSQLType(name, md, i + 1, true, false);
            meta.addValueMeta(valueMeta);
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RowMetaAndData getOneRow(String sql, RowMetaInterface param, Object[] data) throws KettleDatabaseException {
        RowMeta tmpMeta;
        Object[] row;
        block22: {
            ResultSet rs = this.openQuery(sql, param, data);
            if (rs == null) return null;
            row = this.getRow(rs);
            this.rowMeta = null;
            tmpMeta = null;
            try {
                try {
                    ResultSetMetaData md = rs.getMetaData();
                    tmpMeta = this.getMetaFromRow(row, md);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Object var9_10 = null;
                    try {
                        rs.close();
                    }
                    catch (Exception e2) {
                        throw new KettleDatabaseException("Unable to close resultset", (Throwable)e2);
                    }
                    if (this.pstmt != null) {
                        try {
                            this.pstmt.close();
                        }
                        catch (Exception e3) {
                            throw new KettleDatabaseException("Unable to close prepared statement pstmt", (Throwable)e3);
                        }
                        this.pstmt = null;
                    }
                    if (this.sel_stmt == null) return new RowMetaAndData((RowMetaInterface)tmpMeta, row);
                    try {
                        this.sel_stmt.close();
                    }
                    catch (Exception e4) {
                        throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", (Throwable)e4);
                    }
                    this.sel_stmt = null;
                    return new RowMetaAndData((RowMetaInterface)tmpMeta, row);
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                block21: {
                    Object var9_11 = null;
                    try {}
                    catch (Exception e2) {
                        throw new KettleDatabaseException("Unable to close resultset", (Throwable)e2);
                    }
                    rs.close();
                    if (this.pstmt == null) break block21;
                    try {}
                    catch (Exception e3) {
                        throw new KettleDatabaseException("Unable to close prepared statement pstmt", (Throwable)e3);
                    }
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.sel_stmt == null) throw throwable;
                try {}
                catch (Exception e4) {
                    throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", (Throwable)e4);
                }
                this.sel_stmt.close();
                this.sel_stmt = null;
                throw throwable;
            }
            try {}
            catch (Exception e2) {
                throw new KettleDatabaseException("Unable to close resultset", (Throwable)e2);
            }
            rs.close();
            if (this.pstmt == null) break block22;
            try {}
            catch (Exception e3) {
                throw new KettleDatabaseException("Unable to close prepared statement pstmt", (Throwable)e3);
            }
            this.pstmt.close();
            this.pstmt = null;
        }
        if (this.sel_stmt == null) return new RowMetaAndData((RowMetaInterface)tmpMeta, row);
        try {}
        catch (Exception e4) {
            throw new KettleDatabaseException("Unable to close prepared statement sel_stmt", (Throwable)e4);
        }
        this.sel_stmt.close();
        this.sel_stmt = null;
        return new RowMetaAndData((RowMetaInterface)tmpMeta, row);
    }

    public RowMetaInterface getParameterMetaData(PreparedStatement ps) {
        RowMeta par = new RowMeta();
        try {
            ParameterMetaData pmd = ps.getParameterMetaData();
            for (int i = 1; i <= pmd.getParameterCount(); ++i) {
                ValueMeta val;
                String name = "par" + i;
                int sqltype = pmd.getParameterType(i);
                int length = pmd.getPrecision(i);
                int precision = pmd.getScale(i);
                switch (sqltype) {
                    case 1: 
                    case 12: {
                        val = new ValueMeta(name, 2);
                        break;
                    }
                    case -6: 
                    case -5: 
                    case 2: 
                    case 4: 
                    case 5: {
                        val = new ValueMeta(name, 5);
                        break;
                    }
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        val = new ValueMeta(name, 1);
                        break;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        val = new ValueMeta(name, 3);
                        break;
                    }
                    case -7: 
                    case 16: {
                        val = new ValueMeta(name, 4);
                        break;
                    }
                    default: {
                        val = new ValueMeta(name, 0);
                    }
                }
                if (val.isNumeric() && (length > 18 || precision > 18)) {
                    val = new ValueMeta(name, 6);
                }
                par.addValueMeta((ValueMetaInterface)val);
            }
        }
        catch (AbstractMethodError e) {
            return null;
        }
        catch (SQLException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
        return par;
    }

    public int countParameters(String sql) {
        int q = 0;
        boolean quote_opened = false;
        boolean dquote_opened = false;
        block5: for (int x = 0; x < sql.length(); ++x) {
            char c = sql.charAt(x);
            switch (c) {
                case '\'': {
                    quote_opened = !quote_opened;
                    continue block5;
                }
                case '\"': {
                    dquote_opened = !dquote_opened;
                    continue block5;
                }
                case '?': {
                    if (quote_opened || dquote_opened) continue block5;
                    ++q;
                }
            }
        }
        return q;
    }

    public RowMetaInterface getParameterMetaData(String sql, RowMetaInterface inform, Object[] data) {
        int q = this.countParameters(sql);
        RowMeta par = new RowMeta();
        if (inform != null && q == inform.size()) {
            for (int i = 0; i < q; ++i) {
                ValueMetaInterface inf = inform.getValueMeta(i);
                ValueMetaInterface v = inf.clone();
                par.addValueMeta(v);
            }
        } else {
            for (int i = 0; i < q; ++i) {
                ValueMeta v = new ValueMeta("name" + i, 1);
                par.addValueMeta((ValueMetaInterface)v);
            }
        }
        return par;
    }

    public void writeLogRecord(LogTableInterface logTable, LogStatus status, Object subject, Object parent) throws KettleException {
        try {
            RowMetaAndData logRecord = logTable.getLogRecord(status, subject, parent);
            if (logRecord == null) {
                return;
            }
            boolean update = logTable.getKeyField() != null && !status.equals(LogStatus.START);
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.environmentSubstitute(logTable.getActualSchemaName()), this.environmentSubstitute(logTable.getActualTableName()));
            RowMetaInterface rowMeta = logRecord.getRowMeta();
            Object[] rowData = logRecord.getData();
            if (update) {
                RowMeta updateRowMeta = new RowMeta();
                Object[] updateRowData = new Object[rowMeta.size()];
                ValueMetaInterface keyValueMeta = rowMeta.getValueMeta(0);
                StringBuffer sqlBuff = new StringBuffer(250);
                sqlBuff.append("UPDATE ").append(schemaTable).append(" SET ");
                for (int i = 1; i < rowMeta.size(); ++i) {
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(i);
                    if (i > 1) {
                        sqlBuff.append(", ");
                    }
                    sqlBuff.append(this.databaseMeta.quoteField(valueMeta.getName())).append("=? ");
                    updateRowMeta.addValueMeta(valueMeta);
                    updateRowData[i - 1] = rowData[i];
                }
                sqlBuff.append("WHERE ").append(this.databaseMeta.quoteField(keyValueMeta.getName())).append("=? ");
                updateRowMeta.addValueMeta(keyValueMeta);
                updateRowData[rowMeta.size() - 1] = rowData[0];
                String sql = sqlBuff.toString();
                this.execStatement(sql, (RowMetaInterface)updateRowMeta, updateRowData);
            } else {
                this.insertRow(this.environmentSubstitute(logTable.getActualSchemaName()), this.environmentSubstitute(logTable.getActualTableName()), logRecord.getRowMeta(), logRecord.getData());
            }
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to write log record to log table " + logTable.getActualTableName(), (Throwable)e);
        }
    }

    public void cleanupLogRecords(LogTableInterface logTable) throws KettleException {
        block3: {
            try {
                double timeout = Const.toDouble((String)Const.trim((String)this.environmentSubstitute(logTable.getTimeoutInDays())), (double)0.0);
                if (!(timeout > 1.0E-6)) break block3;
                String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(this.environmentSubstitute(logTable.getActualSchemaName()), this.environmentSubstitute(logTable.getActualTableName()));
                LogTableField logField = logTable.getLogDateField();
                if (logField != null) {
                    String sql = "DELETE FROM " + schemaTable + " WHERE " + this.databaseMeta.quoteField(logField.getFieldName()) + " < ?";
                    long now = System.currentTimeMillis();
                    long limit = now - Math.round(timeout * 24.0 * 60.0 * 60.0 * 1000.0);
                    RowMetaAndData row = new RowMetaAndData();
                    row.addValue(logField.getFieldName(), 3, (Object)new java.util.Date(limit));
                    this.execStatement(sql, row.getRowMeta(), row.getData());
                    break block3;
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"Database.Exception.LogTimeoutDefinedOnTableWithoutLogField", (String[])new String[]{logTable.getActualTableName()}));
            }
            catch (Exception e) {
                throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.Exception.UnableToCleanUpOlderRecordsFromLogTable", (String[])new String[]{logTable.getActualTableName()}), (Throwable)e);
            }
        }
    }

    public Object[] getLastLogDate(String logtable, String name, boolean job, LogStatus status) throws KettleDatabaseException {
        Object[] row = null;
        String jobtrans = job ? this.databaseMeta.quoteField("JOBNAME") : this.databaseMeta.quoteField("TRANSNAME");
        String sql = "";
        sql = sql + " SELECT " + this.databaseMeta.quoteField("ENDDATE") + ", " + this.databaseMeta.quoteField("DEPDATE") + ", " + this.databaseMeta.quoteField("STARTDATE");
        sql = sql + " FROM " + logtable;
        sql = sql + " WHERE  " + this.databaseMeta.quoteField("ERRORS") + "    = 0";
        sql = sql + " AND    " + this.databaseMeta.quoteField("STATUS") + "    = 'end'";
        sql = sql + " AND    " + jobtrans + " = ?";
        sql = sql + " ORDER BY " + this.databaseMeta.quoteField("LOGDATE") + " DESC, " + this.databaseMeta.quoteField("ENDDATE") + " DESC";
        try {
            this.pstmt = this.connection.prepareStatement(this.databaseMeta.stripCR(sql));
            RowMeta r = new RowMeta();
            r.addValueMeta((ValueMetaInterface)new ValueMeta("TRANSNAME", 2));
            this.setValues((RowMetaInterface)r, new Object[]{name});
            ResultSet res = this.pstmt.executeQuery();
            if (res != null) {
                this.rowMeta = this.getRowInfo(res.getMetaData(), false, false);
                row = this.getRow(res);
                res.close();
            }
            this.pstmt.close();
            this.pstmt = null;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to obtain last logdate from table " + logtable, (Throwable)ex);
        }
        return row;
    }

    public synchronized Long getNextValue(Hashtable<String, Counter> counters, String tableName, String val_key) throws KettleDatabaseException {
        return this.getNextValue(counters, null, tableName, val_key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Long getNextValue(Hashtable<String, Counter> counters, String schemaName, String tableName, String val_key) throws KettleDatabaseException {
        long previous;
        Long nextValue = null;
        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
        String lookup = schemaTable + "." + this.databaseMeta.quoteField(val_key);
        Counter counter = null;
        if (counters != null) {
            counter = counters.get(lookup);
        }
        if (counter != null) return counter.next();
        RowMetaAndData rmad = this.getOneRow("SELECT MAX(" + this.databaseMeta.quoteField(val_key) + ") FROM " + schemaTable);
        if (rmad == null) throw new KettleDatabaseException("Couldn't find maximum key value from table " + schemaTable);
        try {
            Long tmp = rmad.getRowMeta().getInteger(rmad.getData(), 0);
            previous = tmp != null ? tmp : 0L;
        }
        catch (KettleValueException e) {
            throw new KettleDatabaseException("Error getting the first long value from the max value returned from table : " + schemaTable);
        }
        counter = new Counter(previous + 1L, 1L);
        nextValue = counter.next();
        if (counters == null) return nextValue;
        counters.put(lookup, counter);
        return nextValue;
    }

    public String toString() {
        if (this.databaseMeta != null) {
            return this.databaseMeta.getName();
        }
        return "-";
    }

    public boolean isSystemTable(String table_name) {
        return this.databaseMeta.isSystemTable(table_name);
    }

    public List<Object[]> getRows(String sql, int limit) throws KettleDatabaseException {
        return this.getRows(sql, limit, null);
    }

    public List<Object[]> getRows(String sql, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        if (monitor != null) {
            monitor.setTaskName("Opening query...");
        }
        ResultSet rset = this.openQuery(sql);
        return this.getRows(rset, limit, monitor);
    }

    public List<Object[]> getRows(ResultSet rset, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        try {
            ArrayList<Object[]> result = new ArrayList<Object[]>();
            boolean stop = false;
            int i = 0;
            if (rset != null) {
                if (monitor != null && limit > 0) {
                    monitor.beginTask("Reading rows...", limit);
                }
                while (!(limit > 0 && i >= limit || stop)) {
                    Object[] row = this.getRow(rset);
                    if (row != null) {
                        result.add(row);
                        ++i;
                    } else {
                        stop = true;
                    }
                    if (monitor != null && limit > 0) {
                        monitor.worked(1);
                    }
                    if (monitor == null || !monitor.isCanceled()) continue;
                    break;
                }
                this.closeQuery(rset);
                if (monitor != null) {
                    monitor.done();
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to get list of rows from ResultSet : ", (Throwable)e);
        }
    }

    public List<Object[]> getFirstRows(String table_name, int limit) throws KettleDatabaseException {
        return this.getFirstRows(table_name, limit, null);
    }

    public List<Object[]> getFirstRows(String table_name, int limit, ProgressMonitorListener monitor) throws KettleDatabaseException {
        String sql = "SELECT";
        if (this.databaseMeta.getDatabaseInterface() instanceof NeoviewDatabaseMeta) {
            sql = sql + " [FIRST " + limit + "]";
        } else if (this.databaseMeta.getDatabaseInterface() instanceof SybaseIQDatabaseMeta) {
            sql = sql + " TOP " + limit + " ";
        }
        sql = sql + " * FROM " + table_name;
        if (limit > 0) {
            sql = sql + this.databaseMeta.getLimitClause(limit);
        }
        return this.getRows(sql, limit, monitor);
    }

    public RowMetaInterface getReturnRowMeta() {
        return this.rowMeta;
    }

    public String[] getTableTypes() throws KettleDatabaseException {
        try {
            ArrayList<String> types = new ArrayList<String>();
            ResultSet rstt = this.getDatabaseMetaData().getTableTypes();
            while (rstt.next()) {
                String ttype = rstt.getString("TABLE_TYPE");
                types.add(ttype);
            }
            return types.toArray(new String[types.size()]);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException("Unable to get table types from database!", (Throwable)e);
        }
    }

    public String[] getTablenames() throws KettleDatabaseException {
        return this.getTablenames(false);
    }

    public String[] getTablenames(boolean includeSchema) throws KettleDatabaseException {
        return this.getTablenames(null, includeSchema);
    }

    public String[] getTablenames(String schemanamein, boolean includeSchema) throws KettleDatabaseException {
        Map<String, Collection<String>> tableMap = this.getTableMap(schemanamein);
        ArrayList<String> res = new ArrayList<String>();
        for (String schema : tableMap.keySet()) {
            Collection<String> tables = tableMap.get(schema);
            for (String table : tables) {
                if (includeSchema) {
                    res.add(this.databaseMeta.getQuotedSchemaTableCombination(schema, table));
                    continue;
                }
                res.add(table);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public Map<String, Collection<String>> getTableMap() throws KettleDatabaseException {
        return this.getTableMap(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Collection<String>> getTableMap(String schemanamein) throws KettleDatabaseException {
        String schemaname = schemanamein;
        if (schemaname == null && this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.environmentSubstitute(this.databaseMeta.getUsername()).toUpperCase();
        }
        HashMap<String, Collection<String>> tableMap = new HashMap<String, Collection<String>>();
        ResultSet alltables = null;
        try {
            try {
                alltables = this.getDatabaseMetaData().getTables(null, schemaname, null, this.databaseMeta.getTableTypes());
                while (alltables.next()) {
                    String schema;
                    String cat;
                    block19: {
                        block18: {
                            cat = "";
                            try {
                                cat = alltables.getString("TABLE_CAT");
                            }
                            catch (Exception e) {
                                if (!this.log.isDebug()) break block18;
                                this.log.logDebug("Error getting tables for field TABLE_CAT (ignored): " + e.toString());
                            }
                        }
                        schema = "";
                        try {
                            schema = alltables.getString("TABLE_SCHEM");
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block19;
                            this.log.logDebug("Error getting tables for field TABLE_SCHEM (ignored): " + e.toString());
                        }
                    }
                    if (Const.isEmpty((String)schema)) {
                        schema = cat;
                    }
                    String table = alltables.getString("TABLE_NAME");
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel(this.toString(), new Object[]{"got table from meta-data: " + this.databaseMeta.getQuotedSchemaTableCombination(schema, table)});
                    }
                    this.multimapPut(schema, table, tableMap);
                }
                Object var9_11 = null;
            }
            catch (SQLException e) {
                this.log.logError("Error getting tablenames from schema [" + schemaname + "]");
                Object var9_12 = null;
                try {
                    if (alltables != null) {
                        alltables.close();
                    }
                }
                catch (SQLException e2) {
                    throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            try {}
            catch (SQLException e2) {
                throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e2);
            }
            if (alltables == null) throw throwable;
            alltables.close();
            throw throwable;
        }
        try {}
        catch (SQLException e2) {
            throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e2);
        }
        if (alltables != null) {
            alltables.close();
        }
        if (!this.log.isDetailed()) return tableMap;
        this.log.logDetailed("read :" + this.multimapSize(tableMap) + " table names from db meta-data.");
        return tableMap;
    }

    public String[] getViews() throws KettleDatabaseException {
        return this.getViews(false);
    }

    public String[] getViews(boolean includeSchema) throws KettleDatabaseException {
        return this.getViews(null, includeSchema);
    }

    public String[] getViews(String schemanamein, boolean includeSchema) throws KettleDatabaseException {
        Map<String, Collection<String>> viewMap = this.getViewMap(schemanamein);
        ArrayList<String> res = new ArrayList<String>();
        for (String schema : viewMap.keySet()) {
            Collection<String> views = viewMap.get(schema);
            for (String view : views) {
                if (includeSchema) {
                    res.add(this.databaseMeta.getQuotedSchemaTableCombination(schema, view));
                    continue;
                }
                res.add(view);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public Map<String, Collection<String>> getViewMap() throws KettleDatabaseException {
        return this.getViewMap(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Collection<String>> getViewMap(String schemanamein) throws KettleDatabaseException {
        if (!this.databaseMeta.supportsViews()) {
            return Collections.emptyMap();
        }
        String schemaname = schemanamein;
        if (schemaname == null && this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.environmentSubstitute(this.databaseMeta.getUsername()).toUpperCase();
        }
        HashMap<String, Collection<String>> viewMap = new HashMap<String, Collection<String>>();
        ResultSet allviews = null;
        try {
            try {
                allviews = this.getDatabaseMetaData().getTables(null, schemaname, null, this.databaseMeta.getViewTypes());
                while (allviews.next()) {
                    String schema;
                    String cat;
                    block18: {
                        block17: {
                            cat = "";
                            try {
                                cat = allviews.getString("TABLE_CAT");
                            }
                            catch (Exception e) {
                                if (!this.log.isDebug()) break block17;
                                this.log.logDebug("Error getting views for field TABLE_CAT (ignored): " + e.toString());
                            }
                        }
                        schema = "";
                        try {
                            schema = allviews.getString("TABLE_SCHEM");
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block18;
                            this.log.logDebug("Error getting views for field TABLE_SCHEM (ignored): " + e.toString());
                        }
                    }
                    if (Const.isEmpty((String)schema)) {
                        schema = cat;
                    }
                    String table = allviews.getString("TABLE_NAME");
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel(this.toString(), new Object[]{"got view from meta-data: " + this.databaseMeta.getQuotedSchemaTableCombination(schema, table)});
                    }
                    this.multimapPut(schema, table, viewMap);
                }
                Object var9_11 = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error getting views from schema [" + schemaname + "]", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (allviews == null) throw throwable;
                allviews.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new KettleDatabaseException("Error closing resultset after getting views from schema [" + schemaname + "]", (Throwable)e);
        }
        if (allviews != null) {
            allviews.close();
        }
        if (!this.log.isDetailed()) return viewMap;
        this.log.logDetailed("read :" + this.multimapSize(viewMap) + " views from db meta-data.");
        return viewMap;
    }

    public String[] getSynonyms() throws KettleDatabaseException {
        return this.getSynonyms(false);
    }

    public String[] getSynonyms(boolean includeSchema) throws KettleDatabaseException {
        return this.getSynonyms(null, includeSchema);
    }

    public String[] getSynonyms(String schemanamein, boolean includeSchema) throws KettleDatabaseException {
        Map<String, Collection<String>> synonymMap = this.getSynonymMap(schemanamein);
        ArrayList<String> res = new ArrayList<String>();
        for (String schema : synonymMap.keySet()) {
            Collection<String> synonyms = synonymMap.get(schema);
            for (String synonym : synonyms) {
                if (includeSchema) {
                    res.add(this.databaseMeta.getQuotedSchemaTableCombination(schema, synonym));
                    continue;
                }
                res.add(synonym);
            }
        }
        return res.toArray(new String[res.size()]);
    }

    public Map<String, Collection<String>> getSynonymMap() throws KettleDatabaseException {
        return this.getSynonymMap(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Collection<String>> getSynonymMap(String schemanamein) throws KettleDatabaseException {
        if (!this.databaseMeta.supportsSynonyms()) {
            return Collections.emptyMap();
        }
        String schemaname = schemanamein;
        if (schemaname == null && this.databaseMeta.useSchemaNameForTableList()) {
            schemaname = this.environmentSubstitute(this.databaseMeta.getUsername()).toUpperCase();
        }
        HashMap<String, Collection<String>> synonymMap = new HashMap<String, Collection<String>>();
        ResultSet alltables = null;
        try {
            try {
                alltables = this.getDatabaseMetaData().getTables(null, schemaname, null, this.databaseMeta.getSynonymTypes());
                while (alltables.next()) {
                    String schema;
                    String cat;
                    block18: {
                        block17: {
                            cat = "";
                            try {
                                cat = alltables.getString("TABLE_CAT");
                            }
                            catch (Exception e) {
                                if (!this.log.isDebug()) break block17;
                                this.log.logDebug("Error getting synonyms for field TABLE_CAT (ignored): " + e.toString());
                            }
                        }
                        schema = "";
                        try {
                            schema = alltables.getString("TABLE_SCHEM");
                        }
                        catch (Exception e) {
                            if (!this.log.isDebug()) break block18;
                            this.log.logDebug("Error getting synonyms for field TABLE_SCHEM (ignored): " + e.toString());
                        }
                    }
                    if (Const.isEmpty((String)schema)) {
                        schema = cat;
                    }
                    String table = alltables.getString("TABLE_NAME");
                    if (this.log.isRowLevel()) {
                        this.log.logRowlevel(this.toString(), new Object[]{"got synonym from meta-data: " + this.databaseMeta.getQuotedSchemaTableCombination(schema, table)});
                    }
                    this.multimapPut(schema, table, synonymMap);
                }
                Object var9_11 = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error getting synonyms from schema [" + schemaname + "]", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (alltables == null) throw throwable;
                alltables.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting synonyms from schema [" + schemaname + "]", (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new KettleDatabaseException("Error closing resultset after getting synonyms from schema [" + schemaname + "]", (Throwable)e);
        }
        if (alltables != null) {
            alltables.close();
        }
        if (!this.log.isDetailed()) return synonymMap;
        this.log.logDetailed("read :" + this.multimapSize(synonymMap) + " synonyms from db meta-data.");
        return synonymMap;
    }

    private <K, V> void multimapPut(K key, V value, Map<K, Collection<V>> map) {
        Collection<V> valueCollection = map.get(key);
        if (valueCollection == null) {
            valueCollection = new HashSet<V>();
        }
        valueCollection.add(value);
        map.put(key, valueCollection);
    }

    private <K, V> int multimapSize(Map<K, Collection<V>> map) {
        int count = 0;
        for (Collection<V> valueCollection : map.values()) {
            count += valueCollection.size();
        }
        return count;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getSchemas() throws KettleDatabaseException {
        ArrayList<String> catalogList = new ArrayList<String>();
        ResultSet catalogResultSet = null;
        try {
            try {
                catalogResultSet = this.getDatabaseMetaData().getSchemas();
                while (catalogResultSet != null && catalogResultSet.next()) {
                    catalogList.add(catalogResultSet.getString(1));
                }
                Object var5_3 = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error getting schemas!", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (catalogResultSet == null) throw throwable;
                catalogResultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting schemas!", (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new KettleDatabaseException("Error closing resultset after getting schemas!", (Throwable)e);
        }
        if (catalogResultSet != null) {
            catalogResultSet.close();
        }
        if (!this.log.isDetailed()) return catalogList.toArray(new String[catalogList.size()]);
        this.log.logDetailed("read :" + catalogList.size() + " schemas from db meta-data.");
        return catalogList.toArray(new String[catalogList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getCatalogs() throws KettleDatabaseException {
        ArrayList<String> catalogList = new ArrayList<String>();
        ResultSet catalogResultSet = null;
        try {
            try {
                catalogResultSet = this.getDatabaseMetaData().getCatalogs();
                while (catalogResultSet != null && catalogResultSet.next()) {
                    catalogList.add(catalogResultSet.getString(1));
                }
                Object var5_3 = null;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error getting catalogs!", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            try {
                if (catalogResultSet == null) throw throwable;
                catalogResultSet.close();
                throw throwable;
            }
            catch (SQLException e) {
                throw new KettleDatabaseException("Error closing resultset after getting catalogs!", (Throwable)e);
            }
        }
        try {}
        catch (SQLException e) {
            throw new KettleDatabaseException("Error closing resultset after getting catalogs!", (Throwable)e);
        }
        if (catalogResultSet != null) {
            catalogResultSet.close();
        }
        if (!this.log.isDetailed()) return catalogList.toArray(new String[catalogList.size()]);
        this.log.logDetailed("read :" + catalogList.size() + " catalogs from db meta-data.");
        return catalogList.toArray(new String[catalogList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getProcedures() throws KettleDatabaseException {
        String[] stringArray;
        String sql = this.databaseMeta.getSQLListOfProcedures();
        if (sql != null) {
            List<Object[]> procs = this.getRows(sql, 1000);
            String[] str = new String[procs.size()];
            int i = 0;
            while (i < procs.size()) {
                str[i] = procs.get(i)[0].toString();
                ++i;
            }
            return str;
        }
        ResultSet rs = null;
        try {
            try {
                DatabaseMetaData dbmd = this.getDatabaseMetaData();
                rs = dbmd.getProcedures(null, null, null);
                List<Object[]> rows = this.getRows(rs, 0, null);
                String[] result = new String[rows.size()];
                for (int i = 0; i < rows.size(); ++i) {
                    Object[] row = rows.get(i);
                    String procCatalog = this.rowMeta.getString(row, "PROCEDURE_CAT", null);
                    String procSchema = this.rowMeta.getString(row, "PROCEDURE_SCHEMA", null);
                    String procName = this.rowMeta.getString(row, "PROCEDURE_NAME", "");
                    String name = "";
                    if (procCatalog != null) {
                        name = name + procCatalog + ".";
                    } else if (procSchema != null) {
                        name = name + procSchema + ".";
                    }
                    result[i] = name = name + procName;
                }
                stringArray = result;
                Object var13_17 = null;
                if (rs == null) return stringArray;
            }
            catch (Exception e) {
                throw new KettleDatabaseException("Unable to get list of procedures from database meta-data: ", (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (Exception e2) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            // empty catch block
            return stringArray;
        }
        rs.close();
        return stringArray;
    }

    public boolean isAutoCommit() {
        return this.commitsize <= 0;
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void lockTables(String[] tableNames) throws KettleDatabaseException {
        if (Const.isEmpty((String[])tableNames)) {
            return;
        }
        String sql = this.databaseMeta.getSQLLockTables(tableNames);
        if (sql != null) {
            this.execStatements(sql);
        }
    }

    public void unlockTables(String[] tableNames) throws KettleDatabaseException {
        if (Const.isEmpty((String[])tableNames)) {
            return;
        }
        String[] quotedTableNames = new String[tableNames.length];
        for (int i = 0; i < tableNames.length; ++i) {
            quotedTableNames[i] = this.databaseMeta.getQuotedSchemaTableCombination(null, tableNames[i]);
        }
        String sql = this.databaseMeta.getSQLUnlockTables(quotedTableNames);
        if (sql != null) {
            this.execStatement(sql);
        }
    }

    public int getOpened() {
        return this.opened;
    }

    public void setOpened(int opened) {
        this.opened = opened;
    }

    public String getConnectionGroup() {
        return this.connectionGroup;
    }

    public void setConnectionGroup(String connectionGroup) {
        this.connectionGroup = connectionGroup;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }

    public int getCopy() {
        return this.copy;
    }

    public void setCopy(int copy) {
        this.copy = copy;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
        if (space != this.databaseMeta) {
            this.databaseMeta.shareVariablesWith(space);
        }
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowMetaAndData callProcedure(String[] arg, String[] argdir, int[] argtype, String resultname, int resulttype) throws KettleDatabaseException {
        try {
            boolean moreResults = this.cstmt.execute();
            RowMetaAndData ret = new RowMetaAndData();
            int pos = 1;
            if (resultname != null && resultname.length() != 0) {
                ValueMeta vMeta = new ValueMeta(resultname, resulttype);
                Object v = null;
                switch (resulttype) {
                    case 4: {
                        v = this.cstmt.getBoolean(pos);
                        break;
                    }
                    case 1: {
                        v = new Double(this.cstmt.getDouble(pos));
                        break;
                    }
                    case 6: {
                        v = this.cstmt.getBigDecimal(pos);
                        break;
                    }
                    case 5: {
                        v = this.cstmt.getLong(pos);
                        break;
                    }
                    case 2: {
                        v = this.cstmt.getString(pos);
                        break;
                    }
                    case 8: {
                        if (this.databaseMeta.supportsGetBlob()) {
                            Blob blob = this.cstmt.getBlob(pos);
                            if (blob != null) {
                                v = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            v = null;
                            break;
                        }
                        v = this.cstmt.getBytes(pos);
                        break;
                    }
                    case 3: {
                        v = this.databaseMeta.supportsTimeStampToDateConversion() ? this.cstmt.getTimestamp(pos) : this.cstmt.getDate(pos);
                    }
                }
                ret.addValue(vMeta, v);
                ++pos;
            }
            for (int i = 0; i < arg.length; ++i) {
                if (!argdir[i].equalsIgnoreCase("OUT") && !argdir[i].equalsIgnoreCase("INOUT")) continue;
                ValueMeta vMeta = new ValueMeta(arg[i], argtype[i]);
                Object v = null;
                switch (argtype[i]) {
                    case 4: {
                        v = this.cstmt.getBoolean(pos + i);
                        break;
                    }
                    case 1: {
                        v = new Double(this.cstmt.getDouble(pos + i));
                        break;
                    }
                    case 6: {
                        v = this.cstmt.getBigDecimal(pos + i);
                        break;
                    }
                    case 5: {
                        v = this.cstmt.getLong(pos + i);
                        break;
                    }
                    case 2: {
                        v = this.cstmt.getString(pos + i);
                        break;
                    }
                    case 8: {
                        if (this.databaseMeta.supportsGetBlob()) {
                            Blob blob = this.cstmt.getBlob(pos + i);
                            if (blob != null) {
                                v = blob.getBytes(1L, (int)blob.length());
                                break;
                            }
                            v = null;
                            break;
                        }
                        v = this.cstmt.getBytes(pos + i);
                        break;
                    }
                    case 3: {
                        v = this.databaseMeta.supportsTimeStampToDateConversion() ? this.cstmt.getTimestamp(pos + i) : this.cstmt.getDate(pos + i);
                    }
                }
                ret.addValue(vMeta, v);
            }
            ResultSet rs = null;
            int updateCount = -1;
            do {
                Object var14_17;
                rs = null;
                try {
                    if (moreResults) {
                        rs = this.cstmt.getResultSet();
                    } else {
                        updateCount = this.cstmt.getUpdateCount();
                    }
                    moreResults = this.cstmt.getMoreResults();
                    var14_17 = null;
                    if (rs == null) continue;
                }
                catch (Throwable throwable) {
                    var14_17 = null;
                    if (rs != null) {
                        rs.close();
                        rs = null;
                    }
                    throw throwable;
                }
                rs.close();
                rs = null;
                {
                }
            } while (moreResults || updateCount > -1);
            return ret;
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to call procedure", (Throwable)ex);
        }
    }

    public void closeProcedureStatement() throws KettleDatabaseException {
        try {
            if (this.cstmt != null) {
                this.cstmt.close();
                this.cstmt = null;
            }
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.Exception.ErrorClosingCallableStatement", (String[])new String[0]), (Throwable)ex);
        }
    }

    public String getDDLCreationTable(String tableName, RowMetaInterface fields) throws KettleDatabaseException {
        this.databaseMeta.quoteReservedWords(fields);
        String quotedTk = this.databaseMeta.quoteField(null);
        String retval = this.getCreateTableStatement(tableName, fields, quotedTk, false, null, true);
        return retval;
    }

    public String getDDLTruncateTable(String schema, String tablename) throws KettleDatabaseException {
        if (Const.isEmpty((String)this.connectionGroup)) {
            return this.databaseMeta.getTruncateTableStatement(schema, tablename);
        }
        return "DELETE FROM " + this.databaseMeta.getQuotedSchemaTableCombination(schema, tablename);
    }

    public String getSQLOutput(String schemaName, String tableName, RowMetaInterface fields, Object[] r, String dateFormat) throws KettleDatabaseException {
        StringBuffer ins = new StringBuffer(128);
        try {
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(schemaName, tableName);
            ins.append("INSERT INTO ").append(schemaTable).append('(');
            for (int i = 0; i < fields.size(); ++i) {
                if (i > 0) {
                    ins.append(", ");
                }
                String name = fields.getValueMeta(i).getName();
                ins.append(this.databaseMeta.quoteField(name));
            }
            ins.append(") VALUES (");
            SimpleDateFormat[] fieldDateFormatters = new SimpleDateFormat[fields.size()];
            block9: for (int i = 0; i < fields.size(); ++i) {
                ValueMetaInterface valueMeta = fields.getValueMeta(i);
                Object valueData = r[i];
                if (i > 0) {
                    ins.append(",");
                }
                if (valueMeta.isNull(valueData)) {
                    ins.append("null");
                    continue;
                }
                switch (valueMeta.getType()) {
                    case 2: 
                    case 4: {
                        String string = valueMeta.getString(valueData);
                        string = this.databaseMeta.quoteSQLString(string);
                        ins.append(string);
                        continue block9;
                    }
                    case 3: {
                        java.util.Date date = fields.getDate(r, i);
                        if (Const.isEmpty((String)dateFormat)) {
                            if (this.databaseMeta.getDatabaseInterface() instanceof OracleDatabaseMeta) {
                                if (fieldDateFormatters[i] == null) {
                                    fieldDateFormatters[i] = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
                                }
                                ins.append("TO_DATE('").append(fieldDateFormatters[i].format(date)).append("', 'YYYY/MM/DD HH24:MI:SS')");
                                continue block9;
                            }
                            ins.append("'" + fields.getString(r, i) + "'");
                            continue block9;
                        }
                        try {
                            SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                            ins.append("'" + formatter.format(fields.getDate(r, i)) + "'");
                            continue block9;
                        }
                        catch (Exception e) {
                            throw new KettleDatabaseException("Error : ", (Throwable)e);
                        }
                    }
                    default: {
                        ins.append(fields.getString(r, i));
                    }
                }
            }
            ins.append(')');
        }
        catch (Exception e) {
            throw new KettleDatabaseException((Throwable)e);
        }
        return ins.toString();
    }

    public Savepoint setSavepoint() throws KettleDatabaseException {
        try {
            return this.connection.setSavepoint();
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.Exception.UnableToSetSavepoint", (String[])new String[0]), (Throwable)e);
        }
    }

    public Savepoint setSavepoint(String savePointName) throws KettleDatabaseException {
        try {
            return this.connection.setSavepoint(savePointName);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.Exception.UnableToSetSavepointName", (String[])new String[]{savePointName}), (Throwable)e);
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws KettleDatabaseException {
        try {
            this.connection.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.Exception.UnableToReleaseSavepoint", (String[])new String[0]), (Throwable)e);
        }
    }

    public void rollback(Savepoint savepoint) throws KettleDatabaseException {
        try {
            this.connection.rollback(savepoint);
        }
        catch (SQLException e) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"Database.Exception.UnableToRollbackToSavepoint", (String[])new String[0]), (Throwable)e);
        }
    }

    public Object getParentObject() {
        return this.parentLoggingObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getPrimaryKeyColumnNames(String tablename) throws KettleDatabaseException {
        ArrayList<String> names = new ArrayList<String>();
        ResultSet allkeys = null;
        try {
            try {
                allkeys = this.getDatabaseMetaData().getPrimaryKeys(null, null, tablename);
                while (allkeys.next()) {
                    String keyname = allkeys.getString("PK_NAME");
                    String col_name = allkeys.getString("COLUMN_NAME");
                    if (!names.contains(col_name)) {
                        names.add(col_name);
                    }
                    if (!this.log.isRowLevel()) continue;
                    this.log.logRowlevel(this.toString(), new Object[]{"getting key : " + keyname + " on column " + col_name});
                }
                Object var7_7 = null;
            }
            catch (SQLException e) {
                this.log.logError(this.toString(), new Object[]{"Error getting primary keys columns from table [" + tablename + "]"});
                Object var7_8 = null;
                try {
                    if (allkeys == null) return names.toArray(new String[names.size()]);
                    allkeys.close();
                    return names.toArray(new String[names.size()]);
                }
                catch (SQLException e2) {
                    throw new KettleDatabaseException("Error closing connection while searching primary keys in table [" + tablename + "]", (Throwable)e2);
                }
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {}
            catch (SQLException e2) {
                throw new KettleDatabaseException("Error closing connection while searching primary keys in table [" + tablename + "]", (Throwable)e2);
            }
            if (allkeys == null) throw throwable;
            allkeys.close();
            throw throwable;
        }
        try {}
        catch (SQLException e2) {
            throw new KettleDatabaseException("Error closing connection while searching primary keys in table [" + tablename + "]", (Throwable)e2);
        }
        if (allkeys == null) return names.toArray(new String[names.size()]);
        allkeys.close();
        return names.toArray(new String[names.size()]);
    }

    public String[] getSequences() throws KettleDatabaseException {
        if (this.databaseMeta.supportsSequences()) {
            String sql = this.databaseMeta.getSQLListOfSequences();
            if (sql != null) {
                List<Object[]> seqs = this.getRows(sql, 0);
                String[] str = new String[seqs.size()];
                for (int i = 0; i < seqs.size(); ++i) {
                    str[i] = seqs.get(i)[0].toString();
                }
                return str;
            }
        } else {
            throw new KettleDatabaseException("Sequences are only available for Oracle databases.");
        }
        return null;
    }

    public String getFilename() {
        return null;
    }

    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    public String getObjectName() {
        return this.databaseMeta.getName();
    }

    public String getObjectCopy() {
        return null;
    }

    public ObjectId getObjectId() {
        return this.databaseMeta.getObjectId();
    }

    public ObjectRevision getObjectRevision() {
        return this.databaseMeta.getObjectRevision();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.DATABASE;
    }

    public LoggingObjectInterface getParent() {
        return this.parentLoggingObject;
    }

    public RepositoryDirectory getRepositoryDirectory() {
        return null;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.log.setLogLevel(logLevel);
    }

    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    public java.util.Date getRegistrationDate() {
        return null;
    }

    public int getNrExecutedCommits() {
        return this.nrExecutedCommits;
    }

    public void setNrExecutedCommits(int nrExecutedCommits) {
        this.nrExecutedCommits = nrExecutedCommits;
    }
}

