/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.ResultSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;

public class OracleDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 2, 4};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 1521;
        }
        return -1;
    }

    public boolean supportsAutoInc() {
        return false;
    }

    public String getLimitClause(int nrRows) {
        return " WHERE ROWNUM <= " + nrRows;
    }

    public String getSQLQueryFields(String tableName) {
        return "SELECT /*+FIRST_ROWS*/ * FROM " + tableName + " WHERE ROWNUM < 1";
    }

    public String getSQLTableExists(String tablename) {
        return this.getSQLQueryFields(tablename);
    }

    public String getSQLColumnExists(String columnname, String tablename) {
        return this.getSQLQueryColumnFields(columnname, tablename);
    }

    public String getSQLQueryColumnFields(String columnname, String tableName) {
        return "SELECT /*+FIRST_ROWS*/ " + columnname + " FROM " + tableName + " WHERE ROWNUM < 1";
    }

    public boolean needsToLockAllTables() {
        return false;
    }

    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "oracle.jdbc.driver.OracleDriver";
    }

    public String getURL(String hostname, String port, String databaseName) throws KettleDatabaseException {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        if (this.getAccessType() == 0) {
            if (databaseName != null && databaseName.length() > 0 && (databaseName.startsWith("/") || databaseName.startsWith(":"))) {
                return "jdbc:oracle:thin:@" + hostname + ":" + port + databaseName;
            }
            if (Const.isEmpty((String)this.getHostname()) && (Const.isEmpty((String)this.getDatabasePortNumberString()) || this.getDatabasePortNumberString().equals("-1"))) {
                return "jdbc:oracle:thin:@" + this.getDatabaseName();
            }
            return "jdbc:oracle:thin:@" + hostname + ":" + port + ":" + databaseName;
        }
        if (this.getDatabaseName() != null && this.getDatabaseName().length() > 0) {
            if (this.getHostname() != null && this.getHostname().length() > 0 && this.getDatabasePortNumberString() != null && this.getDatabasePortNumberString().length() > 0) {
                return "jdbc:oracle:oci:@(description=(address=(host=" + this.getHostname() + ")(protocol=tcp)(port=" + this.getDatabasePortNumberString() + "))(connect_data=(sid=" + this.getDatabaseName() + ")))";
            }
            return "jdbc:oracle:oci:@" + this.getDatabaseName();
        }
        throw new KettleDatabaseException("Unable to construct a JDBC URL: at least the database name must be specified");
    }

    public boolean supportsOptionsInURL() {
        return false;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSQLSequenceExists(String sequenceName) {
        return "SELECT * FROM USER_SEQUENCES WHERE SEQUENCE_NAME = '" + sequenceName.toUpperCase() + "'";
    }

    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".currval FROM DUAL";
    }

    public String getSQLNextSequenceValue(String sequenceName) {
        return "SELECT " + sequenceName + ".nextval FROM dual";
    }

    public boolean useSchemaNameForTableList() {
        return true;
    }

    public boolean supportsSynonyms() {
        return true;
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD ( " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false) + " ) ";
    }

    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP ( " + v.getName() + " ) " + Const.CR;
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        boolean isQuoted;
        ValueMetaInterface tmpColumn = v.clone();
        String tmpName = v.getName();
        boolean bl = isQuoted = tmpName.startsWith("\"") && tmpName.endsWith("\"");
        if (isQuoted) {
            tmpName = tmpName.substring(1, tmpName.length() - 1);
        }
        int threeoh = tmpName.length() >= 30 ? 30 : tmpName.length();
        tmpName = tmpName.substring(0, threeoh);
        tmpName = tmpName + "_KTL";
        if (isQuoted) {
            tmpName = "\"" + tmpName + "\"";
        }
        tmpColumn.setName(tmpName);
        String sql = "";
        sql = sql + this.getAddColumnStatement(tablename, tmpColumn, tk, use_autoinc, pk, semicolon) + ";" + Const.CR;
        sql = sql + "UPDATE " + tablename + " SET " + tmpColumn.getName() + "=" + v.getName() + ";" + Const.CR;
        sql = sql + this.getDropColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon) + ";" + Const.CR;
        sql = sql + this.getAddColumnStatement(tablename, v, tk, use_autoinc, pk, semicolon) + ";" + Const.CR;
        sql = sql + "UPDATE " + tablename + " SET " + v.getName() + "=" + tmpColumn.getName() + ";" + Const.CR;
        sql = sql + this.getDropColumnStatement(tablename, tmpColumn, tk, use_autoinc, pk, semicolon);
        return sql;
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        StringBuffer retval = new StringBuffer(128);
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval.append(fieldname).append(' ');
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval.append("DATE");
                break;
            }
            case 4: {
                retval.append("CHAR(1)");
                break;
            }
            case 1: 
            case 6: {
                retval.append("NUMBER");
                if (length <= 0) break;
                retval.append('(').append(length);
                if (precision > 0) {
                    retval.append(", ").append(precision);
                }
                retval.append(')');
                break;
            }
            case 5: {
                retval.append("INTEGER");
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval.append("CLOB");
                    break;
                }
                if (length == 1) {
                    retval.append("CHAR(1)");
                    break;
                }
                if (length > 0 && length <= 2000) {
                    retval.append("VARCHAR2(").append(length).append(')');
                    break;
                }
                if (length <= 0) {
                    retval.append("VARCHAR2(2000)");
                    break;
                }
                retval.append("CLOB");
                break;
            }
            case 8: {
                retval.append("BLOB");
                break;
            }
            default: {
                retval.append(" UNKNOWN");
            }
        }
        if (add_cr) {
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    public String[] getReservedWords() {
        return new String[]{"ACCESS", "ADD", "ALL", "ALTER", "AND", "ANY", "ARRAYLEN", "AS", "ASC", "AUDIT", "BETWEEN", "BY", "CHAR", "CHECK", "CLUSTER", "COLUMN", "COMMENT", "COMPRESS", "CONNECT", "CREATE", "CURRENT", "DATE", "DECIMAL", "DEFAULT", "DELETE", "DESC", "DISTINCT", "DROP", "ELSE", "EXCLUSIVE", "EXISTS", "FILE", "FLOAT", "FOR", "FROM", "GRANT", "GROUP", "HAVING", "IDENTIFIED", "IMMEDIATE", "IN", "INCREMENT", "INDEX", "INITIAL", "INSERT", "INTEGER", "INTERSECT", "INTO", "IS", "LEVEL", "LIKE", "LOCK", "LONG", "MAXEXTENTS", "MINUS", "MODE", "MODIFY", "NOAUDIT", "NOCOMPRESS", "NOT", "NOTFOUND", "NOWAIT", "NULL", "NUMBER", "OF", "OFFLINE", "ON", "ONLINE", "OPTION", "OR", "ORDER", "PCTFREE", "PRIOR", "PRIVILEGES", "PUBLIC", "RAW", "RENAME", "RESOURCE", "REVOKE", "ROW", "ROWID", "ROWLABEL", "ROWNUM", "ROWS", "SELECT", "SESSION", "SET", "SHARE", "SIZE", "SMALLINT", "SQLBUF", "START", "SUCCESSFUL", "SYNONYM", "SYSDATE", "TABLE", "THEN", "TO", "TRIGGER", "UID", "UNION", "UNIQUE", "UPDATE", "USER", "VALIDATE", "VALUES", "VARCHAR", "VARCHAR2", "VIEW", "WHENEVER", "WHERE", "WITH"};
    }

    public String getSQLListOfProcedures() {
        return "SELECT DISTINCT DECODE(package_name, NULL, '', package_name||'.')||object_name FROM user_arguments ORDER BY 1";
    }

    public String getSQLLockTables(String[] tableNames) {
        StringBuffer sql = new StringBuffer(128);
        for (int i = 0; i < tableNames.length; ++i) {
            sql.append("LOCK TABLE ").append(tableNames[i]).append(" IN EXCLUSIVE MODE;").append(Const.CR);
        }
        return sql.toString();
    }

    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    public String getExtraOptionsHelpText() {
        return "http://download.oracle.com/docs/cd/B19306_01/java.102/b14355/urls.htm#i1006362";
    }

    public String[] getUsedLibraries() {
        return new String[]{"ojdbc14.jar", "orai18n.jar"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIndexExists(Database database, String schemaName, String tableName, String[] idx_fields) throws KettleDatabaseException {
        String tablename = database.getDatabaseMeta().getQuotedSchemaTableCombination(schemaName, tableName);
        boolean[] exists = new boolean[idx_fields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            ResultSet res;
            block11: {
                boolean row2;
                String sql = "SELECT * FROM USER_IND_COLUMNS WHERE TABLE_NAME = '" + tableName + "'";
                res = null;
                try {
                    res = database.openQuery(sql);
                    if (res != null) {
                        Object[] row2 = database.getRow(res);
                        while (row2 != null) {
                            String column = database.getReturnRowMeta().getString(row2, "COLUMN_NAME", "");
                            int idx = Const.indexOfString((String)column, (String[])idx_fields);
                            if (idx >= 0) {
                                exists[idx] = true;
                            }
                            row2 = database.getRow(res);
                        }
                        break block11;
                    }
                    row2 = false;
                    Object var13_17 = null;
                    if (res == null) return row2;
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    if (res != null) {
                        database.closeQuery(res);
                    }
                    throw throwable;
                }
                database.closeQuery(res);
                return row2;
            }
            Object var13_18 = null;
            if (res != null) {
                database.closeQuery(res);
            }
            boolean all = true;
            for (int i = 0; i < exists.length && all; ++i) {
                if (exists[i]) continue;
                all = false;
            }
            return all;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to determine if indexes exists on table [" + tablename + "]", (Throwable)e);
        }
    }

    public boolean requiresCreateTablePrimaryKeyAppend() {
        return true;
    }

    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }

    public int getMaxColumnsInIndex() {
        return 32;
    }

    public String getSQLListOfSequences() {
        return "SELECT SEQUENCE_NAME FROM all_sequences";
    }

    public String quoteSQLString(String string) {
        string = string.replaceAll("'", "''");
        string = string.replaceAll("\\n", "'||chr(13)||'");
        string = string.replaceAll("\\r", "'||chr(10)||'");
        return "'" + string + "'";
    }

    public boolean releaseSavepoint() {
        return false;
    }

    public String getTablespaceDDL(VariableSpace variables, DatabaseMeta databaseMeta, String tablespace) {
        if (!Const.isEmpty((String)tablespace)) {
            return "TABLESPACE " + databaseMeta.quoteField(variables.environmentSubstitute(tablespace));
        }
        return "";
    }

    public boolean supportsErrorHandlingOnBatchUpdates() {
        return false;
    }
}

