/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.BaseDatabaseMeta;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class SybaseIQDatabaseMeta
extends BaseDatabaseMeta
implements DatabaseInterface {
    public int[] getAccessTypeList() {
        return new int[]{0, 1, 4};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 2638;
        }
        return -1;
    }

    public int getNotFoundTK(boolean use_autoinc) {
        if (this.supportsAutoInc() && use_autoinc) {
            return 1;
        }
        return super.getNotFoundTK(use_autoinc);
    }

    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.sybase.jdbc3.jdbc.SybDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        return "jdbc:sybase:Tds:" + hostname + ":" + port + "/" + databaseName;
    }

    public String getSchemaTableCombination(String schema_name, String table_part) {
        return schema_name + "." + table_part;
    }

    public boolean supportsRepository() {
        return false;
    }

    public String getAddColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " ADD " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getModifyColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " MODIFY " + this.getFieldDefinition(v, tk, pk, use_autoinc, true, false);
    }

    public String getFieldDefinition(ValueMetaInterface v, String tk, String pk, boolean use_autoinc, boolean add_fieldname, boolean add_cr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (add_fieldname) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: {
                retval = retval + "DATETIME NULL";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (use_autoinc) {
                        retval = retval + "INTEGER IDENTITY NOT NULL";
                        break;
                    }
                    retval = retval + "INTEGER NOT NULL PRIMARY KEY";
                    break;
                }
                if (precision != 0 || precision == 0 && length > 9) {
                    if (precision > 0 && length > 0) {
                        retval = retval + "DECIMAL(" + length + ", " + precision + ") NULL";
                        break;
                    }
                    retval = retval + "DOUBLE PRECISION NULL";
                    break;
                }
                if (length < 3) {
                    retval = retval + "TINYINT NULL";
                    break;
                }
                if (length < 5) {
                    retval = retval + "SMALLINT NULL";
                    break;
                }
                retval = retval + "INTEGER NULL";
                break;
            }
            case 2: {
                if (length >= 2048) {
                    retval = retval + "TEXT NULL";
                    break;
                }
                retval = retval + "VARCHAR";
                if (length > 0) {
                    retval = retval + "(" + length + ")";
                }
                retval = retval + " NULL";
                break;
            }
            default: {
                retval = retval + " UNKNOWN";
            }
        }
        if (add_cr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String getExtraOptionsHelpText() {
        return "http://jtds.sourceforge.net/faq.html#urlFormat";
    }

    public String[] getUsedLibraries() {
        return new String[]{"jtds-1.2.jar"};
    }

    public boolean useSchemaNameForTableList() {
        return true;
    }

    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + " WHERE 1=2";
    }

    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }
}

