/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.pentaho.di.core.database.DataSourceNamingException;
import org.pentaho.di.core.database.DataSourceProviderInterface;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.i18n.BaseMessages;

public class DatabaseUtil
implements DataSourceProviderInterface {
    private static Class<?> PKG = Database.class;
    private static Map<String, DataSource> FoundDS = Collections.synchronizedMap(new HashMap());

    public DataSource getNamedDataSource(String datasourceName) throws DataSourceNamingException {
        try {
            return DatabaseUtil.getDataSourceFromJndi(datasourceName);
        }
        catch (NamingException ex) {
            throw new DataSourceNamingException(ex);
        }
    }

    private static DataSource getDataSourceFromJndi(String dsName) throws NamingException {
        DataSource foundDs = FoundDS.get(dsName);
        if (foundDs != null) {
            return foundDs;
        }
        InitialContext ctx = new InitialContext();
        Object lkup = null;
        DataSource rtn = null;
        NamingException firstNe = null;
        try {
            lkup = ctx.lookup(dsName);
            if (lkup != null) {
                rtn = (DataSource)lkup;
                FoundDS.put(dsName, rtn);
                return rtn;
            }
        }
        catch (NamingException ignored) {
            firstNe = ignored;
        }
        try {
            lkup = ctx.lookup("java:" + dsName);
            if (lkup != null) {
                rtn = (DataSource)lkup;
                FoundDS.put(dsName, rtn);
                return rtn;
            }
        }
        catch (NamingException ignored) {
            // empty catch block
        }
        try {
            lkup = ctx.lookup("java:comp/env/jdbc/" + dsName);
            if (lkup != null) {
                rtn = (DataSource)lkup;
                FoundDS.put(dsName, rtn);
                return rtn;
            }
        }
        catch (NamingException ignored) {
            // empty catch block
        }
        try {
            lkup = ctx.lookup("jdbc/" + dsName);
            if (lkup != null) {
                rtn = (DataSource)lkup;
                FoundDS.put(dsName, rtn);
                return rtn;
            }
        }
        catch (NamingException ignored) {
            // empty catch block
        }
        if (firstNe != null) {
            throw firstNe;
        }
        throw new NamingException(BaseMessages.getString(PKG, (String)"DatabaseUtil.DSNotFound", (String[])new String[]{dsName}));
    }
}

