/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.DatabaseMetaPlugin;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PluginMainClassType(value=DatabaseInterface.class)
@PluginAnnotationType(value=DatabaseMetaPlugin.class)
public class DatabasePluginType
extends BasePluginType
implements PluginTypeInterface {
    private static DatabasePluginType pluginType;

    private DatabasePluginType() {
        super(DatabaseMetaPlugin.class, "DATABASE", "Database");
        this.populateFolders("databases");
    }

    public static DatabasePluginType getInstance() {
        if (pluginType == null) {
            pluginType = new DatabasePluginType();
        }
        return pluginType;
    }

    protected void registerNatives() throws KettlePluginException {
        String xmlFile = "kettle-database-types.xml";
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(xmlFile);
            if (inputStream == null) {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + xmlFile);
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native kettle database types definition file: " + xmlFile);
            }
            Document document = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)true, (boolean)false);
            Node repsNode = XMLHandler.getSubNode((Node)document, (String)"database-types");
            List repsNodes = XMLHandler.getNodes((Node)repsNode, (String)"database-type");
            for (Node repNode : repsNodes) {
                this.registerPluginFromXmlResource(repNode, "./", ((Object)((Object)this)).getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle database types XML config file: " + xmlFile, (Throwable)e);
        }
    }

    protected void registerXmlPlugins() throws KettlePluginException {
    }

    public String[] getNaturalCategoriesOrder() {
        return new String[0];
    }

    protected String extractCategory(Annotation annotation) {
        return "";
    }

    protected String extractDesc(Annotation annotation) {
        return ((DatabaseMetaPlugin)annotation).typeDescription();
    }

    protected String extractID(Annotation annotation) {
        return ((DatabaseMetaPlugin)annotation).type();
    }

    protected String extractName(Annotation annotation) {
        return ((DatabaseMetaPlugin)annotation).typeDescription();
    }

    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return false;
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return null;
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }
}

