/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.samples;

import org.codehaus.janino.ScriptEvaluator;
import org.codehaus.janino.samples.DemoBase;

public class ScriptDemo
extends DemoBase {
    public static void main(String[] args) throws Exception {
        String arg;
        int i;
        Class returnType = Void.TYPE;
        String[] parameterNames = new String[]{};
        Class[] parameterTypes = new Class[]{};
        for (i = 0; i < args.length && (arg = args[i]).startsWith("-"); ++i) {
            if (arg.equals("-rt")) {
                returnType = DemoBase.stringToType(args[++i]);
                continue;
            }
            if (arg.equals("-pn")) {
                parameterNames = DemoBase.explode(args[++i]);
                continue;
            }
            if (arg.equals("-pt")) {
                parameterTypes = DemoBase.stringToTypes(args[++i]);
                continue;
            }
            if (arg.equals("-help")) {
                ScriptDemo.usage();
                System.exit(0);
                continue;
            }
            System.err.println("Invalid command line option \"" + arg + "\".");
            ScriptDemo.usage();
            System.exit(0);
        }
        if (i == args.length) {
            System.err.println("Script missing on command line; try \"-help\".");
            System.exit(1);
        }
        String script = args[i++];
        if (parameterTypes.length != parameterNames.length) {
            System.err.println("Parameter type count and parameter name count do not match.");
            ScriptDemo.usage();
            System.exit(1);
        }
        if (args.length - i != parameterNames.length) {
            System.err.println("Argument and parameter count do not match.");
            ScriptDemo.usage();
            System.exit(1);
        }
        Object[] parameterValues = new Object[parameterNames.length];
        for (int j = 0; j < parameterNames.length; ++j) {
            parameterValues[j] = DemoBase.createObject(parameterTypes[j], args[i + j]);
        }
        ScriptEvaluator se = new ScriptEvaluator(script, returnType, parameterNames, parameterTypes);
        Object res = se.evaluate(parameterValues);
        System.out.println("Result = " + DemoBase.toString(res));
    }

    private ScriptDemo() {
    }

    private static void usage() {
        System.err.println("Usage:  ScriptDemo { <option> } <script> { <parameter-value> }");
        System.err.println("Valid options are");
        System.err.println(" -rt <return-type>");
        System.err.println(" -pn <comma-separated-parameter-names>");
        System.err.println(" -pt <comma-separated-parameter-types>");
        System.err.println(" -help");
        System.err.println("The number of parameter names, types and values must be identical.");
        System.err.println("The default is no parameters.");
    }
}

