/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPConstraints;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.util.GetOpt;

public class LDAPDelete
extends LDAPTool {
    private static String[] m_delete_dn = null;
    private static boolean m_cont = false;
    private static BufferedReader m_reader = null;

    private static boolean deleteEntry(String string, LDAPConstraints lDAPConstraints) {
        if (LDAPTool.m_verbose) {
            System.err.println("Deleting entry: " + string);
        }
        if (!LDAPTool.m_justShow) {
            try {
                LDAPTool.m_client.delete(string, lDAPConstraints);
            }
            catch (LDAPException lDAPException) {
                System.err.println("Delete " + string + " failed ");
                System.err.println("\t" + lDAPException.errorCodeToString());
                System.err.println("\tmatched " + lDAPException.getMatchedDN() + "\n");
                return false;
            }
        }
        return true;
    }

    private static void doUsage() {
        System.err.println("usage: LDAPDelete [options] dn");
        System.err.println("options");
        System.err.println("  -h host       LDAP server name or IP address");
        System.err.println("  -p port       LDAP server TCP port number");
        System.err.println("  -V version    LDAP protocol version number (default is 3)");
        System.err.println("  -D binddn     bind dn");
        System.err.println("  -w password   bind passwd (for simple authentication)");
        System.err.println("  -d level      set LDAP debugging level to 'level'");
        System.err.println("  -f file      read DNs to delete from file");
        System.err.println("  -R            do not automatically follow referrals");
        System.err.println("  -O hop limit  maximum number of referral hops to traverse");
        System.err.println("  -H            display usage information");
        System.err.println("  -c            continuous mode (do not stop on errors)");
        System.err.println("  -M            manage references (treat them as regular entries)");
        System.err.println("  -y proxy-DN   DN to use for access control");
    }

    private static void dodelete() {
        boolean bl = false;
        LDAPConstraints lDAPConstraints = LDAPTool.m_client.getConstraints();
        Vector<LDAPControl> vector = new Vector<LDAPControl>();
        if (LDAPTool.m_proxyControl != null) {
            vector.addElement(LDAPTool.m_proxyControl);
        }
        if (LDAPTool.m_ordinary) {
            vector.addElement(new LDAPControl("2.16.840.1.113730.3.4.2", true, null));
        }
        if (vector.size() > 0) {
            Object[] objectArray = new LDAPControl[vector.size()];
            vector.copyInto(objectArray);
            lDAPConstraints.setServerControls((LDAPControl[])objectArray);
        }
        lDAPConstraints.setReferrals(LDAPTool.m_referrals);
        if (LDAPTool.m_referrals) {
            LDAPTool.setDefaultReferralCredentials(lDAPConstraints);
        }
        lDAPConstraints.setHopLimit(LDAPTool.m_hopLimit);
        LDAPDelete.dodelete(lDAPConstraints);
    }

    private static void dodelete(LDAPConstraints lDAPConstraints) {
        try {
            if (m_reader == null) {
                int n = 0;
                while (n < m_delete_dn.length) {
                    if (!LDAPDelete.deleteEntry(m_delete_dn[n], lDAPConstraints) && !m_cont) {
                        return;
                    }
                    ++n;
                }
            } else {
                String string = null;
                while ((string = m_reader.readLine()) != null) {
                    if (LDAPDelete.deleteEntry(string, lDAPConstraints) || m_cont) continue;
                    return;
                }
            }
        }
        catch (IOException iOException) {
            System.err.println("Error in reading input");
        }
    }

    protected static void extractParameters(String[] stringArray) {
        Object object;
        Object object2;
        GetOpt getOpt = LDAPTool.extractParameters("Hcf:", stringArray);
        if (getOpt.hasOption('H')) {
            LDAPDelete.doUsage();
            System.exit(0);
        }
        if (getOpt.hasOption('c')) {
            m_cont = true;
        }
        if (getOpt.hasOption('f')) {
            object2 = getOpt.getOptionParam('f');
            if (object2 == null) {
                LDAPDelete.doUsage();
                System.exit(0);
            }
            try {
                object = new FileInputStream((String)object2);
                DataInputStream dataInputStream = new DataInputStream((InputStream)object);
                m_reader = new BufferedReader(new InputStreamReader(dataInputStream));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println("File " + (String)object2 + " not found");
            }
            catch (IOException iOException) {
                System.err.println("Error in opening the file " + (String)object2);
            }
        }
        if (m_reader == null) {
            object2 = getOpt.getParameters().elements();
            object = new Vector();
            while (object2.hasMoreElements()) {
                ((Vector)object).addElement(object2.nextElement());
            }
            if (((Vector)object).size() <= 0) {
                LDAPDelete.doUsage();
                System.exit(0);
            }
            m_delete_dn = new String[((Vector)object).size()];
            ((Vector)object).copyInto(m_delete_dn);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            LDAPDelete.doUsage();
            System.exit(1);
        }
        LDAPDelete.extractParameters(stringArray);
        if (!LDAPTool.m_justShow) {
            try {
                LDAPTool.m_client = new LDAPConnection();
                LDAPTool.m_client.connect(LDAPTool.m_ldaphost, LDAPTool.m_ldapport);
            }
            catch (Exception exception) {
                System.err.println("Error: client connection failed!");
                System.exit(1);
            }
            try {
                LDAPTool.m_client.authenticate(LDAPTool.m_version, LDAPTool.m_binddn, LDAPTool.m_passwd);
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                System.exit(1);
            }
            LDAPDelete.dodelete();
            try {
                LDAPTool.m_client.disconnect();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
            }
        } else {
            LDAPDelete.dodelete(null);
        }
        System.exit(0);
    }
}

