/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPDITContentRuleSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = -8588488481097270056L;
    public static final String AUX = "AUX";
    public static final String MUST = "MUST";
    public static final String MAY = "MAY";
    public static final String NOT = "NOT";
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;
    private Vector must = new Vector();
    private Vector may = new Vector();
    private Vector aux = new Vector();
    private Vector not = new Vector();

    static {
        int n = 0;
        while (n < NOVALS.length) {
            LDAPSchemaElement.novalsTable.put(NOVALS[n], NOVALS[n]);
            ++n;
        }
        IGNOREVALS = new String[]{"OBSOLETE", AUX, MUST, MAY, NOT};
    }

    protected LDAPDITContentRuleSchema() {
    }

    public LDAPDITContentRuleSchema(String string) {
        this.attrName = "ditContentRules";
        this.parseValue(string);
        Object v = this.properties.get(MAY);
        if (v != null) {
            if (v instanceof Vector) {
                this.may = (Vector)v;
            } else {
                this.may.addElement(v);
            }
        }
        if ((v = this.properties.get(MUST)) != null) {
            if (v instanceof Vector) {
                this.must = (Vector)v;
            } else {
                this.must.addElement(v);
            }
        }
        if ((v = this.properties.get(NOT)) != null) {
            if (v instanceof Vector) {
                this.not = (Vector)v;
            } else {
                this.not.addElement(v);
            }
        }
        if ((v = this.properties.get(AUX)) != null) {
            if (v instanceof Vector) {
                this.aux = (Vector)v;
            } else {
                this.aux.addElement(v);
            }
        }
    }

    public LDAPDITContentRuleSchema(String string, String string2, String string3, boolean bl, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        super(string, string2, string3, null);
        int n;
        if (stringArray2 != null) {
            n = 0;
            while (n < stringArray2.length) {
                this.must.addElement(stringArray2[n]);
                ++n;
            }
        }
        if (stringArray3 != null) {
            n = 0;
            while (n < stringArray3.length) {
                this.may.addElement(stringArray3[n]);
                ++n;
            }
        }
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                this.aux.addElement(stringArray[n]);
                ++n;
            }
        }
        if (stringArray4 != null) {
            n = 0;
            while (n < stringArray4.length) {
                this.not.addElement(stringArray4[n]);
                ++n;
            }
        }
        if (bl) {
            this.setQualifier("OBSOLETE", "");
        }
    }

    public String[] getAuxiliaryClasses() {
        Object[] objectArray = new String[this.aux.size()];
        this.aux.copyInto(objectArray);
        return objectArray;
    }

    public String[] getOptionalAttributes() {
        Object[] objectArray = new String[this.may.size()];
        this.may.copyInto(objectArray);
        return objectArray;
    }

    public String[] getPrecludedAttributes() {
        Object[] objectArray = new String[this.not.size()];
        this.not.copyInto(objectArray);
        return objectArray;
    }

    public String[] getRequiredAttributes() {
        Object[] objectArray = new String[this.must.size()];
        this.must.copyInto(objectArray);
        return objectArray;
    }

    public String getValue() {
        String string = this.getValuePrefix();
        String string2 = this.getOptionalValues(NOVALS);
        if (string2.length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        if (this.aux.size() > 0) {
            string = String.valueOf(string) + "AUX " + this.vectorToList(this.aux);
            string = String.valueOf(string) + ' ';
        }
        if (this.must.size() > 0) {
            string = String.valueOf(string) + "MUST " + this.vectorToList(this.must);
            string = String.valueOf(string) + ' ';
        }
        if (this.may.size() > 0) {
            string = String.valueOf(string) + "MAY " + this.vectorToList(this.may);
            string = String.valueOf(string) + ' ';
        }
        if (this.not.size() > 0) {
            string = String.valueOf(string) + "NOT " + this.vectorToList(this.not);
            string = String.valueOf(string) + ' ';
        }
        if ((string2 = this.getCustomValues()).length() > 0) {
            string = String.valueOf(string) + string2 + ' ';
        }
        string = String.valueOf(string) + ')';
        return string;
    }

    public String toString() {
        String string = "Name: " + this.name + "; OID: " + this.oid;
        string = String.valueOf(string) + "; Description: " + this.description + "; Required: ";
        int n = 0;
        Enumeration enumeration = this.must.elements();
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
            string = String.valueOf(string) + (String)enumeration.nextElement();
        }
        string = String.valueOf(string) + "; Optional: ";
        enumeration = this.may.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
            string = String.valueOf(string) + (String)enumeration.nextElement();
        }
        string = String.valueOf(string) + "; Auxiliary: ";
        enumeration = this.aux.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
            string = String.valueOf(string) + (String)enumeration.nextElement();
        }
        string = String.valueOf(string) + "; Precluded: ";
        enumeration = this.not.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = String.valueOf(string) + ", ";
            }
            ++n;
            string = String.valueOf(string) + (String)enumeration.nextElement();
        }
        if (this.isObsolete()) {
            string = String.valueOf(string) + "; OBSOLETE";
        }
        string = String.valueOf(string) + this.getQualifierString(IGNOREVALS);
        return string;
    }

    protected String vectorToList(Vector vector) {
        String string = "( ";
        int n = 0;
        while (n < vector.size()) {
            string = String.valueOf(string) + (String)vector.elementAt(n) + ' ';
            if (n < vector.size() - 1) {
                string = String.valueOf(string) + "$ ";
            }
            ++n;
        }
        string = String.valueOf(string) + ')';
        return string;
    }
}

