/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.ber.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.ldap.ber.stream.BERElement;

public class BERReal
extends BERElement {
    public static final float PLUS_INFINITY = Float.POSITIVE_INFINITY;
    public static final float MINUS_INFINITY = Float.NEGATIVE_INFINITY;
    private float m_value = 0.0f;

    public BERReal(float f) {
        this.m_value = f;
    }

    public BERReal(InputStream inputStream, int[] nArray) throws IOException {
        int n = BERElement.readLengthOctets(inputStream, nArray);
        if (n == 0) {
            this.m_value = 0.0f;
        } else {
            int n2 = inputStream.read();
            nArray[0] = nArray[0] + 1;
            if (n2 == 64) {
                this.m_value = Float.POSITIVE_INFINITY;
            } else if (n2 == 65) {
                this.m_value = Float.NEGATIVE_INFINITY;
            } else if ((n2 & 0x80) > 0) {
                int n3;
                int n4;
                int n5 = (n2 & 0x40) > 0 ? -1 : 1;
                int n6 = (n2 & 0x20) > 0 ? ((n2 & 0x10) > 0 ? 0 : 16) : ((n2 & 0x10) > 0 ? 8 : 2);
                int n7 = (n2 & 8) > 0 ? ((n2 & 4) > 0 ? 3 : 2) : ((n2 & 4) > 0 ? 1 : 0);
                if ((n2 & 2) > 0) {
                    if ((n2 & 1) > 0) {
                        n4 = inputStream.read();
                        nArray[0] = nArray[0] + 1;
                        n3 = this.readTwosComplement(inputStream, nArray, n4);
                    } else {
                        n4 = 3;
                        n3 = this.readTwosComplement(inputStream, nArray, n4);
                    }
                } else if ((n2 & 1) > 0) {
                    n4 = 2;
                    n3 = this.readTwosComplement(inputStream, nArray, n4);
                } else {
                    n4 = 1;
                    n3 = this.readTwosComplement(inputStream, nArray, n4);
                }
                int n8 = n - 1 - n4;
                int n9 = this.readUnsignedBinary(inputStream, nArray, n8);
                int n10 = (int)((double)(n5 * n9) * Math.pow(2.0, n7));
                this.m_value = (float)n10 * (float)Math.pow(n6, n3);
            } else {
                throw new IOException("real ISO6093 not supported. ");
            }
        }
    }

    public int getType() {
        return 9;
    }

    public String toString() {
        return "Real {" + this.m_value + "}";
    }

    public void write(OutputStream outputStream) throws IOException {
        if (this.m_value == 0.0f) {
            outputStream.write(9);
            outputStream.write(0);
        } else if (this.m_value == Float.POSITIVE_INFINITY) {
            outputStream.write(9);
            outputStream.write(1);
            outputStream.write(64);
        } else if (this.m_value == Float.NEGATIVE_INFINITY) {
            outputStream.write(9);
            outputStream.write(1);
            outputStream.write(65);
        }
    }
}

