/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERBoolean;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERIntegral;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;
import netscape.ldap.controls.LDAPEntryChangeControl;

public class LDAPPersistSearchControl
extends LDAPControl {
    private int m_changeTypes = 1;
    private boolean m_changesOnly = false;
    private boolean m_returnECs = false;
    public static final int ADD = 1;
    public static final int DELETE = 2;
    public static final int MODIFY = 4;
    public static final int MODDN = 8;
    public static final String PERSISTENTSEARCH = "2.16.840.1.113730.3.4.3";

    public LDAPPersistSearchControl() {
        super(PERSISTENTSEARCH, true, null);
    }

    public LDAPPersistSearchControl(int n, boolean bl, boolean bl2, boolean bl3) {
        super(PERSISTENTSEARCH, bl3, null);
        this.m_value = this.createPersistSearchSpecification(n, bl, bl2);
        this.m_changeTypes = n;
        this.m_changesOnly = bl;
        this.m_returnECs = bl2;
    }

    private byte[] createPersistSearchSpecification(int n, boolean bl, boolean bl2) {
        BERSequence bERSequence = new BERSequence();
        bERSequence.addElement(new BERInteger(n));
        bERSequence.addElement(new BERBoolean(bl));
        bERSequence.addElement(new BERBoolean(bl2));
        return this.flattenBER(bERSequence);
    }

    public int getChangeTypes() {
        return this.m_changeTypes;
    }

    public boolean getChangesOnly() {
        return this.m_changesOnly;
    }

    public boolean getReturnControls() {
        return this.m_returnECs;
    }

    public LDAPEntryChangeControl parseResponse(byte[] byArray) {
        LDAPEntryChangeControl lDAPEntryChangeControl = new LDAPEntryChangeControl();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BERSequence bERSequence = new BERSequence();
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        int[] nArray = new int[]{0};
        try {
            BERElement bERElement;
            BERSequence bERSequence2 = (BERSequence)BERElement.getElement(jDAPBERTagDecoder, byteArrayInputStream, nArray);
            BEREnumerated bEREnumerated = (BEREnumerated)bERSequence2.elementAt(0);
            lDAPEntryChangeControl.setChangeType(bEREnumerated.getValue());
            if (bERSequence2.size() > 1) {
                if (bERSequence2.elementAt(1) instanceof BEROctetString) {
                    bERElement = (BEROctetString)bERSequence2.elementAt(1);
                    lDAPEntryChangeControl.setPreviousDN(new String(((BEROctetString)bERElement).getValue(), "UTF8"));
                } else if (bERSequence2.elementAt(1) instanceof BERInteger) {
                    bERElement = (BERInteger)bERSequence2.elementAt(1);
                    lDAPEntryChangeControl.setChangeNumber(((BERIntegral)bERElement).getValue());
                }
            }
            if (bERSequence2.size() > 2) {
                bERElement = (BERInteger)bERSequence2.elementAt(2);
                lDAPEntryChangeControl.setChangeNumber(((BERIntegral)bERElement).getValue());
            }
        }
        catch (Exception exception) {
            return null;
        }
        return lDAPEntryChangeControl;
    }

    public static LDAPEntryChangeControl parseResponse(LDAPControl[] lDAPControlArray) {
        LDAPPersistSearchControl lDAPPersistSearchControl = new LDAPPersistSearchControl();
        int n = 0;
        while (lDAPControlArray != null && n < lDAPControlArray.length) {
            if (lDAPControlArray[n].getID().equals("2.16.840.1.113730.3.4.7")) {
                return lDAPPersistSearchControl.parseResponse(lDAPControlArray[n].getValue());
            }
            ++n;
        }
        return null;
    }

    public void setChangeTypes(int n) {
        this.m_changeTypes = n;
    }

    public void setChangesOnly(boolean bl) {
        this.m_changesOnly = bl;
    }

    public void setReturnControls(boolean bl) {
        this.m_returnECs = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{PersistSearchCtrl:");
        stringBuffer.append(" isCritical=");
        stringBuffer.append(this.isCritical());
        stringBuffer.append(" returnEntryChangeCtrls=");
        stringBuffer.append(this.m_returnECs);
        stringBuffer.append(" changesOnly=");
        stringBuffer.append(this.m_changesOnly);
        stringBuffer.append(" changeTypes=");
        stringBuffer.append(LDAPPersistSearchControl.typesToString(this.m_changeTypes));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static String typesToString(int n) {
        String string = "";
        if ((n & 1) != 0) {
            string = String.valueOf(string) + (string.length() > 0 ? "+ADD" : "ADD");
        }
        if ((n & 2) != 0) {
            string = String.valueOf(string) + (string.length() > 0 ? "+DEL" : "DEL");
        }
        if ((n & 4) != 0) {
            string = String.valueOf(string) + (string.length() > 0 ? "+MOD" : "MOD");
        }
        if ((n & 8) != 0) {
            string = String.valueOf(string) + (string.length() > 0 ? "+MODDN" : "MODDN");
        }
        return string;
    }
}

