/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.row.RowMetaInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseRowSet
implements Comparable<RowSet>,
RowSet {
    protected RowMetaInterface rowMeta;
    protected AtomicBoolean done = new AtomicBoolean(false);
    protected String originStepName;
    protected AtomicInteger originStepCopy = new AtomicInteger(0);
    protected String destinationStepName;
    protected AtomicInteger destinationStepCopy = new AtomicInteger(0);
    protected String remoteSlaveServerName;

    @Override
    public int compareTo(RowSet rowSet) {
        String target = this.remoteSlaveServerName + "." + this.destinationStepName + "." + this.destinationStepCopy.intValue();
        String comp = rowSet.getRemoteSlaveServerName() + "." + rowSet.getDestinationStepName() + "." + rowSet.getDestinationStepCopy();
        return target.compareTo(comp);
    }

    public boolean equals(BaseRowSet rowSet) {
        return this.compareTo(rowSet) == 0;
    }

    @Override
    public abstract boolean putRow(RowMetaInterface var1, Object[] var2);

    @Override
    public abstract boolean putRowWait(RowMetaInterface var1, Object[] var2, long var3, TimeUnit var5);

    @Override
    public abstract Object[] getRow();

    @Override
    public abstract Object[] getRowImmediate();

    @Override
    public abstract Object[] getRowWait(long var1, TimeUnit var3);

    @Override
    public void setDone() {
        this.done.set(true);
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOriginStepName() {
        String string = this.originStepName;
        synchronized (string) {
            return this.originStepName;
        }
    }

    @Override
    public int getOriginStepCopy() {
        return this.originStepCopy.get();
    }

    @Override
    public String getDestinationStepName() {
        return this.destinationStepName;
    }

    @Override
    public int getDestinationStepCopy() {
        return this.destinationStepCopy.get();
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public abstract int size();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setThreadNameFromToCopy(String from, int from_copy, String to, int to_copy) {
        String string;
        if (this.originStepName == null) {
            this.originStepName = from;
        } else {
            string = this.originStepName;
            synchronized (string) {
                this.originStepName = from;
            }
        }
        this.originStepCopy.set(from_copy);
        if (this.destinationStepName == null) {
            this.destinationStepName = to;
        } else {
            string = this.destinationStepName;
            synchronized (string) {
                this.destinationStepName = to;
            }
        }
        this.destinationStepCopy.set(to_copy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer str;
        Object object = this.originStepName;
        synchronized (object) {
            str = new StringBuffer(this.originStepName);
        }
        str.append(".");
        object = this.originStepCopy;
        synchronized (object) {
            str.append(this.originStepCopy);
        }
        str.append(" - ");
        object = this.destinationStepName;
        synchronized (object) {
            str.append(this.destinationStepName);
        }
        str.append(".");
        object = this.destinationStepCopy;
        synchronized (object) {
            str.append(this.destinationStepCopy);
        }
        if (!Const.isEmpty(this.remoteSlaveServerName)) {
            object = this.remoteSlaveServerName;
            synchronized (object) {
                str.append(" (");
                str.append(this.remoteSlaveServerName);
                str.append(")");
            }
        }
        return str.toString();
    }

    @Override
    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }

    @Override
    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    @Override
    public String getRemoteSlaveServerName() {
        return this.remoteSlaveServerName;
    }

    @Override
    public void setRemoteSlaveServerName(String remoteSlaveServerName) {
        this.remoteSlaveServerName = remoteSlaveServerName;
    }

    @Override
    public boolean isBlocking() {
        return false;
    }
}

