/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.pentaho.di.core.BaseRowSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.row.RowMetaInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlockingRowSet
extends BaseRowSet
implements Comparable<RowSet>,
RowSet {
    private BlockingQueue<Object[]> queArray;
    private int timeoutPut;
    private int timeoutGet;

    public BlockingRowSet(int maxSize) {
        this.queArray = new ArrayBlockingQueue<Object[]>(maxSize, false);
        this.timeoutGet = Const.toInt(System.getProperty("KETTLE_ROWSET_GET_TIMEOUT"), 50);
        this.timeoutPut = Const.toInt(System.getProperty("KETTLE_ROWSET_PUT_TIMEOUT"), 50);
    }

    @Override
    public boolean putRow(RowMetaInterface rowMeta, Object[] rowData) {
        return this.putRowWait(rowMeta, rowData, this.timeoutPut, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean putRowWait(RowMetaInterface rowMeta, Object[] rowData, long time, TimeUnit tu) {
        this.rowMeta = rowMeta;
        try {
            return this.queArray.offer(rowData, time, tu);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public Object[] getRow() {
        return this.getRowWait(this.timeoutGet, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object[] getRowImmediate() {
        return (Object[])this.queArray.poll();
    }

    @Override
    public Object[] getRowWait(long timeout, TimeUnit tu) {
        try {
            return this.queArray.poll(timeout, tu);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public int size() {
        return this.queArray.size();
    }
}

