/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCacheEntry;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;

public class DBCache {
    private static DBCache dbCache;
    private Hashtable<DBCacheEntry, RowMetaInterface> cache;
    private boolean usecache;
    private LogChannelInterface log;

    public void setActive() {
        this.setActive(true);
    }

    public void setInactive() {
        this.setActive(false);
    }

    public void setActive(boolean act) {
        this.usecache = act;
    }

    public boolean isActive() {
        return this.usecache;
    }

    public void put(DBCacheEntry entry, RowMetaInterface fields) {
        if (!this.usecache) {
            return;
        }
        RowMetaInterface copy = fields.clone();
        this.cache.put(entry, copy);
    }

    public RowMetaInterface get(DBCacheEntry entry) {
        if (!this.usecache) {
            return null;
        }
        RowMetaInterface fields = this.cache.get(entry);
        if (fields != null) {
            fields = fields.clone();
        }
        return fields;
    }

    public int size() {
        return this.cache.size();
    }

    public void clear(String dbname) {
        if (dbname == null) {
            this.cache = new Hashtable();
            this.setActive();
        } else {
            Enumeration<DBCacheEntry> keys = this.cache.keys();
            while (keys.hasMoreElements()) {
                DBCacheEntry entry = keys.nextElement();
                if (!entry.sameDB(dbname)) continue;
                this.cache.remove(entry);
            }
        }
    }

    public String getFilename() {
        return Const.getKettleDirectory() + Const.FILE_SEPARATOR + "db.cache";
    }

    private DBCache() throws KettleFileException {
        block12: {
            try {
                this.clear(null);
                this.log = new LogChannel("DBCache");
                String filename = this.getFilename();
                File file = new File(filename);
                if (file.canRead()) {
                    this.log.logDetailed("Loading database cache from file: [" + filename + "]");
                    FileInputStream fis = null;
                    FilterInputStream dis = null;
                    try {
                        fis = new FileInputStream(file);
                        dis = new DataInputStream(fis);
                        int counter = 0;
                        try {
                            while (true) {
                                DBCacheEntry entry = new DBCacheEntry((DataInputStream)dis);
                                RowMeta row = new RowMeta((DataInputStream)dis);
                                this.cache.put(entry, row);
                                ++counter;
                            }
                        }
                        catch (KettleEOFException eof) {
                            this.log.logDetailed("We read " + counter + " cached rows from the database cache!");
                            if (dis != null) {
                                dis.close();
                            }
                            break block12;
                        }
                    }
                    catch (Exception e) {
                        try {
                            throw new Exception(e);
                        }
                        catch (Throwable throwable) {
                            if (dis != null) {
                                dis.close();
                            }
                            throw throwable;
                        }
                    }
                }
                this.log.logDetailed("The database cache doesn't exist yet.");
            }
            catch (Exception e) {
                throw new KettleFileException("Couldn't read the database cache", e);
            }
        }
    }

    public void saveCache() throws KettleFileException {
        block11: {
            try {
                String filename = this.getFilename();
                File file = new File(filename);
                if (!file.exists() || file.canWrite()) {
                    FileOutputStream fos = null;
                    FilterOutputStream dos = null;
                    try {
                        fos = new FileOutputStream(file);
                        dos = new DataOutputStream(new BufferedOutputStream(fos, 10000));
                        int counter = 0;
                        boolean ok = true;
                        Enumeration<DBCacheEntry> keys = this.cache.keys();
                        while (ok && keys.hasMoreElements()) {
                            DBCacheEntry entry = keys.nextElement();
                            entry.write((DataOutputStream)dos);
                            RowMetaInterface rowMeta = this.get(entry);
                            if (rowMeta != null) {
                                rowMeta.writeMeta((DataOutputStream)dos);
                                ++counter;
                                continue;
                            }
                            throw new KettleFileException("The database cache contains an empty row. We can't save this!");
                        }
                        this.log.logDetailed("We wrote " + counter + " cached rows to the database cache!");
                        break block11;
                    }
                    catch (Exception e) {
                        throw new Exception(e);
                    }
                    finally {
                        if (dos != null) {
                            dos.close();
                        }
                    }
                }
                throw new KettleFileException("We can't write to the cache file: " + filename);
            }
            catch (Exception e) {
                throw new KettleFileException("Couldn't write to the database cache", e);
            }
        }
    }

    public static final DBCache getInstance() {
        if (dbCache != null) {
            return dbCache;
        }
        try {
            dbCache = new DBCache();
        }
        catch (KettleFileException kfe) {
            throw new RuntimeException("Unable to create the database cache: " + kfe.getMessage());
        }
        return dbCache;
    }
}

