/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.BufferLine;
import org.pentaho.di.core.logging.Log4jKettleLayout;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.LoggingRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log4jBufferAppender
implements Appender {
    private Layout layout;
    private Filter filter;
    private String name;
    private List<BufferLine> buffer;
    private int bufferSize;

    public Log4jBufferAppender(int bufferSize) {
        this.bufferSize = bufferSize;
        this.buffer = Collections.synchronizedList(new LinkedList());
        this.layout = new Log4jKettleLayout(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastBufferLineNr() {
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            if (this.buffer.size() > 0) {
                return this.buffer.get(this.buffer.size() - 1).getNr();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoggingEvent> getLogBufferFromTo(List<String> channelId, boolean includeGeneral, int from, int to) {
        ArrayList<LoggingEvent> lines = new ArrayList<LoggingEvent>();
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            for (BufferLine line : this.buffer) {
                boolean include;
                Object payload;
                if (line.getNr() <= from || line.getNr() > to || !((payload = line.getEvent().getMessage()) instanceof LogMessage)) continue;
                LogMessage message = (LogMessage)payload;
                boolean bl = include = channelId == null;
                if (!include) {
                    LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(message.getLogChannelId());
                    if (loggingObject != null && includeGeneral && LoggingObjectType.GENERAL.equals((Object)loggingObject.getObjectType())) {
                        include = true;
                    }
                    if (!include) {
                        for (String id : channelId) {
                            if (!message.getLogChannelId().equals(id)) continue;
                            include = true;
                            break;
                        }
                    }
                }
                if (!include) continue;
                try {
                    lines.add(line.getEvent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return lines;
    }

    public List<LoggingEvent> getLogBufferFromTo(String parentLogChannelId, boolean includeGeneral, int from, int to) {
        List<String> childIds = LoggingRegistry.getInstance().getLogChannelChildren(parentLogChannelId);
        return this.getLogBufferFromTo(childIds, includeGeneral, from, to);
    }

    public StringBuffer getBuffer(String parentLogChannelId, boolean includeGeneral, int startLineNr, int endLineNr) {
        StringBuffer stringBuffer = new StringBuffer(10000);
        List<LoggingEvent> events = this.getLogBufferFromTo(parentLogChannelId, includeGeneral, startLineNr, endLineNr);
        for (LoggingEvent event : events) {
            stringBuffer.append(this.layout.format(event)).append(Const.CR);
        }
        return stringBuffer;
    }

    public StringBuffer getBuffer(String parentLogChannelId, boolean includeGeneral) {
        return this.getBuffer(parentLogChannelId, includeGeneral, 0);
    }

    public StringBuffer getBuffer(String parentLogChannelId, boolean includeGeneral, int startLineNr) {
        return this.getBuffer(parentLogChannelId, includeGeneral, startLineNr, this.getLastBufferLineNr());
    }

    public StringBuffer getBuffer() {
        return this.getBuffer(null, true);
    }

    public void addFilter(Filter filter) {
        this.filter = filter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void clearFilters() {
        this.filter = null;
    }

    public void close() {
    }

    public void doAppend(LoggingEvent event) {
        this.buffer.add(new BufferLine(event));
        if (this.bufferSize > 0 && this.buffer.size() > this.bufferSize) {
            this.buffer.remove(0);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void clear() {
        this.buffer.clear();
    }

    public int getMaxNrLines() {
        return this.bufferSize;
    }

    public void setMaxNrLines(int maxNrLines) {
        this.bufferSize = maxNrLines;
    }

    public int getNrLines() {
        return this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannelFromBuffer(String id) {
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            Iterator<BufferLine> iterator = this.buffer.iterator();
            while (iterator.hasNext()) {
                LogMessage message;
                BufferLine bufferLine = iterator.next();
                Object payload = bufferLine.getEvent().getMessage();
                if (!(payload instanceof LogMessage) || !id.equals((message = (LogMessage)payload).getLogChannelId())) continue;
                iterator.remove();
            }
        }
    }

    public int size() {
        return this.buffer.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGeneralMessages() {
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            Iterator<BufferLine> iterator = this.buffer.iterator();
            while (iterator.hasNext()) {
                BufferLine bufferLine = iterator.next();
                Object payload = bufferLine.getEvent().getMessage();
                if (!(payload instanceof LogMessage)) continue;
                LogMessage message = (LogMessage)payload;
                LoggingObjectInterface loggingObject = LoggingRegistry.getInstance().getLoggingObject(message.getLogChannelId());
                if (loggingObject == null || !LoggingObjectType.GENERAL.equals((Object)loggingObject.getObjectType())) continue;
                iterator.remove();
            }
        }
    }

    public Iterator<BufferLine> getBufferIterator() {
        return this.buffer.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        StringBuffer buf = new StringBuffer(50000);
        List<BufferLine> list = this.buffer;
        synchronized (list) {
            for (BufferLine line : this.buffer) {
                Object payload = line.getEvent().getMessage();
                if (!(payload instanceof LogMessage)) continue;
                LogMessage message = (LogMessage)payload;
                buf.append(message.getLogChannelId() + "\t" + message.getSubject() + "\t" + message.getMessage() + "\n");
            }
        }
        return buf.toString();
    }
}

