/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import org.apache.commons.vfs.FileObject;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.Log4jBufferAppender;
import org.pentaho.di.core.logging.Log4jConsoleAppender;
import org.pentaho.di.core.logging.Log4jFileAppender;
import org.pentaho.di.core.logging.Log4jKettleLayout;
import org.pentaho.di.core.logging.Log4jStringAppender;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LogMessage;
import org.pentaho.di.core.logging.LogMessageInterface;
import org.pentaho.di.core.vfs.KettleVFS;

public class LogWriter {
    private static LogWriter logWriter;
    public static final String STRING_PENTAHO_DI_LOGGER_NAME = "org.pentaho.di";
    public static final String STRING_PENTAHO_DI_CONSOLE_APPENDER = "ConsoleAppender:org.pentaho.di";
    private int type;
    private String filter;
    private Logger pentahoLogger = Logger.getLogger((String)"org.pentaho.di");
    private Log4jFileAppender fileAppender;
    private File realFilename;
    private static Layout layout;

    public static final synchronized LogWriter getInstance() {
        if (logWriter != null) {
            return logWriter;
        }
        logWriter = new LogWriter();
        return logWriter;
    }

    private LogWriter() {
        this.pentahoLogger.setAdditivity(false);
        this.pentahoLogger.setLevel(Level.ALL);
        layout = new Log4jKettleLayout();
        boolean consoleAppenderFound = false;
        Enumeration appenders = this.pentahoLogger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof ConsoleAppender)) continue;
            consoleAppenderFound = true;
            break;
        }
        if (!consoleAppenderFound) {
            PatternLayout patternLayout = new PatternLayout("%-5p %d{dd-MM HH:mm:ss,SSS} - %m%n");
            ConsoleAppender consoleAppender = new ConsoleAppender((Layout)patternLayout);
            consoleAppender.setName(STRING_PENTAHO_DI_CONSOLE_APPENDER);
            this.pentahoLogger.addAppender((Appender)consoleAppender);
        }
        LogManager.getLogger((String)"org.apache.commons.vfs").setLevel(Level.WARN);
    }

    public static final synchronized LogWriter getInstance(String filename, boolean exact) throws KettleException {
        if (logWriter != null) {
            if (LogWriter.logWriter.pentahoLogger.getAppender(LogWriter.createFileAppenderName(filename, exact)) == null) {
                LogWriter.logWriter.fileAppender = LogWriter.createFileAppender(filename, exact);
                logWriter.addAppender(LogWriter.logWriter.fileAppender);
            }
            return logWriter;
        }
        logWriter = new LogWriter(filename, exact);
        return logWriter;
    }

    public static final void closeAndRemoveFileAppender() {
        if (LogWriter.logWriter.fileAppender != null) {
            LogWriter.logWriter.fileAppender.close();
            LogWriter.logWriter.pentahoLogger.removeAppender((Appender)LogWriter.logWriter.fileAppender);
        }
    }

    private LogWriter(String filename, boolean exact) {
        this();
        try {
            this.fileAppender = LogWriter.createFileAppender(filename, exact);
            this.addAppender(this.fileAppender);
        }
        catch (Exception e) {
            System.out.println("ERROR OPENING LOG FILE [" + filename + "] --> " + e.toString());
        }
    }

    public static final Log4jFileAppender createFileAppender(String filename, boolean exact) throws KettleFileException {
        try {
            FileObject file = !exact ? KettleVFS.createTempFile(filename, ".log", System.getProperty("java.io.tmpdir")) : KettleVFS.getFileObject(filename);
            Log4jFileAppender appender = new Log4jFileAppender(file);
            appender.setLayout(new Log4jKettleLayout(true));
            appender.setName(LogWriter.createFileAppenderName(filename, exact));
            return appender;
        }
        catch (IOException e) {
            throw new KettleFileException("Unable to add Kettle file appender to Log4J", e);
        }
    }

    public static final Log4jFileAppender createFileAppender(String filename, boolean exact, boolean append) throws KettleFileException {
        try {
            FileObject file = !exact ? KettleVFS.createTempFile(filename, ".log", System.getProperty("java.io.tmpdir")) : KettleVFS.getFileObject(filename);
            Log4jFileAppender appender = new Log4jFileAppender(file, append);
            appender.setLayout(new Log4jKettleLayout(true));
            appender.setName(LogWriter.createFileAppenderName(filename, exact));
            return appender;
        }
        catch (IOException e) {
            throw new KettleFileException("Unable to add Kettle file appender to Log4J", e);
        }
    }

    public static final String createFileAppenderName(String filename, boolean exact) {
        if (!exact) {
            return "<temp file> : " + filename;
        }
        return filename;
    }

    public static final Log4jStringAppender createStringAppender() {
        Log4jStringAppender appender = new Log4jStringAppender();
        appender.setLayout(new Log4jKettleLayout(true));
        return appender;
    }

    public static void setConsoleAppenderDebug() {
        Enumeration appenders = Logger.getLogger((String)STRING_PENTAHO_DI_LOGGER_NAME).getAllAppenders();
        while (appenders.hasMoreElements()) {
            Object appender = appenders.nextElement();
            if (!(appender instanceof ConsoleAppender) && !(appender instanceof Log4jConsoleAppender) || !(appender instanceof ConsoleAppender)) continue;
            ((ConsoleAppender)appender).setThreshold((Priority)Level.DEBUG);
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean close() {
        boolean retval = true;
        try {
            Logger logger = Logger.getLogger((String)STRING_PENTAHO_DI_LOGGER_NAME);
            Enumeration appenders = logger.getAllAppenders();
            while (appenders.hasMoreElements()) {
                Appender appender = (Appender)appenders.nextElement();
                appender.close();
            }
            this.pentahoLogger.removeAllAppenders();
            LogWriter.unsetLogWriter();
        }
        catch (Exception e) {
            retval = false;
        }
        return retval;
    }

    private static synchronized void unsetLogWriter() {
        logWriter = null;
    }

    public void println(LogMessageInterface logMessage, LogLevel channelLogLevel) {
        String subject = null;
        LogLevel logLevel = logMessage.getLevel();
        if (!logLevel.isVisible(channelLogLevel)) {
            return;
        }
        if (subject == null) {
            subject = "Kettle";
        }
        if (!logLevel.isError() && !Const.isEmpty(this.filter) && subject.indexOf(this.filter) < 0 && logMessage.toString().indexOf(this.filter) < 0) {
            return;
        }
        switch (logLevel) {
            case ERROR: {
                this.pentahoLogger.error((Object)logMessage);
                break;
            }
            case ROWLEVEL: 
            case DEBUG: {
                this.pentahoLogger.debug((Object)logMessage);
                break;
            }
            default: {
                this.pentahoLogger.info((Object)logMessage);
            }
        }
    }

    public void println(LogMessageInterface message, Throwable e, LogLevel channelLogLevel) {
        this.println(message, channelLogLevel);
        String stackTrace = Const.getStackTracker(e);
        LogMessage traceMessage = new LogMessage(stackTrace, message.getLogChannelId(), LogLevel.ERROR);
        this.println(traceMessage, channelLogLevel);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getFilter() {
        return this.filter;
    }

    public InputStream getFileInputStream() throws IOException {
        return KettleVFS.getInputStream(this.fileAppender.getFile());
    }

    public FileObject getFileAppenderFile() throws IOException {
        return this.fileAppender.getFile();
    }

    public FileInputStream getFileInputStream(String filename, boolean exact) throws IOException {
        Appender appender = this.pentahoLogger.getAppender(LogWriter.createFileAppenderName(filename, exact));
        if (appender == null) {
            throw new IOException("Unable to find appender for file: " + filename + " (exact=" + exact + ")");
        }
        return new FileInputStream(((Log4jFileAppender)appender).getFile().getName().getPathDecoded());
    }

    public File getRealFilename() {
        return this.realFilename;
    }

    public void setRealFilename(File realFilename) {
        this.realFilename = realFilename;
    }

    public void addAppender(Appender appender) {
        this.pentahoLogger.addAppender(appender);
    }

    public void removeAppender(Appender appender) {
        this.pentahoLogger.removeAppender(appender);
    }

    public static void setLayout(Layout layout) {
        LogWriter.layout = layout;
        Enumeration appenders = LogWriter.logWriter.pentahoLogger.getAllAppenders();
        while (appenders.hasMoreElements()) {
            Appender appender = (Appender)appenders.nextElement();
            if (!(appender instanceof Log4jConsoleAppender) && !(appender instanceof Log4jFileAppender) && !(appender instanceof Log4jBufferAppender)) continue;
            appender.setLayout(layout);
        }
    }

    public static Layout getLayout() {
        return layout;
    }
}

