/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LoggingObject;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.util.EnvUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingRegistry {
    private static LoggingRegistry registry;
    private Map<String, LoggingObjectInterface> map = new ConcurrentHashMap<String, LoggingObjectInterface>();
    private Map<String, List<String>> childrenMap = new ConcurrentHashMap<String, List<String>>();
    private Date lastModificationTime = new Date();
    private int maxSize = Const.toInt(EnvUtil.getSystemProperty("KETTLE_MAX_LOGGING_REGISTRY_SIZE"), 10000);
    private final int DEFAULT_MAX_SIZE = 10000;

    private LoggingRegistry() {
    }

    public static LoggingRegistry getInstance() {
        if (registry != null) {
            return registry;
        }
        registry = new LoggingRegistry();
        return registry;
    }

    public String registerLoggingSource(Object object) {
        String parentLogChannelId;
        this.maxSize = Const.toInt(EnvUtil.getSystemProperty("KETTLE_MAX_LOGGING_REGISTRY_SIZE"), 10000);
        LoggingObject loggingSource = new LoggingObject(object);
        LoggingObjectInterface found = this.findExistingLoggingSource(loggingSource);
        if (found != null && found.getParent() != null) {
            return found.getLogChannelId();
        }
        String logChannelId = UUID.randomUUID().toString();
        loggingSource.setLogChannelId(logChannelId);
        this.map.put(logChannelId, loggingSource);
        if (loggingSource.getParent() != null && (parentLogChannelId = loggingSource.getParent().getLogChannelId()) != null) {
            List<String> parentChildren = this.childrenMap.get(parentLogChannelId);
            if (parentChildren == null) {
                parentChildren = new ArrayList<String>();
                this.childrenMap.put(parentLogChannelId, parentChildren);
            }
            parentChildren.add(logChannelId);
        }
        this.lastModificationTime = new Date();
        loggingSource.setRegistrationDate(this.lastModificationTime);
        if (this.maxSize > 0 && this.map.size() > this.maxSize) {
            ArrayList<LoggingObjectInterface> all = new ArrayList<LoggingObjectInterface>(this.map.values());
            Collections.sort(all, new Comparator<LoggingObjectInterface>(){

                @Override
                public int compare(LoggingObjectInterface o1, LoggingObjectInterface o2) {
                    if (o1 == null && o2 != null) {
                        return -1;
                    }
                    if (o1 != null && o2 == null) {
                        return 1;
                    }
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    return o1.getRegistrationDate().compareTo(o2.getRegistrationDate());
                }
            });
            int cutCount = this.maxSize < 1000 ? this.maxSize : 1000;
            for (int i = 0; i < cutCount; ++i) {
                LoggingObjectInterface toRemove = (LoggingObjectInterface)all.get(i);
                this.map.remove(toRemove.getLogChannelId());
                this.childrenMap.remove(toRemove.getLogChannelId());
            }
        }
        return logChannelId;
    }

    public LoggingObjectInterface findExistingLoggingSource(LoggingObjectInterface loggingObject) {
        LoggingObjectInterface found = null;
        for (LoggingObjectInterface verify : this.map.values()) {
            if (!loggingObject.equals(verify)) continue;
            found = verify;
            break;
        }
        return found;
    }

    public LoggingObjectInterface getLoggingObject(String logChannelId) {
        return this.map.get(logChannelId);
    }

    public Map<String, LoggingObjectInterface> getMap() {
        return this.map;
    }

    public List<String> getLogChannelChildren(String parentLogChannelId) {
        if (parentLogChannelId == null) {
            return null;
        }
        List<String> list = this.getLogChannelChildren(new ArrayList<String>(), parentLogChannelId);
        list.add(parentLogChannelId);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getLogChannelChildren(List<String> children, String parentLogChannelId) {
        Map<String, List<String>> map = this.childrenMap;
        synchronized (map) {
            List<String> list = this.childrenMap.get(parentLogChannelId);
            if (list == null) {
                list = new ArrayList<String>();
                children.add(parentLogChannelId);
                return list;
            }
            for (String logChannelId : list) {
                if (this.getLogChannelChildren(children, logChannelId) == null) continue;
                children.add(logChannelId);
            }
        }
        return children;
    }

    public Date getLastModificationTime() {
        return this.lastModificationTime;
    }

    public String dump(boolean includeGeneral) {
        StringBuffer out = new StringBuffer(50000);
        for (LoggingObjectInterface o : this.map.values()) {
            if (!includeGeneral && o.getObjectType().equals((Object)LoggingObjectType.GENERAL)) continue;
            out.append(o.getContainerObjectId());
            out.append("\t");
            out.append(o.getLogChannelId());
            out.append("\t");
            out.append(o.getObjectType().name());
            out.append("\t");
            out.append(o.getObjectName());
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getLogChannelId() : "-");
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getObjectType().name() : "-");
            out.append("\t");
            out.append(o.getParent() != null ? o.getParent().getObjectName() : "-");
            out.append("\n");
        }
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIncludingChildren(String logChannelId) {
        Map<String, LoggingObjectInterface> map = this.map;
        synchronized (map) {
            List<String> children = this.getLogChannelChildren(logChannelId);
            for (String child : children) {
                this.map.remove(child);
            }
            this.map.remove(logChannelId);
        }
    }
}

