/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.JarFileCache;
import org.pentaho.di.core.plugins.KettleURLClassLoader;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginTypeCategoriesOrder;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.row.RowBuffer;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.i18n.BaseMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginRegistry {
    private static Class<?> PKG = PluginRegistry.class;
    private static PluginRegistry pluginRegistry;
    private Map<Class<? extends PluginTypeInterface>, List<PluginInterface>> pluginMap;
    private Map<String, URLClassLoader> folderBasedClassLoaderMap = new HashMap<String, URLClassLoader>();
    private Map<Class<? extends PluginTypeInterface>, Map<PluginInterface, URLClassLoader>> classLoaderMap;
    private Map<Class<? extends PluginTypeInterface>, List<String>> categoryMap;
    private static List<PluginTypeInterface> pluginTypes;

    private PluginRegistry() {
        this.pluginMap = new HashMap<Class<? extends PluginTypeInterface>, List<PluginInterface>>();
        this.classLoaderMap = new HashMap<Class<? extends PluginTypeInterface>, Map<PluginInterface, URLClassLoader>>();
        this.categoryMap = new HashMap<Class<? extends PluginTypeInterface>, List<String>>();
    }

    public static synchronized PluginRegistry getInstance() {
        if (pluginRegistry == null) {
            pluginRegistry = new PluginRegistry();
        }
        return pluginRegistry;
    }

    public synchronized void registerPluginType(Class<? extends PluginTypeInterface> pluginType) {
        this.pluginMap.put(pluginType, new ArrayList());
        if (this.categoryMap.get(pluginType) == null) {
            ArrayList categories = new ArrayList();
            this.categoryMap.put(pluginType, categories);
        }
    }

    public synchronized void registerPlugin(Class<? extends PluginTypeInterface> pluginType, PluginInterface plugin) throws KettlePluginException {
        List<String> categories;
        int index;
        if (plugin.getIds()[0] == null) {
            throw new KettlePluginException("Not a valid id specified in plugin :" + plugin);
        }
        List<PluginInterface> list = this.pluginMap.get(pluginType);
        if (list == null) {
            list = new ArrayList<PluginInterface>();
            this.pluginMap.put(pluginType, list);
        }
        if ((index = list.indexOf(plugin)) < 0) {
            list.add(plugin);
        } else {
            list.set(index, plugin);
        }
        Collections.sort(list, new Comparator<PluginInterface>(){

            @Override
            public int compare(PluginInterface p1, PluginInterface p2) {
                return p1.getName().compareToIgnoreCase(p2.getName());
            }
        });
        if (!Const.isEmpty(plugin.getCategory()) && !(categories = this.categoryMap.get(pluginType)).contains(plugin.getCategory())) {
            categories.add(plugin.getCategory());
            String[] naturalOrder = null;
            PluginTypeCategoriesOrder naturalOrderAnnotation = pluginType.getAnnotation(PluginTypeCategoriesOrder.class);
            if (naturalOrderAnnotation != null) {
                String[] naturalOrderKeys = naturalOrderAnnotation.getNaturalCategoriesOrder();
                Class<?> i18nClass = naturalOrderAnnotation.i18nPackageClass();
                naturalOrder = new String[naturalOrderKeys.length];
                for (int i = 0; i < naturalOrderKeys.length; ++i) {
                    naturalOrder[i] = BaseMessages.getString(i18nClass, naturalOrderKeys[i], new String[0]);
                }
            }
            if (naturalOrder != null) {
                final String[] fNaturalOrder = naturalOrder;
                Collections.sort(categories, new Comparator<String>(){

                    @Override
                    public int compare(String one, String two) {
                        int idx1 = Const.indexOfString(one, fNaturalOrder);
                        int idx2 = Const.indexOfString(two, fNaturalOrder);
                        return idx1 - idx2;
                    }
                });
            }
        }
    }

    public List<Class<? extends PluginTypeInterface>> getPluginTypes() {
        return Collections.unmodifiableList(new ArrayList<Class<? extends PluginTypeInterface>>(this.pluginMap.keySet()));
    }

    public <T extends PluginInterface, K extends PluginTypeInterface> List<T> getPlugins(Class<K> type) {
        ArrayList<PluginInterface> list = new ArrayList<PluginInterface>();
        List<PluginInterface> mapList = this.pluginMap.get(type);
        if (mapList != null) {
            for (PluginInterface p : mapList) {
                list.add(p);
            }
        }
        return list;
    }

    public PluginInterface getPlugin(Class<? extends PluginTypeInterface> pluginType, String id) {
        List plugins = this.getPlugins(pluginType);
        if (plugins == null) {
            return null;
        }
        for (PluginInterface plugin : plugins) {
            if (!plugin.matches(id)) continue;
            return plugin;
        }
        return null;
    }

    public <T extends PluginTypeInterface> List<PluginInterface> getPluginsByCategory(Class<T> pluginType, String pluginCategory) {
        ArrayList<PluginInterface> plugins = new ArrayList<PluginInterface>();
        for (PluginInterface verify : this.getPlugins(pluginType)) {
            if (verify.getCategory() == null || !verify.getCategory().equals(pluginCategory)) continue;
            plugins.add(verify);
        }
        return Collections.unmodifiableList(plugins);
    }

    public List<String> getCategories(Class<? extends PluginTypeInterface> pluginType) {
        List<String> categories = this.categoryMap.get(pluginType);
        return categories;
    }

    public Object loadClass(PluginInterface plugin) throws KettlePluginException {
        return this.loadClass(plugin, plugin.getMainType());
    }

    public <T> T loadClass(Class<? extends PluginTypeInterface> pluginType, Object object, Class<T> classType) throws KettlePluginException {
        PluginInterface plugin = this.getPlugin(pluginType, object);
        if (plugin == null) {
            return null;
        }
        return this.loadClass(plugin, classType);
    }

    public <T> T loadClass(Class<? extends PluginTypeInterface> pluginType, String pluginId, Class<T> classType) throws KettlePluginException {
        PluginInterface plugin = this.getPlugin(pluginType, pluginId);
        if (plugin == null) {
            return null;
        }
        return this.loadClass(plugin, classType);
    }

    public <T> T loadClass(PluginInterface plugin, Class<T> pluginClass) throws KettlePluginException {
        if (plugin == null) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidStepOrPlugin.PLUGINREGISTRY001", new String[0]));
        }
        String className = plugin.getClassMap().get(pluginClass);
        if (className == null) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidClassRequested.PLUGINREGISTRY002", pluginClass.getName()));
        }
        try {
            Class<?> cl = null;
            if (plugin.isNativePlugin()) {
                cl = Class.forName(className);
            } else {
                List<String> jarfiles = plugin.getLibraries();
                URL[] urls = new URL[jarfiles.size()];
                for (int i = 0; i < jarfiles.size(); ++i) {
                    File jarfile = new File(jarfiles.get(i));
                    urls[i] = new URL(URLDecoder.decode(jarfile.toURI().toURL().toString(), "UTF-8"));
                }
                ClassLoader classLoader = this.getClass().getClassLoader();
                URLClassLoader ucl = null;
                if (plugin.isSeparateClassLoaderNeeded()) {
                    ucl = new KettleURLClassLoader(urls, classLoader, plugin.getDescription());
                } else {
                    Map<PluginInterface, URLClassLoader> classLoaders = this.classLoaderMap.get(plugin.getPluginType());
                    if (classLoaders == null) {
                        classLoaders = new HashMap<PluginInterface, URLClassLoader>();
                        this.classLoaderMap.put(plugin.getPluginType(), classLoaders);
                    } else {
                        ucl = classLoaders.get(plugin);
                    }
                    if (ucl == null) {
                        if (plugin.getPluginDirectory() != null) {
                            ucl = this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                            if (ucl == null) {
                                ucl = new KettleURLClassLoader(urls, classLoader, plugin.getDescription());
                                classLoaders.put(plugin, ucl);
                                this.folderBasedClassLoaderMap.put(plugin.getPluginDirectory().toString(), ucl);
                            }
                        } else {
                            ucl = classLoaders.get(plugin);
                            if (ucl == null) {
                                ucl = new KettleURLClassLoader(urls, classLoader, plugin.getDescription());
                                classLoaders.put(plugin, ucl);
                            }
                        }
                    }
                }
                cl = ucl.loadClass(className);
            }
            return (T)cl.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.ClassNotFound.PLUGINREGISTRY003", new String[0]), e);
        }
        catch (InstantiationException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnableToInstantiateClass.PLUGINREGISTRY004", new String[0]), e);
        }
        catch (IllegalAccessException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.IllegalAccessToClass.PLUGINREGISTRY005", new String[0]), e);
        }
        catch (MalformedURLException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.MalformedURL.PLUGINREGISTRY006", new String[0]), e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnExpectedErrorLoadingClass.PLUGINREGISTRY007", new String[0]), e);
        }
    }

    public static void addPluginType(PluginTypeInterface type) {
        pluginTypes.add(type);
    }

    public static synchronized void init() throws KettlePluginException {
        PluginRegistry registry = PluginRegistry.getInstance();
        for (PluginTypeInterface pluginType : pluginTypes) {
            registry.registerPluginType(pluginType.getClass());
            long startScan = System.currentTimeMillis();
            pluginType.searchPlugins();
            String pluginClasses = EnvUtil.getSystemProperty("KETTLE_PLUGIN_CLASSES");
            if (!Const.isEmpty(pluginClasses)) {
                String[] classNames;
                for (String className : classNames = pluginClasses.split(",")) {
                    try {
                        PluginAnnotationType annotationType = pluginType.getClass().getAnnotation(PluginAnnotationType.class);
                        Class<? extends Annotation> annotationClass = annotationType.value();
                        Class<?> clazz = Class.forName(className);
                        Annotation annotation = clazz.getAnnotation(annotationClass);
                        if (annotation == null) continue;
                        pluginType.handlePluginAnnotation(clazz, annotation, new ArrayList<String>(), true, null);
                    }
                    catch (Exception e) {
                        LogChannel.GENERAL.logError("Error registring plugin class from KETTLE_PLUGIN_CLASSES: " + className, e);
                    }
                }
            }
            LogChannel.GENERAL.logDetailed("Registered " + registry.getPlugins(pluginType.getClass()).size() + " plugins of type '" + pluginType.getName() + "' in " + (System.currentTimeMillis() - startScan) + "ms.");
        }
        JarFileCache.getInstance().clear();
    }

    public String getPluginId(Object pluginClass) {
        for (Class<? extends PluginTypeInterface> pluginType : this.getPluginTypes()) {
            String id = this.getPluginId(pluginType, pluginClass);
            if (id == null) continue;
            return id;
        }
        return null;
    }

    public String getPluginId(Class<? extends PluginTypeInterface> pluginType, Object pluginClass) {
        String className = pluginClass.getClass().getName();
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            for (String check : plugin.getClassMap().values()) {
                if (check == null || !check.equals(className)) continue;
                return plugin.getIds()[0];
            }
        }
        return null;
    }

    public PluginInterface getPlugin(Class<? extends PluginTypeInterface> pluginType, Object pluginClass) {
        String pluginId = this.getPluginId(pluginType, pluginClass);
        if (pluginId == null) {
            return null;
        }
        return this.getPlugin(pluginType, pluginId);
    }

    public PluginInterface findPluginWithName(Class<? extends PluginTypeInterface> pluginType, String pluginName) {
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            if (!plugin.getName().equals(pluginName)) continue;
            return plugin;
        }
        return null;
    }

    public PluginInterface findPluginWithDescription(Class<? extends PluginTypeInterface> pluginType, String pluginDescription) {
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            if (!plugin.getDescription().equals(pluginDescription)) continue;
            return plugin;
        }
        return null;
    }

    public PluginInterface findPluginWithId(Class<? extends PluginTypeInterface> pluginType, String pluginId) {
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            if (!plugin.matches(pluginId)) continue;
            return plugin;
        }
        return null;
    }

    public List<String> getPluginPackages(Class<? extends PluginTypeInterface> pluginType) {
        ArrayList<String> list = new ArrayList<String>();
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            for (String className : plugin.getClassMap().values()) {
                int lastIndex;
                String packageName = className.substring(0, lastIndex = className.lastIndexOf("."));
                if (list.contains(packageName)) continue;
                list.add(packageName);
            }
        }
        Collections.sort(list);
        return list;
    }

    private RowMetaInterface getPluginInformationRowMeta() {
        RowMeta row = new RowMeta();
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Type.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.ID.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Name.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Description.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Libraries.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.ImageFile.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.ClassName.Label", new String[0]), 2));
        row.addValueMeta(new ValueMeta(BaseMessages.getString(PKG, "PluginRegistry.Information.Category.Label", new String[0]), 2));
        return row;
    }

    public RowBuffer getPluginInformation(Class<? extends PluginTypeInterface> pluginType) {
        RowBuffer rowBuffer = new RowBuffer(this.getPluginInformationRowMeta());
        for (PluginInterface plugin : this.getPlugins(pluginType)) {
            Object[] row = new Object[this.getPluginInformationRowMeta().size()];
            int rowIndex = 0;
            row[rowIndex++] = plugin.getPluginType().getName();
            row[rowIndex++] = plugin.getIds()[0];
            row[rowIndex++] = plugin.getName();
            row[rowIndex++] = plugin.getDescription();
            row[rowIndex++] = plugin.getLibraries().toString();
            row[rowIndex++] = plugin.getImageFile();
            row[rowIndex++] = plugin.getClassMap().values().toString();
            row[rowIndex++] = plugin.getCategory();
            rowBuffer.getBuffer().add(row);
        }
        return rowBuffer;
    }

    public <T> T getClass(PluginInterface plugin, String className) throws KettlePluginException {
        try {
            if (plugin.isNativePlugin()) {
                return (T)Class.forName(className);
            }
            URLClassLoader ucl = null;
            Map<PluginInterface, URLClassLoader> classLoaders = this.classLoaderMap.get(plugin.getPluginType());
            if (classLoaders == null) {
                classLoaders = new HashMap<PluginInterface, URLClassLoader>();
                this.classLoaderMap.put(plugin.getPluginType(), classLoaders);
            } else {
                ucl = classLoaders.get(plugin);
            }
            if (ucl == null && plugin.getPluginDirectory() != null) {
                ucl = this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                classLoaders.put(plugin, ucl);
            }
            if (ucl == null) {
                throw new KettlePluginException("Unable to find class loader for plugin: " + plugin);
            }
            return (T)ucl.loadClass(className);
        }
        catch (Exception e) {
            throw new KettlePluginException("Unexpected error loading class with name: " + className, e);
        }
    }

    public <T> T getClass(PluginInterface plugin, T classType) throws KettlePluginException {
        String className = plugin.getClassMap().get(classType);
        return (T)this.getClass(plugin, (T)className);
    }

    public ClassLoader getClassLoader(PluginInterface plugin) throws KettlePluginException {
        if (plugin == null) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.NoValidStepOrPlugin.PLUGINREGISTRY001", new String[0]));
        }
        try {
            if (plugin.isNativePlugin()) {
                return this.getClass().getClassLoader();
            }
            List<String> jarfiles = plugin.getLibraries();
            URL[] urls = new URL[jarfiles.size()];
            for (int i = 0; i < jarfiles.size(); ++i) {
                File jarfile = new File(jarfiles.get(i));
                urls[i] = new URL(URLDecoder.decode(jarfile.toURI().toURL().toString(), "UTF-8"));
            }
            ClassLoader classLoader = this.getClass().getClassLoader();
            URLClassLoader ucl = null;
            if (plugin.isSeparateClassLoaderNeeded()) {
                ucl = new KettleURLClassLoader(urls, classLoader, plugin.getDescription());
            } else {
                Map<PluginInterface, URLClassLoader> classLoaders = this.classLoaderMap.get(plugin.getPluginType());
                if (classLoaders == null) {
                    classLoaders = new HashMap<PluginInterface, URLClassLoader>();
                    this.classLoaderMap.put(plugin.getPluginType(), classLoaders);
                } else {
                    ucl = classLoaders.get(plugin);
                }
                if (ucl == null) {
                    if (plugin.getPluginDirectory() != null) {
                        ucl = this.folderBasedClassLoaderMap.get(plugin.getPluginDirectory().toString());
                        if (ucl == null) {
                            ucl = new KettleURLClassLoader(urls, classLoader, plugin.getDescription());
                            classLoaders.put(plugin, ucl);
                            this.folderBasedClassLoaderMap.put(plugin.getPluginDirectory().toString(), ucl);
                        }
                    } else {
                        ucl = classLoaders.get(plugin);
                        if (ucl == null) {
                            ucl = new KettleURLClassLoader(urls, classLoader, plugin.getDescription());
                            classLoaders.put(plugin, ucl);
                        }
                    }
                }
            }
            return ucl;
        }
        catch (MalformedURLException e) {
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.MalformedURL.PLUGINREGISTRY006", new String[0]), e);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new KettlePluginException(BaseMessages.getString(PKG, "PluginRegistry.RuntimeError.UnExpectedCreatingClassLoader.PLUGINREGISTRY008", new String[0]), e);
        }
    }

    static {
        pluginTypes = new ArrayList<PluginTypeInterface>();
    }
}

