/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.version.BuildVersion;

public class EnvUtil {
    private static Properties env = null;

    public static Properties readProperties(String fileName) throws KettleException {
        Properties props = new Properties();
        String kettlePropsFilename = Const.getKettleDirectory() + Const.FILE_SEPARATOR + fileName;
        FileInputStream is = null;
        try {
            is = new FileInputStream(kettlePropsFilename);
            props.load(is);
        }
        catch (IOException ioe) {
            throw new KettleException("Unable to read file '" + kettlePropsFilename + "'", ioe);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException e) {}
            }
        }
        return props;
    }

    public static void environmentInit() throws KettleException {
        if (Thread.currentThread().getContextClassLoader() == null) {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
        }
        Properties kettleProperties = EnvUtil.readProperties("kettle.properties");
        Variables variables = new Variables();
        for (Object key : kettleProperties.keySet()) {
            String variable = (String)key;
            String value = variables.environmentSubstitute((String)kettleProperties.get(key));
            variables.setVariable(variable, value);
        }
        for (String variable : variables.listVariables()) {
            System.setProperty(variable, variables.getVariable(variable));
        }
        System.getProperties().put("Internal.Cluster.Size", "1");
        System.getProperties().put("Internal.Slave.Transformation.Number", "0");
        System.getProperties().put("Internal.Slave.Server.Name", "slave-trans-name");
        System.getProperties().put("Internal.Step.CopyNr", "0");
        System.getProperties().put("Internal.Step.Name", "step-name");
        System.getProperties().put("Internal.Step.Partition.ID", "partition-id");
        System.getProperties().put("Internal.Step.Partition.Number", "0");
        System.getProperties().put("Internal.Step.Unique.Count", "1");
        System.getProperties().put("Internal.Step.Unique.Number", "0");
    }

    public static void addInternalVariables(Properties prop) {
        prop.put("Internal.Kettle.Version", "4.4.0");
        prop.put("Internal.Kettle.Build.Version", BuildVersion.getInstance().getVersion());
        prop.put("Internal.Kettle.Build.Date", BuildVersion.getInstance().getBuildDate());
    }

    private static final Properties getEnv() {
        Class<System> system = System.class;
        if (env == null) {
            Map returnMap = null;
            try {
                Method method = system.getMethod("getenv", new Class[0]);
                returnMap = (Map)method.invoke(system, new Object[0]);
            }
            catch (Exception ex) {
                returnMap = null;
            }
            env = new Properties();
            if (returnMap != null) {
                ArrayList list = new ArrayList(returnMap.keySet());
                for (int i = 0; i < list.size(); ++i) {
                    String var = (String)list.get(i);
                    String val = (String)returnMap.get(var);
                    env.setProperty(var, val);
                }
            }
        }
        return env;
    }

    public static final String[] getEnvironmentVariablesForRuntimeExec() {
        Properties sysprops = new Properties();
        sysprops.putAll((Map<?, ?>)EnvUtil.getEnv());
        sysprops.putAll((Map<?, ?>)System.getProperties());
        EnvUtil.addInternalVariables(sysprops);
        String[] envp = new String[sysprops.size()];
        ArrayList<Object> list = new ArrayList<Object>(sysprops.keySet());
        for (int i = 0; i < list.size(); ++i) {
            String var = (String)list.get(i);
            String val = sysprops.getProperty(var);
            envp[i] = var + "=" + val;
        }
        return envp;
    }

    public static final String getSystemPropertyStripQuotes(String key, String def) {
        String value = System.getProperty(key, def);
        if (value.startsWith("\"") && value.endsWith("\"") && value.length() > 1) {
            return value.substring(1, value.length() - 2);
        }
        return value;
    }

    public static final String getSystemProperty(String key, String def) {
        String value = System.getProperty(key, def);
        return value;
    }

    public static final String getSystemProperty(String key) {
        return EnvUtil.getSystemProperty(key, null);
    }

    public static Locale createLocale(String localeCode) {
        Locale resultLocale = null;
        if (localeCode != null) {
            StringTokenizer parser = new StringTokenizer(localeCode, "_");
            resultLocale = parser.countTokens() == 2 ? new Locale(parser.nextToken(), parser.nextToken()) : new Locale(localeCode);
        }
        return resultLocale;
    }
}

